/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.Setting;

public class MaxRetryAllocationDecider
extends AllocationDecider {
    public static final Setting<Integer> SETTING_ALLOCATION_MAX_RETRY = Setting.intSetting("index.allocation.max_retries", 5, 0, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.NotCopyableOnResize);
    public static final String NAME = "max_retry";
    private static final Decision YES_NO_FAILURES = Decision.single(Decision.Type.YES, "max_retry", "shard has no previous failures", new Object[0]);

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        int numFailedAllocations;
        UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
        int n = numFailedAllocations = unassignedInfo == null ? 0 : unassignedInfo.getNumFailedAllocations();
        if (numFailedAllocations > 0) {
            return MaxRetryAllocationDecider.decisionWithFailures(shardRouting, allocation, unassignedInfo, numFailedAllocations);
        }
        return YES_NO_FAILURES;
    }

    private static Decision decisionWithFailures(ShardRouting shardRouting, RoutingAllocation allocation, UnassignedInfo unassignedInfo, int numFailedAllocations) {
        IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shardRouting.index());
        int maxRetry = SETTING_ALLOCATION_MAX_RETRY.get(indexMetadata.getSettings());
        Decision res = numFailedAllocations >= maxRetry ? Decision.NO : Decision.YES;
        return allocation.debugDecision() ? MaxRetryAllocationDecider.debugDecision(res, unassignedInfo, numFailedAllocations, maxRetry) : res;
    }

    private static Decision debugDecision(Decision decision, UnassignedInfo unassignedInfo, int numFailedAllocations, int maxRetry) {
        if (decision.type() == Decision.Type.YES) {
            return Decision.single(Decision.Type.NO, NAME, "shard has exceeded the maximum number of retries [%d] on failed allocation attempts - manually call [/_cluster/reroute?retry_failed=true] to retry, [%s]", maxRetry, unassignedInfo.toString());
        }
        return Decision.single(Decision.Type.YES, NAME, "shard has failed allocating [%d] times but [%d] retries are allowed", numFailedAllocations, maxRetry);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, allocation);
    }

    @Override
    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call canForceAllocatePrimary on a non-primary shard " + shardRouting;
        return this.canAllocate(shardRouting, node, allocation);
    }

    @Override
    public Decision canForceAllocateDuringReplace(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, node, allocation);
    }
}

