/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.post;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.post.SimulateIndexTemplateResponse;
import org.elasticsearch.action.admin.indices.template.post.SimulateTemplateAction;
import org.elasticsearch.action.admin.indices.template.post.TransportSimulateIndexTemplateAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class TransportSimulateTemplateAction
extends TransportMasterNodeReadAction<SimulateTemplateAction.Request, SimulateIndexTemplateResponse> {
    private final MetadataIndexTemplateService indexTemplateService;
    private final NamedXContentRegistry xContentRegistry;
    private final IndicesService indicesService;
    private AliasValidator aliasValidator;

    @Inject
    public TransportSimulateTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry xContentRegistry, IndicesService indicesService) {
        super("indices:admin/index_template/simulate", transportService, clusterService, threadPool, actionFilters, SimulateTemplateAction.Request::new, indexNameExpressionResolver, SimulateIndexTemplateResponse::new, "same");
        this.indexTemplateService = indexTemplateService;
        this.xContentRegistry = xContentRegistry;
        this.indicesService = indicesService;
        this.aliasValidator = new AliasValidator();
    }

    @Override
    protected void masterOperation(SimulateTemplateAction.Request request, ClusterState state, ActionListener<SimulateIndexTemplateResponse> listener) throws Exception {
        ClusterState stateWithTemplate;
        String simulateTemplateToAdd;
        String uuid = UUIDs.randomBase64UUID().toLowerCase(Locale.ROOT);
        String temporaryIndexName = "simulate_template_index_" + uuid;
        if (request.getIndexTemplateRequest() != null) {
            simulateTemplateToAdd = request.getTemplateName() == null ? "simulate_template_" + uuid : request.getTemplateName();
            MetadataIndexTemplateService.validateV2TemplateRequest(state.metadata(), simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate());
            stateWithTemplate = this.indexTemplateService.addIndexTemplateV2(state, request.getIndexTemplateRequest().create(), simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate());
        } else {
            simulateTemplateToAdd = null;
            stateWithTemplate = state;
        }
        String matchingTemplate = request.getTemplateName() == null ? simulateTemplateToAdd : request.getTemplateName();
        if (matchingTemplate == null) {
            listener.onFailure(new IllegalArgumentException("a template name to match or a new template body must be specified"));
            return;
        }
        if (!stateWithTemplate.metadata().templatesV2().containsKey(matchingTemplate)) {
            listener.onFailure(new IllegalArgumentException("unable to simulate template [" + matchingTemplate + "] that does not exist"));
            return;
        }
        ClusterState tempClusterState = TransportSimulateIndexTemplateAction.resolveTemporaryState(matchingTemplate, temporaryIndexName, stateWithTemplate);
        ComposableIndexTemplate templateV2 = tempClusterState.metadata().templatesV2().get(matchingTemplate);
        assert (templateV2 != null) : "the matched template must exist";
        HashMap<String, List<String>> overlapping = new HashMap<String, List<String>>();
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV1Templates(tempClusterState, matchingTemplate, templateV2.indexPatterns()));
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV2Templates(tempClusterState, matchingTemplate, templateV2.indexPatterns()));
        Template template = TransportSimulateIndexTemplateAction.resolveTemplate(matchingTemplate, temporaryIndexName, stateWithTemplate, this.xContentRegistry, this.indicesService, this.aliasValidator);
        listener.onResponse(new SimulateIndexTemplateResponse(template, overlapping));
    }

    @Override
    protected ClusterBlockException checkBlock(SimulateTemplateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

