/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.JavaFrontend;
import org.sonar.java.Measurer;
import org.sonar.java.SonarComponents;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.checks.CheckList;
import org.sonar.java.filters.PostAnalysisIssueFilter;
import org.sonar.java.jsp.Jasper;
import org.sonar.java.model.GeneratedFile;
import org.sonar.java.model.JavaVersionImpl;
import org.sonar.java.se.SymbolicExecutionVisitor;
import org.sonar.java.se.checks.SECheck;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaResourceLocator;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonarsource.performance.measure.PerformanceMeasure;

@Phase(name=Phase.Name.PRE)
public class JavaSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(JavaSensor.class);
    private static final String PERFORMANCE_MEASURE_ACTIVATION_PROPERTY = "sonar.java.performance.measure";
    private static final String PERFORMANCE_MEASURE_FILE_PATH_PROPERTY = "sonar.java.performance.measure.path";
    private static final String PERFORMANCE_MEASURE_DESTINATION_FILE = "sonar.java.performance.measure.json";
    private final SonarComponents sonarComponents;
    private final FileSystem fs;
    private final JavaResourceLocator javaResourceLocator;
    private final Configuration settings;
    private final NoSonarFilter noSonarFilter;
    @Nullable
    private final Jasper jasper;
    private final PostAnalysisIssueFilter postAnalysisIssueFilter;

    public JavaSensor(SonarComponents sonarComponents, FileSystem fs, JavaResourceLocator javaResourceLocator, Configuration settings, NoSonarFilter noSonarFilter, PostAnalysisIssueFilter postAnalysisIssueFilter) {
        this(sonarComponents, fs, javaResourceLocator, settings, noSonarFilter, postAnalysisIssueFilter, null);
    }

    public JavaSensor(SonarComponents sonarComponents, FileSystem fs, JavaResourceLocator javaResourceLocator, Configuration settings, NoSonarFilter noSonarFilter, PostAnalysisIssueFilter postAnalysisIssueFilter, @Nullable Jasper jasper) {
        this.noSonarFilter = noSonarFilter;
        this.sonarComponents = sonarComponents;
        this.fs = fs;
        this.javaResourceLocator = javaResourceLocator;
        this.settings = settings;
        this.postAnalysisIssueFilter = postAnalysisIssueFilter;
        this.jasper = jasper;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("java").name("JavaSensor");
    }

    public void execute(SensorContext context) {
        PerformanceMeasure.Duration sensorDuration = JavaSensor.createPerformanceMeasureReport(context);
        this.sonarComponents.setSensorContext(context);
        this.sonarComponents.registerMainCheckClasses("java", CheckList.getJavaChecks());
        this.sonarComponents.registerTestCheckClasses("java", CheckList.getJavaTestChecks());
        Measurer measurer = new Measurer(context, this.noSonarFilter);
        JavaFrontend frontend = new JavaFrontend(this.getJavaVersion(), this.sonarComponents, measurer, this.javaResourceLocator, this.postAnalysisIssueFilter, JavaSensor.insertSymbolicExecutionVisitor(this.sonarComponents.mainChecks()));
        frontend.scan(this.getSourceFiles(), this.getTestFiles(), this.runJasper(context));
        sensorDuration.stop();
    }

    private static PerformanceMeasure.Duration createPerformanceMeasureReport(SensorContext context) {
        return PerformanceMeasure.reportBuilder().activate(context.config().get(PERFORMANCE_MEASURE_ACTIVATION_PROPERTY).filter("true"::equals).isPresent()).toFile(context.config().get(PERFORMANCE_MEASURE_FILE_PATH_PROPERTY).filter(path -> !path.isEmpty()).orElseGet(() -> Optional.ofNullable(context.fileSystem().workDir()).filter(File::exists).map(file -> file.toPath().resolve(PERFORMANCE_MEASURE_DESTINATION_FILE).toString()).orElse(null))).appendMeasurementCost().start("JavaSensor");
    }

    @VisibleForTesting
    static JavaCheck[] insertSymbolicExecutionVisitor(List<JavaCheck> checks) {
        List<SECheck> seChecks = checks.stream().filter(SECheck.class::isInstance).map(SECheck.class::cast).collect(Collectors.toList());
        if (seChecks.isEmpty()) {
            return checks.toArray(new JavaCheck[0]);
        }
        ArrayList<JavaCheck> newList = new ArrayList<JavaCheck>(checks);
        newList.add(newList.indexOf(seChecks.get(0)), new SymbolicExecutionVisitor(seChecks));
        return newList.toArray(new JavaCheck[0]);
    }

    private Collection<GeneratedFile> runJasper(SensorContext context) {
        if (this.sonarComponents.isBatchModeEnabled()) {
            return Collections.emptyList();
        }
        return this.jasper != null ? this.jasper.generateFiles(context, this.sonarComponents.getJavaClasspath()) : Collections.emptyList();
    }

    private Iterable<InputFile> getSourceFiles() {
        return this.javaFiles(InputFile.Type.MAIN);
    }

    private Iterable<InputFile> getTestFiles() {
        return this.javaFiles(InputFile.Type.TEST);
    }

    private Iterable<InputFile> javaFiles(InputFile.Type type) {
        return this.fs.inputFiles(this.fs.predicates().and(this.fs.predicates().hasLanguage("java"), this.fs.predicates().hasType(type)));
    }

    private JavaVersion getJavaVersion() {
        JavaVersion javaVersion = JavaVersionImpl.fromString(this.settings.get("sonar.java.source").orElse(null));
        LOG.info("Configured Java source version (sonar.java.source): " + javaVersion);
        return javaVersion;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

