/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionAnnotationLoader;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.checks.CheckList;
import org.sonar.plugins.java.JavaSonarWayProfile;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;
import org.sonarsource.analyzer.commons.collections.SetUtils;

public class JavaRulesDefinition
implements RulesDefinition {
    private static final String RESOURCE_BASE_PATH = "/org/sonar/l10n/java/rules/java";
    private static final Gson GSON = new Gson();
    private static final Set<String> TEMPLATE_RULE_KEY = SetUtils.immutableSetOf("S124", "S2253", "S3688", "S3546", "S4011");

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository("java", "java").setName("SonarAnalyzer");
        List<Class<?>> checks = CheckList.getChecks();
        new RulesDefinitionAnnotationLoader().load((RulesDefinition.NewExtendedRepository)repository, checks.toArray(new Class[0]));
        JavaSonarWayProfile.Profile profile = JavaSonarWayProfile.readProfile();
        for (Class<?> ruleClass : checks) {
            this.newRule(ruleClass, repository, profile);
        }
        repository.done();
    }

    @VisibleForTesting
    protected void newRule(Class<?> ruleClass, RulesDefinition.NewRepository repository, JavaSonarWayProfile.Profile profile) {
        Rule ruleAnnotation = (Rule)AnnotationUtils.getAnnotation(ruleClass, Rule.class);
        if (ruleAnnotation == null) {
            throw new IllegalArgumentException("No Rule annotation was found on " + ruleClass);
        }
        String ruleKey = ruleAnnotation.key();
        if (StringUtils.isEmpty(ruleKey)) {
            throw new IllegalArgumentException("No key is defined in Rule annotation of " + ruleClass);
        }
        RulesDefinition.NewRule rule = repository.rule(ruleKey);
        if (rule == null) {
            throw new IllegalStateException("No rule was created for " + ruleClass + " in " + repository.key());
        }
        DeprecatedRuleKey deprecatedRuleKeyAnnotation = (DeprecatedRuleKey)AnnotationUtils.getAnnotation(ruleClass, DeprecatedRuleKey.class);
        if (deprecatedRuleKeyAnnotation != null) {
            rule.addDeprecatedRuleKey(deprecatedRuleKeyAnnotation.repositoryKey(), deprecatedRuleKeyAnnotation.ruleKey());
        } else {
            rule.addDeprecatedRuleKey("squid", ruleKey);
        }
        String rspecKey = JavaRulesDefinition.rspecKey(ruleClass, rule);
        RuleMetadata ruleMetadata = JavaRulesDefinition.readRuleMetadata(rspecKey);
        JavaRulesDefinition.addMetadata(rule, ruleMetadata);
        String ruleHtmlDescription = JavaRulesDefinition.readRuleHtmlDescription(rspecKey);
        if (ruleHtmlDescription != null) {
            rule.setHtmlDescription(ruleHtmlDescription);
        }
        boolean activatedInProfile = profile.ruleKeys.contains(ruleKey) || profile.ruleKeys.contains(rspecKey);
        boolean isSecurityHotspot = ruleMetadata != null && ruleMetadata.isSecurityHotspot();
        rule.setActivatedByDefault(activatedInProfile && !isSecurityHotspot);
        rule.setTemplate(TEMPLATE_RULE_KEY.contains(ruleKey));
    }

    private static String rspecKey(Class<?> ruleClass, RulesDefinition.NewRule rule) {
        RspecKey rspecKeyAnnotation = (RspecKey)AnnotationUtils.getAnnotation(ruleClass, RspecKey.class);
        if (rspecKeyAnnotation != null) {
            String rspecKey = rspecKeyAnnotation.value();
            rule.setInternalKey(rspecKey);
            return rspecKey;
        }
        return rule.key();
    }

    @Nullable
    static RuleMetadata readRuleMetadata(String metadataKey) {
        URL resource = JavaRulesDefinition.class.getResource("/org/sonar/l10n/java/rules/java/" + metadataKey + "_java.json");
        return resource != null ? GSON.fromJson(JavaRulesDefinition.readResource(resource), RuleMetadata.class) : null;
    }

    private static String readRuleHtmlDescription(String metadataKey) {
        URL resource = JavaRulesDefinition.class.getResource("/org/sonar/l10n/java/rules/java/" + metadataKey + "_java.html");
        if (resource != null) {
            return JavaRulesDefinition.readResource(resource);
        }
        return null;
    }

    private static void addMetadata(RulesDefinition.NewRule rule, @Nullable RuleMetadata metadata) {
        if (metadata == null) {
            return;
        }
        rule.setSeverity(metadata.defaultSeverity.toUpperCase(Locale.US));
        rule.setName(metadata.title);
        rule.addTags(metadata.tags);
        rule.setType(RuleType.valueOf((String)metadata.type));
        rule.setStatus(RuleStatus.valueOf((String)metadata.status.toUpperCase(Locale.US)));
        if (metadata.remediation != null) {
            rule.setDebtRemediationFunction(metadata.remediation.remediationFunction(rule.debtRemediationFunctions()));
            rule.setGapDescription(metadata.remediation.linearDesc);
        }
        JavaRulesDefinition.addSecurityStandards(rule, metadata.securityStandards);
    }

    private static void addSecurityStandards(RulesDefinition.NewRule rule, SecurityStandards securityStandards) {
        for (String s : securityStandards.OWASP) {
            rule.addOwaspTop10(new RulesDefinition.OwaspTop10[]{RulesDefinition.OwaspTop10.valueOf((String)s)});
        }
        rule.addCwe(securityStandards.CWE);
    }

    private static String readResource(URL resource) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));
        try {
            string = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read: " + resource, e);
            }
        }
        reader.close();
        return string;
    }

    static class RuleMetadata {
        private static final String SECURITY_HOTSPOT = "SECURITY_HOTSPOT";
        String title;
        String status;
        @Nullable
        Remediation remediation;
        String type;
        String[] tags;
        String defaultSeverity;
        SecurityStandards securityStandards = new SecurityStandards();

        RuleMetadata() {
        }

        boolean isSecurityHotspot() {
            return SECURITY_HOTSPOT.equals(this.type);
        }
    }

    private static class Remediation {
        String func;
        String constantCost;
        String linearDesc;
        String linearOffset;
        String linearFactor;

        private Remediation() {
        }

        public DebtRemediationFunction remediationFunction(RulesDefinition.DebtRemediationFunctions drf) {
            if (this.func.startsWith("Constant")) {
                return drf.constantPerIssue(this.constantCost.replace("mn", "min"));
            }
            if ("Linear".equals(this.func)) {
                return drf.linear(this.linearFactor.replace("mn", "min"));
            }
            return drf.linearWithOffset(this.linearFactor.replace("mn", "min"), this.linearOffset.replace("mn", "min"));
        }
    }

    static class SecurityStandards {
        int[] CWE = new int[0];
        String[] OWASP = new String[0];

        SecurityStandards() {
        }
    }
}

