/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.tree.ExpressionTree;

public interface XxeProperty {
    public static final String UNSECURED_USE_EMPTY_STRING_TO_PROTECT_AGAINST_XXE = "unsecured. Set to \"\" (empty string) to protect against XXE";

    public XxePropertyHolder properties();

    default public boolean isNamed(String name) {
        return this.properties().propertyName.equals(name);
    }

    default public Constraint securedConstraint() {
        return this.properties().secured;
    }

    default public Constraint namedConstraint() {
        return this.properties().named;
    }

    default public boolean isSecuring(@Nullable SymbolicValue sv1, ExpressionTree arg1) {
        return this.properties().securing.test(sv1, arg1);
    }

    default public Constraint unsecuredConstraint() {
        return this.properties().unsecured;
    }

    default public boolean isUnsecuring(@Nullable SymbolicValue sv1, ExpressionTree arg1) {
        return this.properties().unsecuring.test(sv1, arg1);
    }

    public static boolean isSetToEmptyString(@Nullable SymbolicValue sv1, ExpressionTree arg1) {
        return arg1.asConstant(String.class).filter(String::isEmpty).isPresent();
    }

    public static boolean isSetToNonEmptyString(@Nullable SymbolicValue sv1, ExpressionTree arg1) {
        return !XxeProperty.isSetToEmptyString(sv1, arg1);
    }

    public static boolean isSetToFalse(@Nullable SymbolicValue sv1, ExpressionTree arg1) {
        return sv1 == SymbolicValue.FALSE_LITERAL || arg1.asConstant(String.class).filter("false"::equalsIgnoreCase).isPresent();
    }

    public static boolean isSetToTrue(@Nullable SymbolicValue sv1, ExpressionTree arg1) {
        return sv1 == SymbolicValue.TRUE_LITERAL || arg1.asConstant(String.class).filter("true"::equalsIgnoreCase).isPresent();
    }

    public static class XxePropertyHolder {
        private final String propertyName;
        private final BiPredicate<SymbolicValue, ExpressionTree> securing;
        private final Constraint secured;
        private final BiPredicate<SymbolicValue, ExpressionTree> unsecuring;
        private final Constraint unsecured;
        private final Constraint named;

        public XxePropertyHolder(String propertyName, Constraint named, BiPredicate<SymbolicValue, ExpressionTree> securing, Constraint secured, BiPredicate<SymbolicValue, ExpressionTree> unsecuring, Constraint unsecured) {
            this.propertyName = propertyName;
            this.named = named;
            this.securing = securing;
            this.secured = secured;
            this.unsecuring = unsecuring;
            this.unsecured = unsecured;
        }
    }

    public static enum FeatureExternalGeneralEntities implements Constraint,
    XxeProperty
    {
        UNSECURED,
        SECURED,
        NAMED;

        private static final XxePropertyHolder PROPERTIES;

        @Override
        public XxePropertyHolder properties() {
            return PROPERTIES;
        }

        static {
            PROPERTIES = new XxePropertyHolder("http://xml.org/sax/features/external-general-entities", NAMED, XxeProperty::isSetToFalse, SECURED, XxeProperty::isSetToTrue, UNSECURED);
        }
    }

    public static enum FeatureLoadExternalDtd implements Constraint,
    XxeProperty
    {
        UNSECURED,
        SECURED,
        NAMED;

        private static final XxePropertyHolder PROPERTIES;

        @Override
        public XxePropertyHolder properties() {
            return PROPERTIES;
        }

        static {
            PROPERTIES = new XxePropertyHolder("http://apache.org/xml/features/nonvalidating/load-external-dtd", NAMED, XxeProperty::isSetToFalse, SECURED, XxeProperty::isSetToTrue, UNSECURED);
        }
    }

    public static enum FeatureDisallowDoctypeDecl implements Constraint,
    XxeProperty
    {
        UNSECURED,
        SECURED,
        NAMED;

        private static final XxePropertyHolder PROPERTIES;

        @Override
        public XxePropertyHolder properties() {
            return PROPERTIES;
        }

        static {
            PROPERTIES = new XxePropertyHolder("http://apache.org/xml/features/disallow-doctype-decl", NAMED, XxeProperty::isSetToTrue, SECURED, XxeProperty::isSetToFalse, UNSECURED);
        }
    }

    public static enum FeatureIsSupportingExternalEntities implements Constraint,
    XxeProperty
    {
        UNSECURED,
        SECURED,
        NAMED;

        private static final XxePropertyHolder PROPERTIES;

        @Override
        public XxePropertyHolder properties() {
            return PROPERTIES;
        }

        static {
            PROPERTIES = new XxePropertyHolder("javax.xml.stream.isSupportingExternalEntities", NAMED, XxeProperty::isSetToFalse, SECURED, XxeProperty::isSetToTrue, UNSECURED);
        }
    }

    public static enum FeatureSupportDtd implements Constraint,
    XxeProperty
    {
        UNSECURED,
        SECURED,
        NAMED;

        private static final XxePropertyHolder PROPERTIES;

        @Override
        public XxePropertyHolder properties() {
            return PROPERTIES;
        }

        static {
            PROPERTIES = new XxePropertyHolder("javax.xml.stream.supportDTD", NAMED, XxeProperty::isSetToFalse, SECURED, XxeProperty::isSetToTrue, UNSECURED);
        }
    }

    public static enum AttributeStyleSheet implements Constraint,
    XxeProperty
    {
        UNSECURED,
        SECURED,
        NAMED;

        private static final XxePropertyHolder PROPERTIES;

        @Override
        public XxePropertyHolder properties() {
            return PROPERTIES;
        }

        @Override
        public String valueAsString() {
            return XxeProperty.UNSECURED_USE_EMPTY_STRING_TO_PROTECT_AGAINST_XXE;
        }

        static {
            PROPERTIES = new XxePropertyHolder("http://javax.xml.XMLConstants/property/accessExternalStylesheet", NAMED, XxeProperty::isSetToEmptyString, SECURED, XxeProperty::isSetToNonEmptyString, UNSECURED);
        }
    }

    public static enum AttributeSchema implements Constraint,
    XxeProperty
    {
        UNSECURED,
        SECURED,
        NAMED;

        private static final XxePropertyHolder PROPERTIES;

        @Override
        public XxePropertyHolder properties() {
            return PROPERTIES;
        }

        @Override
        public String valueAsString() {
            return XxeProperty.UNSECURED_USE_EMPTY_STRING_TO_PROTECT_AGAINST_XXE;
        }

        static {
            PROPERTIES = new XxePropertyHolder("http://javax.xml.XMLConstants/property/accessExternalSchema", NAMED, XxeProperty::isSetToEmptyString, SECURED, XxeProperty::isSetToNonEmptyString, UNSECURED);
        }
    }

    public static enum AttributeDTD implements Constraint,
    XxeProperty
    {
        UNSECURED,
        SECURED,
        NAMED;

        private static final XxePropertyHolder PROPERTIES;

        @Override
        public XxePropertyHolder properties() {
            return PROPERTIES;
        }

        @Override
        public String valueAsString() {
            return XxeProperty.UNSECURED_USE_EMPTY_STRING_TO_PROTECT_AGAINST_XXE;
        }

        static {
            PROPERTIES = new XxePropertyHolder("http://javax.xml.XMLConstants/property/accessExternalDTD", NAMED, XxeProperty::isSetToEmptyString, SECURED, XxeProperty::isSetToNonEmptyString, UNSECURED);
        }
    }
}

