/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.Preconditions;
import org.sonar.java.cfg.CFG;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.Flow;
import org.sonar.java.se.LearnedAssociation;
import org.sonar.java.se.LearnedConstraint;
import org.sonar.java.se.ProgramPoint;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.SyntaxTreeNameFinder;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.BinarySymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.java.se.xproc.HappyPathYield;
import org.sonar.java.se.xproc.MethodBehavior;
import org.sonar.java.se.xproc.MethodYield;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.collections.ListUtils;
import org.sonarsource.analyzer.commons.collections.PCollections;
import org.sonarsource.analyzer.commons.collections.PSet;

public class FlowComputation {
    private static final String IMPLIES_IS_MSG = "Implies '%s' is %s.";
    private static final String IMPLIES_CAN_BE_MSG = "Implies '%s' can be %s.";
    private static final String IMPLIES_SAME_VALUE = "Implies '%s' has the same value as '%s'.";
    private static final int MAX_FLOW_STEPS = 3000000;
    public static final int FIRST_FLOW = 1;
    public static final int MAX_REPORTED_FLOWS = 20;
    public static final int MAX_LOOKUP_FLOWS = 500000;
    private static final Logger LOG = Loggers.get(FlowComputation.class);
    private final Predicate<Constraint> addToFlow;
    private final Predicate<Constraint> terminateTraversal;
    private final Set<SymbolicValue> symbolicValues;
    private final List<Class<? extends Constraint>> domains;
    private final boolean skipExceptionMessages;
    private final int maxReturnedFlows;

    private FlowComputation(Set<SymbolicValue> symbolicValues, Predicate<Constraint> addToFlow, Predicate<Constraint> terminateTraversal, List<Class<? extends Constraint>> domains, boolean skipExceptionMessages, int maxReturnedFlows) {
        this.addToFlow = addToFlow;
        this.terminateTraversal = terminateTraversal;
        this.symbolicValues = symbolicValues;
        this.domains = domains;
        this.skipExceptionMessages = skipExceptionMessages;
        this.maxReturnedFlows = maxReturnedFlows;
    }

    private static Set<SymbolicValue> computedFrom(@Nullable SymbolicValue symbolicValue) {
        if (symbolicValue == null) {
            return Collections.emptySet();
        }
        HashSet<SymbolicValue> result = new HashSet<SymbolicValue>();
        result.add(symbolicValue);
        symbolicValue.computedFrom().forEach(sv -> result.addAll(FlowComputation.computedFrom(sv)));
        return result;
    }

    public static Set<Flow> flow(ExplodedGraph.Node currentNode, Set<SymbolicValue> symbolicValues, Predicate<Constraint> addToFlow, Predicate<Constraint> terminateTraversal, List<Class<? extends Constraint>> domains, Set<Symbol> symbols, int maxReturnedFlows) {
        return FlowComputation.flow(currentNode, symbolicValues, addToFlow, terminateTraversal, domains, symbols, false, maxReturnedFlows);
    }

    public static Set<Flow> flow(ExplodedGraph.Node currentNode, @Nullable SymbolicValue currentVal, List<Class<? extends Constraint>> domains, int maxReturnedFlows) {
        return FlowComputation.flow(currentNode, FlowComputation.setFromNullable(currentVal), constraint -> true, c -> false, domains, Collections.emptySet(), false, maxReturnedFlows);
    }

    public static Set<Flow> flow(ExplodedGraph.Node currentNode, @Nullable SymbolicValue currentVal, List<Class<? extends Constraint>> domains, @Nullable Symbol trackSymbol, int maxReturnedFlows) {
        return FlowComputation.flow(currentNode, FlowComputation.setFromNullable(currentVal), c -> true, c -> false, domains, FlowComputation.setFromNullable(trackSymbol), false, maxReturnedFlows);
    }

    public static Set<Flow> flowWithoutExceptions(ExplodedGraph.Node currentNode, @Nullable SymbolicValue currentVal, Predicate<Constraint> addToFlow, List<Class<? extends Constraint>> domains, int maxReturnedFlows) {
        return FlowComputation.flow(currentNode, FlowComputation.setFromNullable(currentVal), addToFlow, c -> false, domains, Collections.emptySet(), true, maxReturnedFlows);
    }

    public static Set<Flow> flowWithoutExceptions(ExplodedGraph.Node currentNode, @Nullable SymbolicValue currentVal, Predicate<Constraint> addToFlow, Predicate<Constraint> terminateTraversal, List<Class<? extends Constraint>> domains, int maxReturnedFlows) {
        return FlowComputation.flow(currentNode, FlowComputation.setFromNullable(currentVal), addToFlow, terminateTraversal, domains, Collections.emptySet(), true, maxReturnedFlows);
    }

    private static Set<Flow> flow(ExplodedGraph.Node currentNode, Set<SymbolicValue> symbolicValues, Predicate<Constraint> addToFlow, Predicate<Constraint> terminateTraversal, List<Class<? extends Constraint>> domains, Set<Symbol> symbols, boolean skipExceptionMessages, int maxReturnedFlows) {
        Set<SymbolicValue> allSymbolicValues = symbolicValues.stream().map(FlowComputation::computedFrom).flatMap(Collection::stream).collect(Collectors.toSet());
        PSet<Symbol> trackedSymbols = PCollections.emptySet();
        for (Symbol symbol : symbols) {
            trackedSymbols = trackedSymbols.add(symbol);
        }
        if (symbols.isEmpty()) {
            for (SymbolicValue symbolicValue : symbolicValues) {
                for (Symbol symbol : symbolicValue.computedFromSymbols()) {
                    trackedSymbols = trackedSymbols.add(symbol);
                }
            }
        }
        FlowComputation flowComputation = new FlowComputation(allSymbolicValues, addToFlow, terminateTraversal, domains, skipExceptionMessages, maxReturnedFlows);
        return flowComputation.run(currentNode, trackedSymbols);
    }

    private static <T> Set<T> setFromNullable(@Nullable T val) {
        return val == null ? Collections.emptySet() : Collections.singleton(val);
    }

    private Set<Flow> run(ExplodedGraph.Node node, PSet<Symbol> trackedSymbols) {
        HashSet<Flow> flows = new HashSet<Flow>();
        ArrayDeque workList = new ArrayDeque();
        SameConstraints sameConstraints = new SameConstraints(node, trackedSymbols, this.domains);
        node.edges().stream().flatMap(e -> this.startPath((ExplodedGraph.Edge)e, trackedSymbols, sameConstraints)).forEach(workList::push);
        int flowSteps = 0;
        HashSet visited = new HashSet(workList);
        while (!workList.isEmpty()) {
            ExecutionPath path = (ExecutionPath)workList.pop();
            if (path.finished) {
                flows.add(path.flow);
                if (flows.size() == this.maxReturnedFlows) {
                    return flows;
                }
            } else {
                path.lastEdge.parent.edges().stream().filter(path::notVisited).flatMap(edge -> path.addEdge((ExplodedGraph.Edge)edge, this.maxReturnedFlows)).forEach(ep -> {
                    if (visited.add(ep)) {
                        workList.push(ep);
                    }
                });
            }
            if (++flowSteps != 3000000) continue;
            LOG.debug("Flow was not able to complete");
            break;
        }
        return flows;
    }

    Stream<ExecutionPath> startPath(ExplodedGraph.Edge edge, PSet<Symbol> trackedSymbols, SameConstraints sameConstraints) {
        return new ExecutionPath(null, PCollections.emptySet(), trackedSymbols, sameConstraints, Flow.empty(), false).addEdge(edge, this.maxReturnedFlows);
    }

    public static Flow flowsForPassedArguments(List<Integer> argumentIndices, MethodInvocationTree mit) {
        String methodName = mit.symbol().name();
        Flow.Builder flowBuilder = Flow.builder();
        argumentIndices.stream().map(index -> FlowComputation.getArgumentIdentifier(mit, index)).filter(Objects::nonNull).map(identifierTree -> new JavaFileScannerContext.Location(String.format("'%s' is passed to '%s()'.", identifierTree.name(), methodName), (Tree)identifierTree)).forEach(flowBuilder::add);
        return flowBuilder.build().reverse();
    }

    public static Flow flowsForArgumentsChangingName(List<Integer> argumentIndices, MethodInvocationTree mit) {
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)mit.symbol();
        MethodTree declaration = methodSymbol.declaration();
        if (declaration == null) {
            return Flow.empty();
        }
        Flow.Builder flowBuilder = Flow.builder();
        List<VariableTree> methodParameters = declaration.parameters();
        for (Integer argumentIndex : argumentIndices) {
            if (JUtils.isVarArgsMethod(methodSymbol) && argumentIndex >= methodParameters.size() - 1) break;
            IdentifierTree argumentName = FlowComputation.getArgumentIdentifier(mit, argumentIndex);
            if (argumentName == null) continue;
            IdentifierTree parameterIdentifier = methodParameters.get(argumentIndex).simpleName();
            String identifierName = parameterIdentifier.name();
            if (argumentName.name().equals(identifierName)) continue;
            flowBuilder.add(new JavaFileScannerContext.Location(String.format(IMPLIES_SAME_VALUE, identifierName, argumentName.name()), parameterIdentifier));
        }
        return flowBuilder.build().reverse();
    }

    @CheckForNull
    public static IdentifierTree getArgumentIdentifier(MethodInvocationTree mit, int index) {
        Arguments arguments = mit.arguments();
        if (index < 0 || index > arguments.size()) {
            throw new IllegalArgumentException("index must be within arguments range.");
        }
        ExpressionTree expr = ExpressionUtils.skipParentheses((ExpressionTree)arguments.get(index));
        switch (expr.kind()) {
            case MEMBER_SELECT: {
                return ((MemberSelectExpressionTree)expr).identifier();
            }
            case IDENTIFIER: {
                return (IdentifierTree)expr;
            }
        }
        return null;
    }

    private static class SameConstraints {
        private final List<Class<? extends Constraint>> domains;
        private final ExplodedGraph.Node node;
        private PSet<Symbol> symbolsHavingAlwaysSameConstraints;

        SameConstraints(ExplodedGraph.Node startNode, PSet<Symbol> trackedSymbols, List<Class<? extends Constraint>> domains) {
            this.domains = domains;
            this.node = startNode;
            this.symbolsHavingAlwaysSameConstraints = PCollections.emptySet();
            this.findSymbolsHavingAlwaysSameConstraints(trackedSymbols);
        }

        SameConstraints(SameConstraints knownSameConstraints, PSet<Symbol> newTrackedSymbols) {
            this.domains = knownSameConstraints.domains;
            this.node = knownSameConstraints.node;
            this.symbolsHavingAlwaysSameConstraints = knownSameConstraints.symbolsHavingAlwaysSameConstraints;
            this.findSymbolsHavingAlwaysSameConstraints(newTrackedSymbols);
        }

        private void findSymbolsHavingAlwaysSameConstraints(PSet<Symbol> trackedSymbols) {
            trackedSymbols.forEach(symbol -> {
                if (!this.symbolsHavingAlwaysSameConstraints.contains((Symbol)symbol) && this.hasAlwaysSameConstraints((Symbol)symbol)) {
                    this.symbolsHavingAlwaysSameConstraints = this.symbolsHavingAlwaysSameConstraints.add((Symbol)symbol);
                }
            });
        }

        private boolean hasAlwaysSameConstraints(Symbol symbol) {
            return this.domains.stream().allMatch(domain -> SameConstraints.sameConstraintWhenSameProgramPoint(this.node, symbol, domain));
        }

        private static boolean sameConstraintWhenSameProgramPoint(ExplodedGraph.Node currentNode, Symbol symbol, Class<? extends Constraint> domain) {
            ProgramState programState = currentNode.programState;
            SymbolicValue sv = programState.getValue(symbol);
            if (sv == null) {
                return false;
            }
            Constraint constraint = programState.getConstraint(sv, domain);
            if (constraint == null) {
                return false;
            }
            Collection<ExplodedGraph.Node> siblingNodes = currentNode.siblings();
            return siblingNodes.stream().map(node -> node.programState).allMatch(ps -> {
                SymbolicValue siblingSV = ps.getValue(symbol);
                if (siblingSV == null) {
                    return false;
                }
                Object siblingConstraint = ps.getConstraint(siblingSV, domain);
                return constraint.equals(siblingConstraint);
            });
        }

        public boolean hasAlwaysSameConstraint(@Nullable Symbol symbol) {
            return symbol != null && this.symbolsHavingAlwaysSameConstraints.contains(symbol);
        }
    }

    private class ExecutionPath {
        final PSet<Symbol> trackedSymbols;
        final SameConstraints sameConstraints;
        final ExplodedGraph.Edge lastEdge;
        final PSet<ExplodedGraph.Edge> visited;
        final Flow flow;
        final boolean finished;

        private ExecutionPath(ExplodedGraph.Edge edge, PSet<ExplodedGraph.Edge> visited, PSet<Symbol> trackedSymbols, SameConstraints sameConstraints, Flow flow, boolean finished) {
            this.trackedSymbols = trackedSymbols;
            this.sameConstraints = sameConstraints;
            this.lastEdge = edge;
            this.visited = visited;
            this.flow = flow;
            this.finished = finished;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutionPath that = (ExecutionPath)o;
            return Objects.equals(this.trackedSymbols, that.trackedSymbols) && Objects.equals(this.lastEdge.parent, that.lastEdge.parent) && Objects.equals(this.flow, that.flow);
        }

        public int hashCode() {
            return Objects.hash(this.trackedSymbols, this.lastEdge.parent, this.flow);
        }

        Stream<ExecutionPath> addEdge(ExplodedGraph.Edge edge, int maxReturnedFlows) {
            boolean endOfPath;
            SameConstraints newSameConstraints;
            Flow.Builder flowBuilder = Flow.builder();
            flowBuilder.addAll(this.flow);
            Flow laFlow = this.learnedAssociation(edge).map(la -> this.flowFromLearnedAssociation((LearnedAssociation)la, edge.parent)).orElse(Flow.empty());
            flowBuilder.addAll(laFlow);
            PSet<Symbol> newTrackSymbols = this.newTrackedSymbols(edge);
            SameConstraints sameConstraints = newSameConstraints = newTrackSymbols == this.trackedSymbols ? this.sameConstraints : new SameConstraints(this.sameConstraints, newTrackSymbols);
            if (!FlowComputation.this.skipExceptionMessages) {
                this.flowFromThrownException(edge).ifPresent(loc -> {
                    flowBuilder.setAsExceptional();
                    flowBuilder.add((JavaFileScannerContext.Location)loc);
                });
                this.flowFromCaughtException(edge).ifPresent(loc -> {
                    flowBuilder.setAsExceptional();
                    flowBuilder.add((JavaFileScannerContext.Location)loc);
                });
            }
            Set<LearnedConstraint> learnedConstraints = this.learnedConstraints(edge);
            Flow lcFlow = this.flowFromLearnedConstraints(edge, this.filterRedundantObjectDomain(learnedConstraints));
            flowBuilder.addAll(lcFlow);
            boolean bl = endOfPath = this.visitedAllParents(edge) || this.shouldTerminate(learnedConstraints);
            if (endOfPath) {
                flowBuilder.addAll(this.flowForNullableMethodParameters(edge.parent));
            }
            Flow currentFlow = flowBuilder.build();
            Set<Flow> yieldsFlows = this.flowFromYields(edge, maxReturnedFlows);
            if (yieldsFlows.isEmpty()) {
                return Stream.of(new ExecutionPath(edge, this.visited.add(edge), newTrackSymbols, newSameConstraints, Flow.of(currentFlow), endOfPath));
            }
            return yieldsFlows.stream().map(yieldFlow -> Flow.builder().addAll(currentFlow).addAll((Flow)yieldFlow).build()).map(f -> new ExecutionPath(edge, this.visited.add(edge), newTrackSymbols, newSameConstraints, (Flow)f, endOfPath));
        }

        private Optional<JavaFileScannerContext.Location> flowFromThrownException(ExplodedGraph.Edge edge) {
            SymbolicValue peekValue = edge.child.programState.peekValue();
            if (peekValue instanceof SymbolicValue.ExceptionalSymbolicValue) {
                if (this.isMethodInvocationNode(edge.parent)) {
                    Type type = ((SymbolicValue.ExceptionalSymbolicValue)peekValue).exceptionType();
                    String msg = String.format("%s is thrown.", this.exceptionName(type));
                    return Optional.of(this.location(edge.parent, msg));
                }
                if (this.isDivByZeroExceptionalYield(edge)) {
                    return Optional.of(this.location(edge.parent, "Division by zero."));
                }
            }
            return Optional.empty();
        }

        private boolean isDivByZeroExceptionalYield(ExplodedGraph.Edge edge) {
            Tree tree = edge.parent.programPoint.syntaxTree();
            return tree != null && tree.is(Tree.Kind.DIVIDE, Tree.Kind.DIVIDE_ASSIGNMENT);
        }

        private Optional<JavaFileScannerContext.Location> flowFromCaughtException(ExplodedGraph.Edge edge) {
            ProgramPoint programPoint = edge.parent.programPoint;
            if (((CFG.Block)programPoint.block).isCatchBlock() && programPoint.i == 0) {
                VariableTree catchVariable = (VariableTree)programPoint.syntaxTree();
                SymbolicValue.CaughtExceptionSymbolicValue caughtSv = (SymbolicValue.CaughtExceptionSymbolicValue)edge.child.programState.getValue(catchVariable.symbol());
                Objects.requireNonNull(caughtSv, "Caught exception not found in program state");
                Type exceptionType = caughtSv.exception().exceptionType();
                return Optional.of(this.location(edge.parent, String.format("%s is caught.", this.exceptionName(exceptionType))));
            }
            return Optional.empty();
        }

        private String exceptionName(@Nullable Type type) {
            if (type == null || type.isUnknown()) {
                return "Exception";
            }
            return "'" + type.name() + "'";
        }

        private Set<LearnedConstraint> filterRedundantObjectDomain(Set<LearnedConstraint> learnedConstraints) {
            Map<SymbolicValue, Long> constraintsBySV = learnedConstraints.stream().collect(Collectors.groupingBy(LearnedConstraint::symbolicValue, Collectors.counting()));
            return learnedConstraints.stream().flatMap(lc -> this.isConstraintFromObjectDomain(lc.constraint()) && (Long)constraintsBySV.get(lc.symbolicValue()) > 1L ? Stream.empty() : Stream.of(lc)).collect(Collectors.toSet());
        }

        private boolean isConstraintFromObjectDomain(@Nullable Constraint constraint) {
            return constraint instanceof ObjectConstraint;
        }

        private Flow flowForNullableMethodParameters(ExplodedGraph.Node node) {
            if (!node.edges().isEmpty() || !FlowComputation.this.domains.contains(ObjectConstraint.class)) {
                return Flow.empty();
            }
            Flow.Builder flowBuilder = Flow.builder();
            this.trackedSymbols.forEach(symbol -> {
                SymbolicValue sv = node.programState.getValue((Symbol)symbol);
                if (sv == null) {
                    return;
                }
                ObjectConstraint startConstraint = node.programState.getConstraint(sv, ObjectConstraint.class);
                if (startConstraint != null && this.isMethodParameter((Symbol)symbol)) {
                    String msg = FlowComputation.IMPLIES_CAN_BE_MSG;
                    if (ObjectConstraint.NOT_NULL == startConstraint) {
                        msg = "Implies '%s' can not be %s.";
                    }
                    flowBuilder.add(new JavaFileScannerContext.Location(String.format(msg, symbol.name(), "null"), ((VariableTree)symbol.declaration()).simpleName()));
                }
            });
            return flowBuilder.build();
        }

        private boolean isMethodParameter(Symbol symbol) {
            Symbol owner = symbol.owner();
            return owner.isMethodSymbol() && ((Symbol.MethodSymbol)owner).declaration().parameters().contains(symbol.declaration());
        }

        private Flow flowFromLearnedConstraints(ExplodedGraph.Edge edge, Set<LearnedConstraint> learnedConstraints) {
            Flow.Builder flowBuilder = Flow.builder();
            learnedConstraints.stream().map(lc -> this.learnedConstraintFlow((LearnedConstraint)lc, edge)).flatMap(Flow::stream).distinct().forEach(flowBuilder::add);
            return flowBuilder.build();
        }

        private boolean shouldTerminate(Set<LearnedConstraint> learnedConstraints) {
            return learnedConstraints.stream().map(LearnedConstraint::constraint).anyMatch(FlowComputation.this.terminateTraversal);
        }

        private Optional<LearnedAssociation> learnedAssociation(ExplodedGraph.Edge edge) {
            return edge.learnedAssociations().stream().filter(la -> this.trackedSymbols.contains(la.symbol)).findAny();
        }

        private Flow flowFromLearnedAssociation(LearnedAssociation learnedAssociation, ExplodedGraph.Node node) {
            ProgramState programState = node.programState;
            Preconditions.checkState(programState != null, "Learned association with null state in parent node of the edge.");
            Symbol rhsSymbol = this.symbolFromStack(learnedAssociation.symbolicValue(), programState);
            if (rhsSymbol != null) {
                return Flow.of(this.location(node, String.format(FlowComputation.IMPLIES_SAME_VALUE, learnedAssociation.symbol().name(), rhsSymbol.name())));
            }
            Flow.Builder flowBuilder = Flow.builder();
            ConstraintsByDomain allConstraints = programState.getConstraints(learnedAssociation.symbolicValue());
            Collection<Constraint> constraints = this.filterByDomains(allConstraints);
            boolean isPrimitive = learnedAssociation.symbol.type().isPrimitive();
            for (Constraint constraint : constraints) {
                if (isPrimitive && constraint == ObjectConstraint.NOT_NULL) continue;
                String symbolName = learnedAssociation.symbol().name();
                String msg = this.assigningNullFromTernary(node) || this.assigningFromMethodInvocation(node) && this.assignedFromYieldWithUncertainResult(constraint, node) ? FlowComputation.IMPLIES_CAN_BE_MSG : FlowComputation.IMPLIES_IS_MSG;
                flowBuilder.add(this.location(node, String.format(msg, symbolName, constraint.valueAsString())));
            }
            return flowBuilder.build();
        }

        private Collection<Constraint> filterByDomains(@Nullable ConstraintsByDomain allConstraints) {
            if (allConstraints == null) {
                return Collections.emptySet();
            }
            LinkedHashMap<Class<? extends Constraint>, Constraint> constraints = new LinkedHashMap<Class<? extends Constraint>, Constraint>();
            for (Class<? extends Constraint> domain : FlowComputation.this.domains) {
                Constraint constraint = allConstraints.get(domain);
                if (constraint == null) continue;
                constraints.put(domain, constraint);
            }
            if (constraints.size() > 1) {
                constraints.remove(ObjectConstraint.class);
            }
            return constraints.values();
        }

        private boolean assigningNullFromTernary(ExplodedGraph.Node node) {
            ExpressionTree expr = this.getInitializer(node);
            return this.isTernaryWithNullBranch(expr);
        }

        @CheckForNull
        private ExpressionTree getInitializer(ExplodedGraph.Node node) {
            ExpressionTree expr;
            Tree tree = node.programPoint.syntaxTree();
            switch (tree.kind()) {
                case VARIABLE: {
                    expr = ((VariableTree)tree).initializer();
                    break;
                }
                case ASSIGNMENT: {
                    expr = ((AssignmentExpressionTree)tree).expression();
                    break;
                }
                default: {
                    expr = null;
                }
            }
            return expr;
        }

        private boolean isTernaryWithNullBranch(@Nullable ExpressionTree expressionTree) {
            if (expressionTree == null) {
                return false;
            }
            ExpressionTree expr = ExpressionUtils.skipParentheses(expressionTree);
            if (expr.is(Tree.Kind.CONDITIONAL_EXPRESSION)) {
                ConditionalExpressionTree cet = (ConditionalExpressionTree)expr;
                return ExpressionUtils.isNullLiteral(cet.trueExpression()) ^ ExpressionUtils.isNullLiteral(cet.falseExpression());
            }
            return false;
        }

        private boolean assigningFromMethodInvocation(ExplodedGraph.Node node) {
            ExpressionTree expr = this.getInitializer(node);
            return this.isMethodInvocation(expr);
        }

        private boolean isMethodInvocation(@Nullable ExpressionTree expressionTree) {
            return expressionTree != null && ExpressionUtils.skipParentheses(expressionTree).is(Tree.Kind.METHOD_INVOCATION);
        }

        private boolean assignedFromYieldWithUncertainResult(Constraint constraint, ExplodedGraph.Node node) {
            return node.edges().stream().noneMatch(edge -> this.isConstraintOnlyPossibleResult(constraint, (ExplodedGraph.Edge)edge));
        }

        private PSet<Symbol> newTrackedSymbols(ExplodedGraph.Edge edge) {
            Optional<LearnedAssociation> learnedAssociation = this.learnedAssociation(edge);
            return learnedAssociation.map(la -> {
                PSet<Symbol> newTrackedSymbols = this.trackedSymbols.remove(la.symbol);
                ProgramState programState = edge.parent.programState;
                Symbol symbol = this.symbolFromStack(la.symbolicValue(), programState);
                if (symbol != null) {
                    newTrackedSymbols = newTrackedSymbols.add(symbol);
                } else {
                    for (Symbol s : la.symbolicValue().computedFromSymbols()) {
                        newTrackedSymbols = newTrackedSymbols.add(s);
                    }
                }
                return newTrackedSymbols;
            }).orElse(this.trackedSymbols);
        }

        @CheckForNull
        private Symbol symbolFromStack(SymbolicValue symbolicValue, @Nullable ProgramState programState) {
            if (programState != null && programState.peekValue() == symbolicValue) {
                return programState.peekValueSymbol().symbol;
            }
            return null;
        }

        private boolean visitedAllParents(ExplodedGraph.Edge edge) {
            return edge.parent.edges().stream().allMatch(this.visited::contains);
        }

        boolean notVisited(ExplodedGraph.Edge e) {
            return !this.visited.contains(e);
        }

        Set<LearnedConstraint> learnedConstraints(ExplodedGraph.Edge edge) {
            Set<LearnedConstraint> learnedConstraints = edge.learnedConstraints();
            HashSet lcByDomain = new HashSet();
            for (Class<? extends Constraint> domain : FlowComputation.this.domains) {
                learnedConstraints.stream().filter(lc -> FlowComputation.this.symbolicValues.contains(lc.symbolicValue()) && this.hasConstraintForDomain((LearnedConstraint)lc, domain)).forEach(lcByDomain::add);
            }
            return Collections.unmodifiableSet(lcByDomain);
        }

        private boolean hasConstraintForDomain(LearnedConstraint lc, Class<? extends Constraint> domain) {
            return domain.isAssignableFrom(lc.constraint.getClass());
        }

        private Flow learnedConstraintFlow(LearnedConstraint learnedConstraint, ExplodedGraph.Edge edge) {
            String name;
            Constraint constraint = learnedConstraint.constraint();
            if (!FlowComputation.this.addToFlow.test(constraint)) {
                return Flow.empty();
            }
            if (constraint == ObjectConstraint.NOT_NULL && learnedConstraint.sv instanceof BinarySymbolicValue) {
                return Flow.empty();
            }
            ExplodedGraph.Node parent = edge.parent;
            Tree nodeTree = parent.programPoint.syntaxTree();
            if (this.isMethodInvocationNode(parent)) {
                return this.methodInvocationFlow(constraint, edge);
            }
            if (nodeTree.is(Tree.Kind.NEW_CLASS)) {
                return Flow.of(this.location(parent, String.format("Constructor implies '%s'.", constraint.valueAsString())));
            }
            Symbol finalField = this.learnedConstraintOnInitializedFinalField(nodeTree);
            if (finalField != null) {
                String msg = String.format(FlowComputation.IMPLIES_IS_MSG, finalField.name(), constraint.valueAsString());
                return Flow.of(new JavaFileScannerContext.Location(msg, ((VariableTree)finalField.declaration()).initializer()));
            }
            Symbol trackedSymbol = this.getSymbol(parent.programState, learnedConstraint.sv);
            String string = name = trackedSymbol != null ? trackedSymbol.name() : SyntaxTreeNameFinder.getName(nodeTree);
            if (name == null) {
                return Flow.empty();
            }
            String msg = ObjectConstraint.NULL == constraint && !this.sameConstraints.hasAlwaysSameConstraint(trackedSymbol) ? FlowComputation.IMPLIES_CAN_BE_MSG : FlowComputation.IMPLIES_IS_MSG;
            return Flow.of(this.location(parent, String.format(msg, name, constraint.valueAsString())));
        }

        @CheckForNull
        private Symbol getSymbol(ProgramState programState, SymbolicValue sv) {
            SymbolicValue peekValue = programState.peekValue();
            if (sv.equals(peekValue)) {
                return programState.peekValueSymbol().symbol;
            }
            if (peekValue instanceof BinarySymbolicValue) {
                BinarySymbolicValue bsv = (BinarySymbolicValue)peekValue;
                if (sv.equals(bsv.getRightOp())) {
                    return bsv.rightSymbol();
                }
                return bsv.leftSymbol();
            }
            return null;
        }

        @CheckForNull
        private Symbol learnedConstraintOnInitializedFinalField(Tree syntaxTree) {
            MemberSelectExpressionTree mset;
            Symbol result = null;
            if (syntaxTree.is(Tree.Kind.IDENTIFIER)) {
                result = ((IdentifierTree)syntaxTree).symbol();
            } else if (syntaxTree.is(Tree.Kind.MEMBER_SELECT) && ExpressionUtils.isSelectOnThisOrSuper(mset = (MemberSelectExpressionTree)syntaxTree)) {
                result = mset.identifier().symbol();
            }
            if (this.isFinalFieldWithInitializer(result)) {
                return result;
            }
            return null;
        }

        private boolean isFinalFieldWithInitializer(@Nullable Symbol symbol) {
            if (symbol != null && symbol.isVariableSymbol() && symbol.owner().isTypeSymbol() && symbol.isFinal()) {
                VariableTree declaration = ((Symbol.VariableSymbol)symbol).declaration();
                return declaration != null && declaration.initializer() != null;
            }
            return false;
        }

        private Flow methodInvocationFlow(Constraint learnedConstraint, ExplodedGraph.Edge edge) {
            SymbolicValue invocationTarget;
            ExplodedGraph.Node parent = edge.parent;
            MethodInvocationTree mit = (MethodInvocationTree)parent.programPoint.syntaxTree();
            Flow.Builder flowBuilder = Flow.builder();
            SymbolicValue returnSV = edge.child.programState.peekValue();
            if (FlowComputation.this.symbolicValues.contains(returnSV)) {
                flowBuilder.add(this.methodInvocationReturnMessage(learnedConstraint, edge, mit.symbol().name()));
            }
            if (FlowComputation.this.symbolicValues.contains(invocationTarget = parent.programState.peekValue(mit.arguments().size()))) {
                String invocationTargetName = SyntaxTreeNameFinder.getName(mit.methodSelect());
                flowBuilder.add(this.location(parent, String.format(FlowComputation.IMPLIES_IS_MSG, invocationTargetName, learnedConstraint.valueAsString())));
            }
            List<Integer> argumentIndices = this.correspondingArgumentIndices(FlowComputation.this.symbolicValues, parent);
            argumentIndices.stream().map(mit.arguments()::get).map(argTree -> {
                String message = String.format(FlowComputation.IMPLIES_IS_MSG, SyntaxTreeNameFinder.getName(argTree), learnedConstraint.valueAsString());
                return new JavaFileScannerContext.Location(message, (Tree)argTree);
            }).forEach(flowBuilder::add);
            return flowBuilder.build();
        }

        private JavaFileScannerContext.Location methodInvocationReturnMessage(Constraint constraint, ExplodedGraph.Edge edge, String methodName) {
            String msg = this.isConstraintOnlyPossibleResult(constraint, edge) ? String.format("'%s()' returns %s.", methodName, constraint.valueAsString()) : String.format("'%s()' can return %s.", methodName, constraint.valueAsString());
            return this.location(edge.parent, msg);
        }

        private boolean isConstraintOnlyPossibleResult(Constraint constraint, ExplodedGraph.Edge edge) {
            Set<MethodYield> selectedYields = edge.yields();
            if (selectedYields.isEmpty()) {
                return false;
            }
            MethodBehavior methodBehavior = selectedYields.iterator().next().methodBehavior();
            return methodBehavior.happyPathYields().map(HappyPathYield::resultConstraint).allMatch(resultConstraint -> resultConstraint != null && constraint.equals(resultConstraint.get(constraint.getClass())));
        }

        private Set<Flow> flowFromYields(ExplodedGraph.Edge edge, int maxReturnedFlows) {
            Set<MethodYield> methodYields = edge.yields();
            if (methodYields.isEmpty()) {
                return Collections.emptySet();
            }
            List<Integer> argumentIndices = this.correspondingArgumentIndices(FlowComputation.this.symbolicValues, edge.parent);
            MethodInvocationTree mit = (MethodInvocationTree)edge.parent.programPoint.syntaxTree();
            Flow passedArgumentsMessages = FlowComputation.flowsForPassedArguments(argumentIndices, mit);
            Flow changingNameArgumentsMessages = FlowComputation.flowsForArgumentsChangingName(argumentIndices, mit);
            SymbolicValue returnSV = edge.child.programState.peekValue();
            if (FlowComputation.this.symbolicValues.contains(returnSV)) {
                argumentIndices.add(-1);
            }
            if (argumentIndices.isEmpty()) {
                return Collections.emptySet();
            }
            return methodYields.stream().map(y -> y.flow(argumentIndices, FlowComputation.this.domains, maxReturnedFlows)).flatMap(Collection::stream).filter(f -> !f.isEmpty()).map(flowFromYield -> Flow.builder().addAll((Flow)flowFromYield).addAll(changingNameArgumentsMessages).addAll(passedArgumentsMessages).build()).collect(Collectors.toSet());
        }

        private boolean isMethodInvocationNode(ExplodedGraph.Node node) {
            ProgramPoint pp = node.programPoint;
            if (pp.i < pp.block.elements().size()) {
                Tree tree = ((CFG.Block)pp.block).elements().get(pp.i);
                return tree.is(Tree.Kind.METHOD_INVOCATION);
            }
            return false;
        }

        private List<Integer> correspondingArgumentIndices(Set<SymbolicValue> candidates, ExplodedGraph.Node invocationNode) {
            MethodInvocationTree mit = (MethodInvocationTree)invocationNode.programPoint.syntaxTree();
            List<SymbolicValue> arguments = this.argumentsUsedForMethodInvocation(invocationNode, mit);
            return IntStream.range(0, arguments.size()).filter(i -> candidates.contains(arguments.get(i))).boxed().collect(Collectors.toList());
        }

        private List<SymbolicValue> argumentsUsedForMethodInvocation(ExplodedGraph.Node invocationNode, MethodInvocationTree mit) {
            return ListUtils.reverse(invocationNode.programState.peekValues(mit.arguments().size()));
        }

        private JavaFileScannerContext.Location location(ExplodedGraph.Node node, String message) {
            return new JavaFileScannerContext.Location(message, node.programPoint.syntaxTree());
        }
    }
}

