/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.Flow;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.SetUtils;

public class AlwaysTrueOrFalseExpressionCollector {
    private final Map<Tree, Set<ExplodedGraph.Node>> falseEvaluations = new HashMap<Tree, Set<ExplodedGraph.Node>>();
    private final Map<Tree, Set<ExplodedGraph.Node>> trueEvaluations = new HashMap<Tree, Set<ExplodedGraph.Node>>();

    void evaluatedToFalse(Tree condition, ExplodedGraph.Node node) {
        this.falseEvaluations.computeIfAbsent(condition, k -> new HashSet()).add(node);
    }

    void evaluatedToTrue(Tree condition, ExplodedGraph.Node node) {
        this.trueEvaluations.computeIfAbsent(condition, k -> new HashSet()).add(node);
    }

    public Set<Tree> alwaysTrue() {
        return SetUtils.difference(this.trueEvaluations.keySet(), this.falseEvaluations.keySet());
    }

    public Set<Tree> alwaysFalse() {
        return SetUtils.difference(this.falseEvaluations.keySet(), this.trueEvaluations.keySet());
    }

    public Set<Flow> flowForExpression(Tree expression, int maxReturnedFlows) {
        Collection<ExplodedGraph.Node> nodes = this.getNodes(expression);
        return AlwaysTrueOrFalseExpressionCollector.collectFlow(nodes, maxReturnedFlows);
    }

    private Collection<ExplodedGraph.Node> getNodes(Tree expression) {
        Collection falseNodes = this.falseEvaluations.getOrDefault(expression, Collections.emptySet());
        return falseNodes.isEmpty() ? (Collection)this.trueEvaluations.getOrDefault(expression, Collections.emptySet()) : falseNodes;
    }

    private static Set<Flow> collectFlow(Collection<ExplodedGraph.Node> nodes, int maxReturnedFlows) {
        return nodes.stream().map(node -> AlwaysTrueOrFalseExpressionCollector.flowFromNode(node, maxReturnedFlows)).flatMap(Collection::stream).limit(maxReturnedFlows).filter(f -> !f.isEmpty()).collect(Collectors.toSet());
    }

    private static Set<Flow> flowFromNode(ExplodedGraph.Node node, int maxReturnedFlows) {
        List<Class<? extends Constraint>> domains = Arrays.asList(ObjectConstraint.class, BooleanConstraint.class);
        return FlowComputation.flow(node.parent(), node.programState.peekValue(), domains, node.programState.peekValueSymbol().symbol, maxReturnedFlows);
    }

    public static Flow addIssueLocation(Flow flow, Tree issueTree, boolean conditionIsAlwaysTrue) {
        return Flow.builder().add(new JavaFileScannerContext.Location("Expression is always " + conditionIsAlwaysTrue + ".", issueTree)).addAll(flow).build();
    }

    public static boolean hasUnreachableCode(Tree booleanExpr, boolean isTrue) {
        Tree parent = AlwaysTrueOrFalseExpressionCollector.biggestTreeWithSameEvaluation(booleanExpr, isTrue);
        if (parent.is(Tree.Kind.IF_STATEMENT)) {
            IfStatementTree ifStatementTree = (IfStatementTree)parent;
            return !isTrue || ifStatementTree.elseStatement() != null;
        }
        if (parent.is(Tree.Kind.WHILE_STATEMENT) && !isTrue) {
            return true;
        }
        return parent.is(Tree.Kind.CONDITIONAL_EXPRESSION);
    }

    private static Tree biggestTreeWithSameEvaluation(Tree booleanExpr, boolean isTrue) {
        Tree child = booleanExpr;
        Tree parent = booleanExpr.parent();
        while (AlwaysTrueOrFalseExpressionCollector.isBiggerTreeWithSameTruthiness(parent, child, isTrue)) {
            child = parent;
            parent = parent.parent();
        }
        Objects.requireNonNull(parent, "Error getting parent tree with same evaluation, parent is null");
        return parent;
    }

    private static boolean isBiggerTreeWithSameTruthiness(@Nullable Tree parent, Tree child, boolean isTrue) {
        if (parent == null) {
            return false;
        }
        if (parent.is(Tree.Kind.PARENTHESIZED_EXPRESSION)) {
            return true;
        }
        Tree.Kind operator = isTrue ? Tree.Kind.CONDITIONAL_OR : Tree.Kind.CONDITIONAL_AND;
        return parent.is(operator) && ((BinaryExpressionTree)parent).leftOperand() == child;
    }
}

