/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.sonar.java.model.AnnotationValueImpl;
import org.sonar.java.model.JSema;
import org.sonar.java.model.JSymbolMetadataNullabilityHelper;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

final class JSymbolMetadata
implements SymbolMetadata {
    private static final SymbolMetadata.NullabilityData[] NO_ANNOTATION_NULLABILITY = JSymbolMetadata.forEachLevel(level -> new JNullabilityData(SymbolMetadata.NullabilityType.NO_ANNOTATION, (SymbolMetadata.NullabilityLevel)((Object)level), null, null, false));
    private static final SymbolMetadata.NullabilityData[] UNKNOWN_NULLABILITY = JSymbolMetadata.forEachLevel(level -> new JNullabilityData(SymbolMetadata.NullabilityType.UNKNOWN, (SymbolMetadata.NullabilityLevel)((Object)level), null, null, false));
    private final JSema sema;
    private final Symbol symbol;
    private final IAnnotationBinding[] annotationBindings;
    private List<SymbolMetadata.AnnotationInstance> annotations;
    private final Map<SymbolMetadata.NullabilityTarget, SymbolMetadata.NullabilityData> nullabilityCache = new EnumMap<SymbolMetadata.NullabilityTarget, SymbolMetadata.NullabilityData>(SymbolMetadata.NullabilityTarget.class);

    JSymbolMetadata(JSema sema, Symbol symbol, IAnnotationBinding[] annotationBindings) {
        this.sema = Objects.requireNonNull(sema);
        this.symbol = symbol;
        this.annotationBindings = annotationBindings;
    }

    JSymbolMetadata(JSema sema, Symbol symbol, IAnnotationBinding[] typeAnnotationBindings, IAnnotationBinding[] annotationBindings) {
        this.sema = Objects.requireNonNull(sema);
        this.symbol = symbol;
        this.annotationBindings = new IAnnotationBinding[typeAnnotationBindings.length + annotationBindings.length];
        System.arraycopy(typeAnnotationBindings, 0, this.annotationBindings, 0, typeAnnotationBindings.length);
        System.arraycopy(annotationBindings, 0, this.annotationBindings, typeAnnotationBindings.length, annotationBindings.length);
    }

    private static SymbolMetadata.NullabilityData[] forEachLevel(Function<SymbolMetadata.NullabilityLevel, SymbolMetadata.NullabilityData> initializer) {
        return (SymbolMetadata.NullabilityData[])Arrays.stream(SymbolMetadata.NullabilityLevel.values()).map(initializer).toArray(SymbolMetadata.NullabilityData[]::new);
    }

    public static SymbolMetadata.NullabilityData noNullabilityAnnotationAt(SymbolMetadata.NullabilityLevel level) {
        return NO_ANNOTATION_NULLABILITY[level.ordinal()];
    }

    public static SymbolMetadata.NullabilityData unknownNullabilityAt(SymbolMetadata.NullabilityLevel level) {
        return UNKNOWN_NULLABILITY[level.ordinal()];
    }

    @Override
    public List<SymbolMetadata.AnnotationInstance> annotations() {
        if (this.annotations == null) {
            this.annotations = Arrays.stream(this.annotationBindings).map(this.sema::annotation).collect(Collectors.toList());
        }
        return this.annotations;
    }

    @Override
    public final boolean isAnnotatedWith(String fullyQualifiedName) {
        for (SymbolMetadata.AnnotationInstance a : this.annotations()) {
            if (!a.symbol().type().is(fullyQualifiedName)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public final List<SymbolMetadata.AnnotationValue> valuesForAnnotation(String fullyQualifiedNameOfAnnotation) {
        for (SymbolMetadata.AnnotationInstance a : this.annotations()) {
            if (!a.symbol().type().is(fullyQualifiedNameOfAnnotation)) continue;
            return a.values();
        }
        return null;
    }

    @Override
    public SymbolMetadata.NullabilityData nullabilityData() {
        SymbolMetadata.NullabilityTarget target = JSymbolMetadata.getTarget(this.symbol);
        if (target == null) {
            return JSymbolMetadata.unknownNullabilityAt(SymbolMetadata.NullabilityLevel.UNKNOWN);
        }
        return this.nullabilityData(target);
    }

    @Override
    public SymbolMetadata.NullabilityData nullabilityData(SymbolMetadata.NullabilityTarget target) {
        return this.nullabilityCache.computeIfAbsent(target, this::resolveNullability);
    }

    @Override
    @Nullable
    public AnnotationTree findAnnotationTree(SymbolMetadata.AnnotationInstance annotationInstance) {
        Tree declaration = this.symbol.declaration();
        if (declaration != null) {
            return JSymbolMetadata.findAnnotationTree(ModifiersUtils.getAnnotations(declaration), annotationInstance);
        }
        return null;
    }

    @Nullable
    private static AnnotationTree findAnnotationTree(List<AnnotationTree> annotations, SymbolMetadata.AnnotationInstance annotationInstance) {
        for (AnnotationTree annotationTree : annotations) {
            if (annotationTree.symbolType().symbol() != annotationInstance.symbol() || annotationTree.arguments().size() != annotationInstance.values().size()) continue;
            return annotationTree;
        }
        return null;
    }

    private SymbolMetadata.NullabilityData resolveNullability(SymbolMetadata.NullabilityTarget target) {
        SymbolMetadata.NullabilityLevel currentLevel = JSymbolMetadata.getLevel(this.symbol);
        SymbolMetadata.NullabilityData nullabilityDataAtLevel = JSymbolMetadataNullabilityHelper.getNullabilityDataAtLevel(this, target, currentLevel);
        if (nullabilityDataAtLevel.type() != SymbolMetadata.NullabilityType.NO_ANNOTATION) {
            return nullabilityDataAtLevel;
        }
        if (this.symbol.isPackageSymbol()) {
            return NO_ANNOTATION_NULLABILITY[currentLevel.ordinal()];
        }
        Symbol owner = JSymbolMetadata.getEffectiveOwner(this.symbol, currentLevel);
        return owner == null ? JSymbolMetadata.unknownNullabilityAt(currentLevel) : owner.metadata().nullabilityData(target);
    }

    @CheckForNull
    private static Symbol getEffectiveOwner(Symbol symbol, SymbolMetadata.NullabilityLevel currentLevel) {
        Symbol owner = symbol.owner();
        if (owner != null && owner.isMethodSymbol() && currentLevel == SymbolMetadata.NullabilityLevel.CLASS) {
            return JSymbolMetadata.getEffectiveOwner(owner, currentLevel);
        }
        return owner;
    }

    private static SymbolMetadata.NullabilityLevel getLevel(Symbol symbol) {
        if (symbol.isVariableSymbol()) {
            return SymbolMetadata.NullabilityLevel.VARIABLE;
        }
        if (symbol.isMethodSymbol()) {
            return SymbolMetadata.NullabilityLevel.METHOD;
        }
        if (symbol.isTypeSymbol()) {
            return SymbolMetadata.NullabilityLevel.CLASS;
        }
        if (symbol.isPackageSymbol()) {
            return SymbolMetadata.NullabilityLevel.PACKAGE;
        }
        return SymbolMetadata.NullabilityLevel.UNKNOWN;
    }

    @CheckForNull
    private static SymbolMetadata.NullabilityTarget getTarget(Symbol symbol) {
        if (symbol.isMethodSymbol()) {
            return SymbolMetadata.NullabilityTarget.METHOD;
        }
        if (symbol.isVariableSymbol()) {
            Symbol owner = symbol.owner();
            if (owner != null && owner.isTypeSymbol()) {
                return SymbolMetadata.NullabilityTarget.FIELD;
            }
            Tree variableTree = symbol.declaration();
            if (variableTree == null) {
                return SymbolMetadata.NullabilityTarget.PARAMETER;
            }
            Tree variableTreeParent = variableTree.parent();
            if (variableTreeParent == null || variableTreeParent instanceof MethodTree) {
                return SymbolMetadata.NullabilityTarget.PARAMETER;
            }
            if (!variableTreeParent.is(Tree.Kind.LAMBDA_EXPRESSION)) {
                return SymbolMetadata.NullabilityTarget.LOCAL_VARIABLE;
            }
        }
        return null;
    }

    static final class JNullabilityData
    implements SymbolMetadata.NullabilityData {
        private final SymbolMetadata.NullabilityType type;
        private final SymbolMetadata.NullabilityLevel level;
        @Nullable
        private final SymbolMetadata.AnnotationInstance annotation;
        @Nullable
        private final AnnotationTree annotationTree;
        private final boolean metaAnnotation;

        public JNullabilityData(SymbolMetadata.NullabilityType type, SymbolMetadata.NullabilityLevel level, @Nullable SymbolMetadata.AnnotationInstance annotation, @Nullable AnnotationTree annotationTree, boolean metaAnnotation) {
            this.type = type;
            this.level = level;
            this.annotation = annotation;
            this.annotationTree = annotationTree;
            this.metaAnnotation = metaAnnotation;
        }

        @Override
        public SymbolMetadata.NullabilityType type() {
            return this.type;
        }

        @Override
        public SymbolMetadata.NullabilityLevel level() {
            return this.level;
        }

        @Override
        public boolean metaAnnotation() {
            return this.metaAnnotation;
        }

        @Override
        public boolean isNonNull(SymbolMetadata.NullabilityLevel minLevel, boolean ignoreMetaAnnotation, boolean defaultValue) {
            return this.testNullabilityType(minLevel, ignoreMetaAnnotation, defaultValue, t -> t == SymbolMetadata.NullabilityType.NON_NULL);
        }

        @Override
        public boolean isNullable(SymbolMetadata.NullabilityLevel minLevel, boolean ignoreMetaAnnotation, boolean defaultValue) {
            return this.testNullabilityType(minLevel, ignoreMetaAnnotation, defaultValue, t -> t == SymbolMetadata.NullabilityType.STRONG_NULLABLE || t == SymbolMetadata.NullabilityType.WEAK_NULLABLE);
        }

        @Override
        public boolean isStrongNullable(SymbolMetadata.NullabilityLevel minLevel, boolean ignoreMetaAnnotation, boolean defaultValue) {
            return this.testNullabilityType(minLevel, ignoreMetaAnnotation, defaultValue, t -> t == SymbolMetadata.NullabilityType.STRONG_NULLABLE);
        }

        private boolean testNullabilityType(SymbolMetadata.NullabilityLevel minLevel, boolean ignoreMetaAnnotation, boolean defaultValue, Predicate<SymbolMetadata.NullabilityType> typePredicate) {
            if (this.type == SymbolMetadata.NullabilityType.NO_ANNOTATION) {
                return false;
            }
            if (this.type == SymbolMetadata.NullabilityType.UNKNOWN || ignoreMetaAnnotation && this.metaAnnotation) {
                return defaultValue;
            }
            if (typePredicate.test(this.type)) {
                return minLevel.ordinal() <= this.level.ordinal();
            }
            return false;
        }

        @Override
        @Nullable
        public SymbolMetadata.AnnotationInstance annotation() {
            return this.annotation;
        }

        @Override
        @Nullable
        public Tree declaration() {
            return this.annotationTree;
        }
    }

    static final class JAnnotationInstance
    implements SymbolMetadata.AnnotationInstance {
        private final JSema sema;
        private final IAnnotationBinding annotationBinding;
        private List<SymbolMetadata.AnnotationValue> values;

        JAnnotationInstance(JSema sema, IAnnotationBinding annotationBinding) {
            this.sema = sema;
            this.annotationBinding = annotationBinding;
        }

        @Override
        public Symbol symbol() {
            return this.sema.typeSymbol(this.annotationBinding.getAnnotationType());
        }

        @Override
        public List<SymbolMetadata.AnnotationValue> values() {
            if (this.values == null) {
                this.values = Arrays.stream(this.annotationBinding.getDeclaredMemberValuePairs()).map(p -> new AnnotationValueImpl(p.getName(), this.convertAnnotationValue(p.getValue()))).collect(Collectors.toList());
            }
            return this.values;
        }

        private Object convertAnnotationValue(Object value) {
            if (value instanceof IVariableBinding) {
                return this.sema.variableSymbol((IVariableBinding)value);
            }
            if (value instanceof ITypeBinding) {
                return this.sema.typeSymbol((ITypeBinding)value);
            }
            if (value instanceof IAnnotationBinding) {
                return this.sema.annotation((IAnnotationBinding)value);
            }
            if (value instanceof Object[]) {
                Object[] a = (Object[])value;
                Object[] result = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    result[i] = this.convertAnnotationValue(a[i]);
                }
                return result;
            }
            return value;
        }
    }
}

