/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTUtils;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.sonar.java.model.JInitializerBlockSymbol;
import org.sonar.java.model.JMethodSymbol;
import org.sonar.java.model.JPackageSymbol;
import org.sonar.java.model.JProblem;
import org.sonar.java.model.JSymbol;
import org.sonar.java.model.JSymbolMetadata;
import org.sonar.java.model.JType;
import org.sonar.java.model.JTypeSymbol;
import org.sonar.java.model.JVariableSymbol;
import org.sonar.java.model.Sema;
import org.sonar.java.model.Symbols;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;

public final class JSema
implements Sema {
    private final AST ast;
    final Set<JProblem> undefinedTypes = new HashSet<JProblem>();
    final Map<IBinding, Tree> declarations = new HashMap<IBinding, Tree>();
    final Map<IBinding, List<IdentifierTree>> usages = new HashMap<IBinding, List<IdentifierTree>>();
    private final Map<ITypeBinding, JType> types = new HashMap<ITypeBinding, JType>();
    private final Map<IBinding, JSymbol> symbols = new HashMap<IBinding, JSymbol>();
    private final Map<Symbol.TypeSymbol, JInitializerBlockSymbol> initializerBlockSymbols = new HashMap<Symbol.TypeSymbol, JInitializerBlockSymbol>();
    private final Map<Symbol.TypeSymbol, JInitializerBlockSymbol> staticInitializerBlockSymbols = new HashMap<Symbol.TypeSymbol, JInitializerBlockSymbol>();
    private final Map<IAnnotationBinding, JSymbolMetadata.JAnnotationInstance> annotations = new HashMap<IAnnotationBinding, JSymbolMetadata.JAnnotationInstance>();
    private final Map<String, Type> nameToTypeCache = new HashMap<String, Type>();

    JSema(AST ast) {
        this.ast = ast;
    }

    public JType type(ITypeBinding typeBinding) {
        return this.types.computeIfAbsent(typeBinding, k -> new JType(this, JType.normalize(typeBinding)));
    }

    List<Type> types(ITypeBinding[] typeBindings) {
        if (typeBindings.length == 0) {
            return Collections.emptyList();
        }
        Type[] result = new Type[typeBindings.length];
        for (int i = 0; i < typeBindings.length; ++i) {
            result[i] = this.type(typeBindings[i]);
        }
        return Arrays.asList(result);
    }

    public JPackageSymbol packageSymbol(IPackageBinding packageBinding) {
        return (JPackageSymbol)this.symbols.computeIfAbsent(packageBinding, k -> new JPackageSymbol(this, (IPackageBinding)k));
    }

    public JTypeSymbol typeSymbol(ITypeBinding typeBinding) {
        return (JTypeSymbol)this.symbols.computeIfAbsent(typeBinding, k -> new JTypeSymbol(this, JType.normalize((ITypeBinding)k)));
    }

    public JMethodSymbol methodSymbol(IMethodBinding methodBinding) {
        return (JMethodSymbol)this.symbols.computeIfAbsent(methodBinding, k -> new JMethodSymbol(this, (IMethodBinding)k));
    }

    public JInitializerBlockSymbol initializerBlockSymbol(JTypeSymbol owner) {
        return this.initializerBlockSymbols.computeIfAbsent(owner, k -> new JInitializerBlockSymbol(owner, false));
    }

    public JInitializerBlockSymbol staticInitializerBlockSymbol(JTypeSymbol owner) {
        return this.staticInitializerBlockSymbols.computeIfAbsent(owner, k -> new JInitializerBlockSymbol(owner, true));
    }

    public JVariableSymbol variableSymbol(IVariableBinding variableBinding) {
        return (JVariableSymbol)this.symbols.computeIfAbsent(variableBinding, k -> new JVariableSymbol(this, (IVariableBinding)k));
    }

    JSymbolMetadata.JAnnotationInstance annotation(IAnnotationBinding annotationBinding) {
        return this.annotations.computeIfAbsent(annotationBinding, k -> new JSymbolMetadata.JAnnotationInstance(this, (IAnnotationBinding)k));
    }

    static IBinding declarationBinding(IBinding binding) {
        switch (binding.getKind()) {
            case 2: {
                return ((ITypeBinding)binding).getTypeDeclaration();
            }
            case 4: {
                return ((IMethodBinding)binding).getMethodDeclaration();
            }
            case 3: {
                return ((IVariableBinding)binding).getVariableDeclaration();
            }
        }
        return binding;
    }

    @Override
    public Type getClassType(String fullyQualifiedName) {
        return this.nameToTypeCache.computeIfAbsent(fullyQualifiedName, t -> {
            ITypeBinding typeBinding = this.resolveType((String)t);
            return typeBinding != null ? this.type(typeBinding) : Symbols.unknownType;
        });
    }

    @Nullable
    ITypeBinding resolveType(String name) {
        int dimensions = 0;
        int end = name.length() - 1;
        while (name.charAt(end) == ']') {
            end -= 2;
            ++dimensions;
        }
        ITypeBinding typeBinding = this.ast.resolveWellKnownType(name = name.substring(0, end + 1));
        if (typeBinding == null && (typeBinding = ASTUtils.resolveType(this.ast, name)) == null) {
            return null;
        }
        return dimensions == 0 ? typeBinding : typeBinding.createArrayType(dimensions);
    }

    IAnnotationBinding[] resolvePackageAnnotations(String packageName) {
        return ASTUtils.resolvePackageAnnotations(this.ast, packageName);
    }

    public void cleanupEnvironment() {
        ASTUtils.cleanupEnvironment(this.ast);
    }

    public Set<JProblem> undefinedTypes() {
        return Collections.unmodifiableSet(this.undefinedTypes);
    }
}

