/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.sonar.sslr.api.RecognitionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTUtils;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExportsDirective;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.GuardedPattern;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.IntersectionType;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.ModuleDirective;
import org.eclipse.jdt.core.dom.ModuleModifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.OpensDirective;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.Pattern;
import org.eclipse.jdt.core.dom.PatternInstanceofExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ProvidesDirective;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.RequiresDirective;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TextBlock;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.TypePattern;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.UsesDirective;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.core.dom.YieldStatement;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.formatter.Token;
import org.eclipse.jdt.internal.formatter.TokenManager;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.ast.parser.ArgumentListTreeImpl;
import org.sonar.java.ast.parser.FormalParametersListTreeImpl;
import org.sonar.java.ast.parser.InitializerListTreeImpl;
import org.sonar.java.ast.parser.ModuleNameListTreeImpl;
import org.sonar.java.ast.parser.ModuleNameTreeImpl;
import org.sonar.java.ast.parser.QualifiedIdentifierListTreeImpl;
import org.sonar.java.ast.parser.ResourceListTreeImpl;
import org.sonar.java.ast.parser.StatementListTreeImpl;
import org.sonar.java.ast.parser.TypeParameterListTreeImpl;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.ArrayDimensionTreeImpl;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.InternalSyntaxTrivia;
import org.sonar.java.model.JLabelSymbol;
import org.sonar.java.model.JProblem;
import org.sonar.java.model.JSema;
import org.sonar.java.model.JWarning;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.KeywordSuper;
import org.sonar.java.model.KeywordThis;
import org.sonar.java.model.TypeParameterTreeImpl;
import org.sonar.java.model.declaration.AnnotationTreeImpl;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.model.declaration.EnumConstantTreeImpl;
import org.sonar.java.model.declaration.ExportsDirectiveTreeImpl;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.model.declaration.ModifierKeywordTreeImpl;
import org.sonar.java.model.declaration.ModifiersTreeImpl;
import org.sonar.java.model.declaration.ModuleDeclarationTreeImpl;
import org.sonar.java.model.declaration.OpensDirectiveTreeImpl;
import org.sonar.java.model.declaration.ProvidesDirectiveTreeImpl;
import org.sonar.java.model.declaration.RequiresDirectiveTreeImpl;
import org.sonar.java.model.declaration.UsesDirectiveTreeImpl;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.java.model.expression.ArrayAccessExpressionTreeImpl;
import org.sonar.java.model.expression.AssessableExpressionTree;
import org.sonar.java.model.expression.AssignmentExpressionTreeImpl;
import org.sonar.java.model.expression.BinaryExpressionTreeImpl;
import org.sonar.java.model.expression.ConditionalExpressionTreeImpl;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.java.model.expression.InstanceOfTreeImpl;
import org.sonar.java.model.expression.InternalPostfixUnaryExpression;
import org.sonar.java.model.expression.InternalPrefixUnaryExpression;
import org.sonar.java.model.expression.LambdaExpressionTreeImpl;
import org.sonar.java.model.expression.LiteralTreeImpl;
import org.sonar.java.model.expression.MemberSelectExpressionTreeImpl;
import org.sonar.java.model.expression.MethodInvocationTreeImpl;
import org.sonar.java.model.expression.MethodReferenceTreeImpl;
import org.sonar.java.model.expression.NewArrayTreeImpl;
import org.sonar.java.model.expression.NewClassTreeImpl;
import org.sonar.java.model.expression.ParenthesizedTreeImpl;
import org.sonar.java.model.expression.TypeArgumentListTreeImpl;
import org.sonar.java.model.expression.TypeCastExpressionTreeImpl;
import org.sonar.java.model.expression.VarTypeTreeImpl;
import org.sonar.java.model.pattern.DefaultPatternTreeImpl;
import org.sonar.java.model.pattern.GuardedPatternTreeImpl;
import org.sonar.java.model.pattern.NullPatternTreeImpl;
import org.sonar.java.model.pattern.TypePatternTreeImpl;
import org.sonar.java.model.statement.AssertStatementTreeImpl;
import org.sonar.java.model.statement.BlockTreeImpl;
import org.sonar.java.model.statement.BreakStatementTreeImpl;
import org.sonar.java.model.statement.CaseGroupTreeImpl;
import org.sonar.java.model.statement.CaseLabelTreeImpl;
import org.sonar.java.model.statement.CatchTreeImpl;
import org.sonar.java.model.statement.ContinueStatementTreeImpl;
import org.sonar.java.model.statement.DoWhileStatementTreeImpl;
import org.sonar.java.model.statement.EmptyStatementTreeImpl;
import org.sonar.java.model.statement.ExpressionStatementTreeImpl;
import org.sonar.java.model.statement.ForEachStatementImpl;
import org.sonar.java.model.statement.ForStatementTreeImpl;
import org.sonar.java.model.statement.IfStatementTreeImpl;
import org.sonar.java.model.statement.LabeledStatementTreeImpl;
import org.sonar.java.model.statement.ReturnStatementTreeImpl;
import org.sonar.java.model.statement.StaticInitializerTreeImpl;
import org.sonar.java.model.statement.SwitchExpressionTreeImpl;
import org.sonar.java.model.statement.SwitchStatementTreeImpl;
import org.sonar.java.model.statement.SynchronizedStatementTreeImpl;
import org.sonar.java.model.statement.ThrowStatementTreeImpl;
import org.sonar.java.model.statement.TryStatementTreeImpl;
import org.sonar.java.model.statement.WhileStatementTreeImpl;
import org.sonar.java.model.statement.YieldStatementTreeImpl;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportClauseTree;
import org.sonar.plugins.java.api.tree.InferedTypeTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.ModuleDeclarationTree;
import org.sonar.plugins.java.api.tree.ModuleDirectiveTree;
import org.sonar.plugins.java.api.tree.PatternTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class JParser {
    private static final Logger LOG = Loggers.get(JParser.class);
    private static final Predicate<IProblem> IS_SYNTAX_ERROR = error -> (error.getID() & 0x40000000) != 0;
    private static final Predicate<IProblem> IS_UNDEFINED_TYPE_ERROR = error -> (error.getID() & 0x1000002) != 0;
    private CompilationUnit compilationUnit;
    private TokenManager tokenManager;
    private JSema sema;
    private final Deque<JLabelSymbol> labels = new LinkedList<JLabelSymbol>();
    private static final int ANY_TOKEN = -1;
    private static final Map<Object, Op> operators = new HashMap<Object, Op>();

    public static JavaTree.CompilationUnitTreeImpl parse(ASTParser astParser, String version, String unitName, String source) {
        CompilationUnit astNode;
        astParser.setUnitName(unitName);
        astParser.setSource(source.toCharArray());
        try {
            astNode = (CompilationUnit)astParser.createAST(null);
        }
        catch (Exception e) {
            LOG.error("ECJ: Unable to parse file", (Throwable)e);
            throw new RecognitionException(-1, "ECJ: Unable to parse file.", e);
        }
        return JParser.convert(version, unitName, source, astNode);
    }

    static JavaTree.CompilationUnitTreeImpl convert(String version, String unitName, String source, CompilationUnit astNode) {
        List errors = Stream.of(astNode.getProblems()).filter(IProblem::isError).collect(Collectors.toList());
        Optional<IProblem> possibleSyntaxError = errors.stream().filter(IS_SYNTAX_ERROR).findFirst();
        if (possibleSyntaxError.isPresent()) {
            IProblem syntaxError = possibleSyntaxError.get();
            int line = syntaxError.getSourceLineNumber();
            int column = astNode.getColumnNumber(syntaxError.getSourceStart());
            String message = String.format("Parse error at line %d column %d: %s", line, column, syntaxError.getMessage());
            throw new RecognitionException(line, message);
        }
        Set undefinedTypes = errors.stream().filter(IS_UNDEFINED_TYPE_ERROR).map(i -> new JProblem(i.getMessage(), (i.getID() & 0x400450) != 0 ? JProblem.Type.PREVIEW_FEATURE_USED : JProblem.Type.UNDEFINED_TYPE)).collect(Collectors.toSet());
        JParser converter = new JParser();
        converter.sema = new JSema(astNode.getAST());
        converter.sema.undefinedTypes.addAll(undefinedTypes);
        converter.compilationUnit = astNode;
        converter.tokenManager = new TokenManager(JParser.lex(version, unitName, source.toCharArray()), source, new DefaultCodeFormatterOptions(new HashMap<String, String>()));
        JavaTree.CompilationUnitTreeImpl tree = converter.convertCompilationUnit(astNode);
        tree.sema = converter.sema;
        JWarning.Mapper.warningsFor(astNode).mappedInto(tree);
        ASTUtils.mayTolerateMissingType(astNode.getAST());
        JParser.setParents(tree);
        return tree;
    }

    private static void setParents(Tree node) {
        Iterator<Tree> childrenIterator = JParser.iteratorFor(node);
        while (childrenIterator.hasNext()) {
            Tree child = childrenIterator.next();
            ((JavaTree)child).setParent(node);
            JParser.setParents(child);
        }
    }

    private static Iterator<Tree> iteratorFor(Tree node) {
        if (node.kind() == Tree.Kind.INFERED_TYPE || node.kind() == Tree.Kind.TOKEN) {
            return Collections.emptyIterator();
        }
        return ((JavaTree)node).getChildren().iterator();
    }

    private static List<Token> lex(String version, String unitName, char[] sourceChars) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        Scanner scanner = new Scanner(true, false, false, CompilerOptions.versionToJdkLevel(version), null, null, false);
        scanner.fakeInModule = "module-info.java".equals(unitName);
        scanner.setSource(sourceChars);
        try {
            int tokenType;
            do {
                tokenType = scanner.getNextToken();
                Token token = Token.fromCurrent(scanner, tokenType);
                tokens.add(token);
            } while (tokenType != 64);
        }
        catch (InvalidInputException e) {
            throw new IllegalStateException(e);
        }
        return tokens;
    }

    private void declaration(@Nullable IBinding binding, Tree node) {
        if (binding == null) {
            return;
        }
        this.sema.declarations.put(binding, node);
    }

    private void usage(@Nullable IBinding binding, IdentifierTree node) {
        if (binding == null) {
            return;
        }
        binding = JSema.declarationBinding(binding);
        this.sema.usages.computeIfAbsent(binding, k -> new ArrayList()).add(node);
    }

    private void usageLabel(@Nullable IdentifierTreeImpl node) {
        if (node == null) {
            return;
        }
        this.labels.stream().filter(symbol -> symbol.name().equals(node.name())).findFirst().ifPresent(labelSymbol -> {
            labelSymbol.usages.add(node);
            node.labelSymbol = labelSymbol;
        });
    }

    private int firstTokenIndexAfter(ASTNode e) {
        int index = this.tokenManager.firstIndexAfter(e, -1);
        while (this.tokenManager.get(index).isComment()) {
            ++index;
        }
        return index;
    }

    private int nextTokenIndex(int tokenIndex, int tokenType) {
        assert (tokenType != -1);
        while (this.tokenManager.get((int)(++tokenIndex)).tokenType != tokenType) {
        }
        return tokenIndex;
    }

    private InternalSyntaxToken firstTokenBefore(ASTNode e, int tokenType) {
        return this.createSyntaxToken(this.tokenManager.firstIndexBefore(e, tokenType));
    }

    private InternalSyntaxToken firstTokenAfter(ASTNode e, int tokenType) {
        return this.createSyntaxToken(this.tokenManager.firstIndexAfter(e, tokenType));
    }

    private InternalSyntaxToken firstTokenIn(ASTNode e, int tokenType) {
        return this.createSyntaxToken(this.tokenManager.firstIndexIn(e, tokenType));
    }

    private InternalSyntaxToken lastTokenIn(ASTNode e, int tokenType) {
        return this.createSyntaxToken(this.tokenManager.lastIndexIn(e, tokenType));
    }

    private InternalSyntaxToken createSyntaxToken(int tokenIndex) {
        Token t = this.tokenManager.get(tokenIndex);
        if (t.tokenType == 64) {
            if (t.originalStart == 0) {
                return new InternalSyntaxToken(1, 0, "", this.collectComments(tokenIndex), true);
            }
            int position = t.originalStart - 1;
            char c = this.tokenManager.getSource().charAt(position);
            int line = this.compilationUnit.getLineNumber(position);
            int column = this.compilationUnit.getColumnNumber(position);
            if (c == '\n' || c == '\r') {
                ++line;
                column = 0;
            } else {
                ++column;
            }
            return new InternalSyntaxToken(line, column, "", this.collectComments(tokenIndex), true);
        }
        return new InternalSyntaxToken(this.compilationUnit.getLineNumber(t.originalStart), this.compilationUnit.getColumnNumber(t.originalStart), t.toString(this.tokenManager.getSource()), this.collectComments(tokenIndex), false);
    }

    private InternalSyntaxToken createSpecialToken(int tokenIndex) {
        Token t = this.tokenManager.get(tokenIndex);
        List<SyntaxTrivia> comments = t.tokenType == 15 ? this.collectComments(tokenIndex) : Collections.emptyList();
        return new InternalSyntaxToken(this.compilationUnit.getLineNumber(t.originalEnd), this.compilationUnit.getColumnNumber(t.originalEnd), ">", comments, false);
    }

    private List<SyntaxTrivia> collectComments(int tokenIndex) {
        for (int commentIndex = tokenIndex; commentIndex > 0 && this.tokenManager.get(commentIndex - 1).isComment(); --commentIndex) {
        }
        ArrayList<SyntaxTrivia> comments = new ArrayList<SyntaxTrivia>();
        for (int i = commentIndex; i < tokenIndex; ++i) {
            Token t = this.tokenManager.get(i);
            comments.add(new InternalSyntaxTrivia(t.toString(this.tokenManager.getSource()), this.compilationUnit.getLineNumber(t.originalStart), this.compilationUnit.getColumnNumber(t.originalStart)));
        }
        return comments;
    }

    private void addEmptyStatementsToList(int tokenIndex, List list) {
        while (true) {
            Token token;
            if ((token = this.tokenManager.get(++tokenIndex)).isComment()) {
                continue;
            }
            if (token.tokenType != 25) break;
            list.add(new EmptyStatementTreeImpl(this.createSyntaxToken(tokenIndex)));
        }
    }

    private JavaTree.CompilationUnitTreeImpl convertCompilationUnit(CompilationUnit e) {
        JavaTree.PackageDeclarationTreeImpl packageDeclaration = null;
        if (e.getPackage() != null) {
            packageDeclaration = new JavaTree.PackageDeclarationTreeImpl(this.convertAnnotations(e.getPackage().annotations()), this.firstTokenIn(e.getPackage(), 90), this.convertExpression(e.getPackage().getName()), this.firstTokenIn(e.getPackage(), 25));
        }
        ArrayList<ImportClauseTree> imports = new ArrayList<ImportClauseTree>();
        for (int i = 0; i < e.imports().size(); ++i) {
            ImportDeclaration e2 = (ImportDeclaration)e.imports().get(i);
            ExpressionTree name = this.convertImportName(e2.getName());
            if (e2.isOnDemand()) {
                name = new MemberSelectExpressionTreeImpl(name, this.lastTokenIn(e2, 1), new IdentifierTreeImpl(this.lastTokenIn(e2, 8)));
            }
            JavaTree.ImportTreeImpl t = new JavaTree.ImportTreeImpl(this.firstTokenIn(e2, 111), e2.isStatic() ? this.firstTokenIn(e2, 38) : null, name, this.lastTokenIn(e2, 25));
            t.binding = e2.resolveBinding();
            imports.add(t);
            int tokenIndex = this.tokenManager.lastIndexIn(e2, 25);
            this.addEmptyStatementsToList(tokenIndex, imports);
        }
        ArrayList<Tree> types = new ArrayList<Tree>();
        for (Object type : e.types()) {
            this.processBodyDeclaration((AbstractTypeDeclaration)type, types);
        }
        if (e.imports().isEmpty() && e.types().isEmpty()) {
            this.addEmptyStatementsToList(-1, imports);
        }
        return new JavaTree.CompilationUnitTreeImpl(packageDeclaration, imports, types, this.convertModuleDeclaration(this.compilationUnit.getModule()), this.firstTokenAfter(e, 64));
    }

    private ExpressionTree convertImportName(Name node) {
        switch (node.getNodeType()) {
            case 42: {
                return new IdentifierTreeImpl(this.firstTokenIn(node, 19));
            }
            case 40: {
                QualifiedName e = (QualifiedName)node;
                return new MemberSelectExpressionTreeImpl(this.convertImportName(e.getQualifier()), this.firstTokenAfter(e.getQualifier(), 1), (IdentifierTreeImpl)this.convertImportName(e.getName()));
            }
        }
        throw new IllegalStateException(ASTNode.nodeClassForType(node.getNodeType()).toString());
    }

    @Nullable
    private ModuleDeclarationTree convertModuleDeclaration(@Nullable ModuleDeclaration e) {
        if (e == null) {
            return null;
        }
        ArrayList<ModuleDirectiveTree> moduleDirectives = new ArrayList<ModuleDirectiveTree>();
        for (Object o : e.moduleStatements()) {
            moduleDirectives.add(this.convertModuleDirective((ModuleDirective)o));
        }
        return new ModuleDeclarationTreeImpl(this.convertAnnotations(e.annotations()), e.isOpen() ? this.firstTokenIn(e, 119) : null, this.firstTokenBefore(e.getName(), 118), this.convertModuleName(e.getName()), this.firstTokenAfter(e.getName(), 39), moduleDirectives, this.lastTokenIn(e, 33));
    }

    private ModuleNameTreeImpl convertModuleName(Name node) {
        switch (node.getNodeType()) {
            case 40: {
                QualifiedName e = (QualifiedName)node;
                ModuleNameTreeImpl t = this.convertModuleName(e.getQualifier());
                t.add(new IdentifierTreeImpl(this.firstTokenIn(e.getName(), 19)));
                return t;
            }
            case 42: {
                ModuleNameTreeImpl t = ModuleNameTreeImpl.emptyList();
                t.add(new IdentifierTreeImpl(this.firstTokenIn(node, 19)));
                return t;
            }
        }
        throw new IllegalStateException(ASTNode.nodeClassForType(node.getNodeType()).toString());
    }

    private ModuleNameListTreeImpl convertModuleNames(List<?> list) {
        ModuleNameListTreeImpl t = ModuleNameListTreeImpl.emptyList();
        for (int i = 0; i < list.size(); ++i) {
            Name o = (Name)list.get(i);
            if (i > 0) {
                t.separators().add(this.firstTokenBefore(o, 32));
            }
            t.add(this.convertModuleName(o));
        }
        return t;
    }

    private ModuleDirectiveTree convertModuleDirective(ModuleDirective node) {
        switch (node.getNodeType()) {
            case 94: {
                RequiresDirective e = (RequiresDirective)node;
                ArrayList<ModifierTree> modifiers = new ArrayList<ModifierTree>();
                block15: for (Object o : e.modifiers()) {
                    switch (((ModuleModifier)o).getKeyword().toString()) {
                        case "static": {
                            modifiers.add(new ModifierKeywordTreeImpl(Modifier.STATIC, this.firstTokenIn((ASTNode)o, -1)));
                            continue block15;
                        }
                        case "transitive": {
                            modifiers.add(new ModifierKeywordTreeImpl(Modifier.TRANSITIVE, this.firstTokenIn((ASTNode)o, -1)));
                            continue block15;
                        }
                    }
                    throw new IllegalStateException();
                }
                return new RequiresDirectiveTreeImpl(this.firstTokenIn(e, 122), new ModifiersTreeImpl((List<ModifierTree>)modifiers), this.convertModuleName(e.getName()), this.lastTokenIn(e, 25));
            }
            case 95: {
                ExportsDirective e = (ExportsDirective)node;
                return new ExportsDirectiveTreeImpl(this.firstTokenIn(e, 123), this.convertExpression(e.getName()), e.modules().isEmpty() ? null : this.firstTokenAfter(e.getName(), 132), this.convertModuleNames(e.modules()), this.lastTokenIn(e, 25));
            }
            case 96: {
                OpensDirective e = (OpensDirective)node;
                return new OpensDirectiveTreeImpl(this.firstTokenIn(e, 124), this.convertExpression(e.getName()), e.modules().isEmpty() ? null : this.firstTokenAfter(e.getName(), 132), this.convertModuleNames(e.modules()), this.lastTokenIn(e, 25));
            }
            case 97: {
                UsesDirective e = (UsesDirective)node;
                return new UsesDirectiveTreeImpl(this.firstTokenIn(e, 125), (TypeTree)((Object)this.convertExpression(e.getName())), this.lastTokenIn(e, 25));
            }
            case 98: {
                ProvidesDirective e = (ProvidesDirective)node;
                QualifiedIdentifierListTreeImpl typeNames = QualifiedIdentifierListTreeImpl.emptyList();
                for (int i = 0; i < e.implementations().size(); ++i) {
                    Name o = (Name)e.implementations().get(i);
                    if (i > 0) {
                        typeNames.separators().add(this.firstTokenBefore(o, 32));
                    }
                    typeNames.add((TypeTree)((Object)this.convertExpression(o)));
                }
                return new ProvidesDirectiveTreeImpl(this.firstTokenIn(e, 126), (TypeTree)((Object)this.convertExpression(e.getName())), this.firstTokenAfter(e.getName(), 133), typeNames, this.lastTokenIn(e, 25));
            }
        }
        throw new IllegalStateException(ASTNode.nodeClassForType(node.getNodeType()).toString());
    }

    private ClassTreeImpl convertTypeDeclaration(AbstractTypeDeclaration e) {
        ClassTreeImpl t;
        ArrayList<Tree> members = new ArrayList<Tree>();
        int leftBraceTokenIndex = this.findLeftBraceTokenIndex(e);
        this.addEmptyStatementsToList(leftBraceTokenIndex, members);
        for (Object o : e.bodyDeclarations()) {
            this.processBodyDeclaration((BodyDeclaration)o, members);
        }
        ModifiersTreeImpl modifiers = this.convertModifiers(e.modifiers());
        IdentifierTreeImpl name = this.createSimpleName(e.getName());
        InternalSyntaxToken openBraceToken = this.createSyntaxToken(leftBraceTokenIndex);
        InternalSyntaxToken closeBraceToken = this.lastTokenIn(e, 33);
        switch (e.getNodeType()) {
            case 55: {
                t = this.convertTypeDeclaration((TypeDeclaration)e, modifiers, name, openBraceToken, members, closeBraceToken);
                break;
            }
            case 71: {
                t = this.convertEnumDeclaration((EnumDeclaration)e, modifiers, name, openBraceToken, members, closeBraceToken);
                break;
            }
            case 103: {
                t = this.convertRecordDeclaration((RecordDeclaration)e, modifiers, name, openBraceToken, members, closeBraceToken);
                break;
            }
            case 81: {
                t = this.convertAnnotationTypeDeclaration((AnnotationTypeDeclaration)e, modifiers, name, openBraceToken, members, closeBraceToken);
                break;
            }
            default: {
                throw new IllegalStateException(ASTNode.nodeClassForType(e.getNodeType()).toString());
            }
        }
        this.completeSuperInterfaces(e, t);
        t.typeBinding = e.resolveBinding();
        this.declaration(t.typeBinding, t);
        return t;
    }

    private ClassTreeImpl convertTypeDeclaration(TypeDeclaration e, ModifiersTreeImpl modifiers, IdentifierTreeImpl name, InternalSyntaxToken openBraceToken, List<Tree> members, InternalSyntaxToken closeBraceToken) {
        InternalSyntaxToken declarationKeyword = this.firstTokenBefore(e.getName(), e.isInterface() ? 73 : 70);
        ClassTreeImpl t = new ClassTreeImpl(e.isInterface() ? Tree.Kind.INTERFACE : Tree.Kind.CLASS, openBraceToken, members, closeBraceToken).complete(modifiers, declarationKeyword, name).completeTypeParameters(this.convertTypeParameters(e.typeParameters()));
        if (!e.permittedTypes().isEmpty()) {
            List permittedTypes = e.permittedTypes();
            InternalSyntaxToken permitsKeyword = this.firstTokenBefore((Type)permittedTypes.get(0), 127);
            QualifiedIdentifierListTreeImpl classPermittedTypes = QualifiedIdentifierListTreeImpl.emptyList();
            this.convertSeparatedTypeList(permittedTypes, classPermittedTypes);
            t.completePermittedTypes(permitsKeyword, classPermittedTypes);
        }
        if (!e.isInterface() && e.getSuperclassType() != null) {
            Type superclassType = e.getSuperclassType();
            t.completeSuperclass(this.firstTokenBefore(superclassType, 92), this.convertType(superclassType));
        }
        return t;
    }

    private ClassTreeImpl convertEnumDeclaration(EnumDeclaration e, ModifiersTreeImpl modifiers, IdentifierTreeImpl name, InternalSyntaxToken openBraceToken, List<Tree> members, InternalSyntaxToken closeBraceToken) {
        ArrayList<EnumConstantTreeImpl> enumConstants = new ArrayList<EnumConstantTreeImpl>();
        for (Object o : e.enumConstants()) {
            enumConstants.add(this.processEnumConstantDeclaration((EnumConstantDeclaration)o));
        }
        members.addAll(0, enumConstants);
        InternalSyntaxToken declarationKeyword = this.firstTokenBefore(e.getName(), 74);
        return new ClassTreeImpl(Tree.Kind.ENUM, openBraceToken, members, closeBraceToken).complete(modifiers, declarationKeyword, name);
    }

    private ClassTreeImpl convertAnnotationTypeDeclaration(AnnotationTypeDeclaration e, ModifiersTreeImpl modifiers, IdentifierTreeImpl name, InternalSyntaxToken openBraceToken, List<Tree> members, InternalSyntaxToken closeBraceToken) {
        InternalSyntaxToken declarationKeyword = this.firstTokenBefore(e.getName(), 73);
        return new ClassTreeImpl(Tree.Kind.ANNOTATION_TYPE, openBraceToken, members, closeBraceToken).complete(modifiers, declarationKeyword, name).completeAtToken(this.firstTokenBefore(e.getName(), 36));
    }

    private ClassTreeImpl convertRecordDeclaration(RecordDeclaration e, ModifiersTreeImpl modifiers, IdentifierTreeImpl name, InternalSyntaxToken openBraceToken, List<Tree> members, InternalSyntaxToken closeBraceToken) {
        InternalSyntaxToken declarationKeyword = this.firstTokenBefore(e.getName(), 75);
        return new ClassTreeImpl(Tree.Kind.RECORD, openBraceToken, members, closeBraceToken).complete(modifiers, declarationKeyword, name).completeTypeParameters(this.convertTypeParameters(e.typeParameters())).completeRecordComponents(this.convertRecordComponents(e));
    }

    private List<VariableTree> convertRecordComponents(RecordDeclaration e) {
        ArrayList<VariableTree> recordComponents = new ArrayList<VariableTree>();
        for (int i = 0; i < e.recordComponents().size(); ++i) {
            SingleVariableDeclaration o = (SingleVariableDeclaration)e.recordComponents().get(i);
            VariableTreeImpl recordComponent = this.convertVariable(o);
            if (i < e.recordComponents().size() - 1) {
                recordComponent.setEndToken(this.firstTokenAfter(o, 32));
            }
            recordComponents.add(recordComponent);
        }
        return recordComponents;
    }

    private int findLeftBraceTokenIndex(AbstractTypeDeclaration e) {
        if (e.getNodeType() == 71) {
            EnumDeclaration enumDeclaration = (EnumDeclaration)e;
            if (!enumDeclaration.enumConstants().isEmpty()) {
                return this.tokenManager.firstIndexBefore((ASTNode)enumDeclaration.enumConstants().get(0), 39);
            }
            if (!enumDeclaration.bodyDeclarations().isEmpty()) {
                return this.tokenManager.firstIndexBefore((ASTNode)e.bodyDeclarations().get(0), 39);
            }
            return this.tokenManager.lastIndexIn(e, 39);
        }
        if (!e.bodyDeclarations().isEmpty()) {
            return this.tokenManager.firstIndexBefore((ASTNode)e.bodyDeclarations().get(0), 39);
        }
        return this.tokenManager.lastIndexIn(e, 39);
    }

    private void completeSuperInterfaces(AbstractTypeDeclaration e, ClassTreeImpl t) {
        List<?> superInterfaces = JParser.superInterfaceTypes(e);
        if (!superInterfaces.isEmpty()) {
            QualifiedIdentifierListTreeImpl interfaces = QualifiedIdentifierListTreeImpl.emptyList();
            this.convertSeparatedTypeList(superInterfaces, interfaces);
            ASTNode firstInterface = (ASTNode)superInterfaces.get(0);
            InternalSyntaxToken keyword = this.firstTokenBefore(firstInterface, t.is(Tree.Kind.INTERFACE) ? 92 : 131);
            t.completeInterfaces(keyword, interfaces);
        }
    }

    private static List<?> superInterfaceTypes(AbstractTypeDeclaration e) {
        switch (e.getNodeType()) {
            case 55: {
                return ((TypeDeclaration)e).superInterfaceTypes();
            }
            case 71: {
                return ((EnumDeclaration)e).superInterfaceTypes();
            }
            case 103: {
                return ((RecordDeclaration)e).superInterfaceTypes();
            }
            case 81: {
                return Collections.emptyList();
            }
        }
        throw new IllegalStateException(ASTNode.nodeClassForType(e.getNodeType()).toString());
    }

    private <T extends Tree> void convertSeparatedTypeList(List<? extends Type> source, ListTree<T> target) {
        for (int i = 0; i < source.size(); ++i) {
            Type o = source.get(i);
            TypeTree tree = this.convertType(o);
            if (i > 0) {
                target.separators().add(this.firstTokenBefore(o, 32));
            }
            target.add(tree);
        }
    }

    private EnumConstantTreeImpl processEnumConstantDeclaration(EnumConstantDeclaration e) {
        InternalSyntaxToken separatorToken;
        InternalSyntaxToken closeParToken;
        InternalSyntaxToken openParToken;
        int openParTokenIndex = this.firstTokenIndexAfter(e.getName());
        if (this.tokenManager.get((int)openParTokenIndex).tokenType == 23) {
            openParToken = this.createSyntaxToken(openParTokenIndex);
            closeParToken = e.arguments().isEmpty() ? this.firstTokenAfter(e.getName(), 26) : this.firstTokenAfter((ASTNode)e.arguments().get(e.arguments().size() - 1), 26);
        } else {
            openParToken = null;
            closeParToken = null;
        }
        ArgumentListTreeImpl arguments = this.convertArguments(openParToken, e.arguments(), closeParToken);
        ClassTreeImpl classBody = null;
        if (e.getAnonymousClassDeclaration() != null) {
            ArrayList<Tree> members = new ArrayList<Tree>();
            for (Object o : e.getAnonymousClassDeclaration().bodyDeclarations()) {
                this.processBodyDeclaration((BodyDeclaration)o, members);
            }
            classBody = new ClassTreeImpl(Tree.Kind.CLASS, this.firstTokenIn(e.getAnonymousClassDeclaration(), 39), members, this.lastTokenIn(e.getAnonymousClassDeclaration(), 33));
            classBody.typeBinding = e.getAnonymousClassDeclaration().resolveBinding();
            this.declaration(classBody.typeBinding, classBody);
        }
        int separatorTokenIndex = this.firstTokenIndexAfter(e);
        switch (this.tokenManager.get((int)separatorTokenIndex).tokenType) {
            case 25: 
            case 32: {
                separatorToken = this.createSyntaxToken(separatorTokenIndex);
                break;
            }
            case 33: {
                separatorToken = null;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        IdentifierTreeImpl identifier = this.createSimpleName(e.getName());
        identifier.binding = e.getAnonymousClassDeclaration() == null ? JParser.excludeRecovery(e.resolveConstructorBinding(), arguments.size()) : JParser.findConstructorForAnonymousClass(e.getAST(), identifier.typeBinding, e.resolveConstructorBinding());
        this.usage(identifier.binding, identifier);
        EnumConstantTreeImpl t = new EnumConstantTreeImpl(this.convertModifiers(e.modifiers()), identifier, new NewClassTreeImpl(identifier, arguments, classBody), separatorToken);
        t.variableBinding = e.resolveVariable();
        this.declaration(t.variableBinding, t);
        return t;
    }

    private void processBodyDeclaration(BodyDeclaration node, List<Tree> members) {
        int lastTokenIndex;
        switch (node.getNodeType()) {
            case 55: 
            case 71: 
            case 81: 
            case 103: {
                lastTokenIndex = this.processTypeDeclaration((AbstractTypeDeclaration)node, members);
                break;
            }
            case 82: {
                lastTokenIndex = this.processAnnotationTypeMemberDeclaration((AnnotationTypeMemberDeclaration)node, members);
                break;
            }
            case 28: {
                lastTokenIndex = this.processInitializerDeclaration((Initializer)node, members);
                break;
            }
            case 31: {
                lastTokenIndex = this.processMethodDeclaration((MethodDeclaration)node, members);
                break;
            }
            case 23: {
                lastTokenIndex = this.processFieldDeclaration((FieldDeclaration)node, members);
                break;
            }
            default: {
                throw new IllegalStateException(ASTNode.nodeClassForType(node.getNodeType()).toString());
            }
        }
        this.addEmptyStatementsToList(lastTokenIndex, members);
    }

    private int processTypeDeclaration(AbstractTypeDeclaration node, List<Tree> members) {
        members.add(this.convertTypeDeclaration(node));
        return this.tokenManager.lastIndexIn(node, 33);
    }

    private int processAnnotationTypeMemberDeclaration(AnnotationTypeMemberDeclaration e, List<Tree> members) {
        FormalParametersListTreeImpl parameters = new FormalParametersListTreeImpl(this.firstTokenAfter(e.getName(), 23), this.firstTokenAfter(e.getName(), 26));
        Expression defaultExpression = e.getDefault();
        InternalSyntaxToken defaultToken = defaultExpression == null ? null : this.firstTokenBefore(defaultExpression, 76);
        ExpressionTree defaultValue = defaultExpression == null ? null : this.convertExpression(defaultExpression);
        MethodTreeImpl t = new MethodTreeImpl(parameters, defaultToken, defaultValue).complete(this.convertType(e.getType()), this.createSimpleName(e.getName()), this.lastTokenIn(e, 25)).completeWithModifiers(this.convertModifiers(e.modifiers()));
        t.methodBinding = e.resolveBinding();
        this.declaration(t.methodBinding, t);
        members.add(t);
        return this.tokenManager.lastIndexIn(e, 25);
    }

    private int processInitializerDeclaration(Initializer e, List<Tree> members) {
        BlockTreeImpl blockTree = this.convertBlock(e.getBody());
        if (org.eclipse.jdt.core.dom.Modifier.isStatic(e.getModifiers())) {
            members.add(new StaticInitializerTreeImpl(this.firstTokenIn(e, 38), (InternalSyntaxToken)blockTree.openBraceToken(), blockTree.body(), (InternalSyntaxToken)blockTree.closeBraceToken()));
        } else {
            members.add(new BlockTreeImpl(Tree.Kind.INITIALIZER, (InternalSyntaxToken)blockTree.openBraceToken(), blockTree.body(), (InternalSyntaxToken)blockTree.closeBraceToken()));
        }
        return this.tokenManager.lastIndexIn(e, 33);
    }

    private int processMethodDeclaration(MethodDeclaration e, List<Tree> members) {
        FormalParametersListTreeImpl formalParameters;
        List p = e.parameters();
        if (e.isCompactConstructor()) {
            formalParameters = new FormalParametersListTreeImpl(null, null);
        } else {
            InternalSyntaxToken openParen = this.firstTokenAfter(e.getName(), 23);
            InternalSyntaxToken closeParen = this.firstTokenAfter(p.isEmpty() ? e.getName() : (ASTNode)p.get(p.size() - 1), 26);
            formalParameters = new FormalParametersListTreeImpl(openParen, closeParen);
        }
        for (int i = 0; i < p.size(); ++i) {
            SingleVariableDeclaration o = (SingleVariableDeclaration)p.get(i);
            VariableTreeImpl parameter = this.convertVariable(o);
            if (i < p.size() - 1) {
                parameter.setEndToken(this.firstTokenAfter(o, 32));
            }
            formalParameters.add(parameter);
        }
        QualifiedIdentifierListTreeImpl thrownExceptionTypes = QualifiedIdentifierListTreeImpl.emptyList();
        List tt = e.thrownExceptionTypes();
        this.convertSeparatedTypeList(tt, thrownExceptionTypes);
        Block body = e.getBody();
        Type returnType = e.getReturnType2();
        InternalSyntaxToken throwsToken = tt.isEmpty() ? null : this.firstTokenBefore((Type)tt.get(0), 117);
        InternalSyntaxToken semcolonToken = body == null ? this.lastTokenIn(e, 25) : null;
        MethodTreeImpl t = new MethodTreeImpl(returnType == null ? null : this.applyExtraDimensions(this.convertType(returnType), e.extraDimensions()), this.createSimpleName(e.getName()), formalParameters, throwsToken, thrownExceptionTypes, body == null ? null : this.convertBlock(body), semcolonToken).completeWithModifiers(this.convertModifiers(e.modifiers())).completeWithTypeParameters(this.convertTypeParameters(e.typeParameters()));
        t.methodBinding = e.resolveBinding();
        this.declaration(t.methodBinding, t);
        members.add(t);
        return this.tokenManager.lastIndexIn(e, body == null ? 25 : 33);
    }

    private int processFieldDeclaration(FieldDeclaration fieldDeclaration, List<Tree> members) {
        ModifiersTreeImpl modifiers = this.convertModifiers(fieldDeclaration.modifiers());
        TypeTree type = this.convertType(fieldDeclaration.getType());
        for (int i = 0; i < fieldDeclaration.fragments().size(); ++i) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)fieldDeclaration.fragments().get(i);
            VariableTreeImpl t = new VariableTreeImpl(this.createSimpleName(fragment.getName())).completeModifiersAndType(modifiers, this.applyExtraDimensions(type, fragment.extraDimensions()));
            if (fragment.getInitializer() != null) {
                t.completeTypeAndInitializer(t.type(), this.firstTokenAfter(fragment.getName(), 77), this.convertExpression(fragment.getInitializer()));
            }
            t.setEndToken(this.firstTokenAfter(fragment, i + 1 < fieldDeclaration.fragments().size() ? 32 : 25));
            t.variableBinding = fragment.resolveBinding();
            this.declaration(t.variableBinding, t);
            members.add(t);
        }
        return this.tokenManager.lastIndexIn(fieldDeclaration, 25);
    }

    private ArgumentListTreeImpl convertArguments(@Nullable InternalSyntaxToken openParen, List<?> list, @Nullable InternalSyntaxToken closeParen) {
        ArgumentListTreeImpl arguments = ArgumentListTreeImpl.emptyList().complete(openParen, closeParen);
        for (int i = 0; i < list.size(); ++i) {
            Expression o = (Expression)list.get(i);
            arguments.add(this.convertExpression(o));
            if (i >= list.size() - 1) continue;
            arguments.separators().add(this.firstTokenAfter(o, 32));
        }
        return arguments;
    }

    @Nullable
    private TypeArgumentListTreeImpl convertTypeArguments(List<?> list) {
        if (list.isEmpty()) {
            return null;
        }
        ASTNode last = (ASTNode)list.get(list.size() - 1);
        int tokenIndex = this.tokenManager.firstIndexAfter(last, -1);
        while (this.tokenManager.get(tokenIndex).isComment()) {
            ++tokenIndex;
        }
        return this.convertTypeArguments(this.firstTokenBefore((ASTNode)list.get(0), 11), list, this.createSpecialToken(tokenIndex));
    }

    private TypeArgumentListTreeImpl convertTypeArguments(InternalSyntaxToken l, List<?> list, InternalSyntaxToken g) {
        TypeArgumentListTreeImpl typeArguments = new TypeArgumentListTreeImpl(l, g);
        for (int i = 0; i < list.size(); ++i) {
            Type o = (Type)list.get(i);
            if (i > 0) {
                typeArguments.separators().add(this.firstTokenBefore(o, 32));
            }
            typeArguments.add(this.convertType(o));
        }
        return typeArguments;
    }

    private TypeParameterListTreeImpl convertTypeParameters(List<?> list) {
        if (list.isEmpty()) {
            return new TypeParameterListTreeImpl();
        }
        ASTNode last = (ASTNode)list.get(list.size() - 1);
        int tokenIndex = this.tokenManager.firstIndexAfter(last, -1);
        while (this.tokenManager.get(tokenIndex).isComment()) {
            ++tokenIndex;
        }
        TypeParameterListTreeImpl t = new TypeParameterListTreeImpl(this.firstTokenBefore((ASTNode)list.get(0), 11), this.createSpecialToken(tokenIndex));
        for (int i = 0; i < list.size(); ++i) {
            TypeParameter o = (TypeParameter)list.get(i);
            if (i > 0) {
                t.separators().add(this.firstTokenBefore(o, 32));
            }
            t.add(this.convertTypeParameter(o));
        }
        return t;
    }

    private TypeParameterTree convertTypeParameter(TypeParameter e) {
        TypeParameterTreeImpl t;
        IdentifierTreeImpl i = this.createSimpleName(e.getName());
        i.complete(this.convertAnnotations(e.modifiers()));
        List typeBounds = e.typeBounds();
        if (typeBounds.isEmpty()) {
            t = new TypeParameterTreeImpl(i);
        } else {
            QualifiedIdentifierListTreeImpl bounds = QualifiedIdentifierListTreeImpl.emptyList();
            for (int j = 0; j < typeBounds.size(); ++j) {
                Object o = typeBounds.get(j);
                bounds.add(this.convertType((Type)o));
                if (j >= typeBounds.size() - 1) continue;
                bounds.separators().add(this.firstTokenAfter((ASTNode)o, 22));
            }
            t = new TypeParameterTreeImpl(i, this.firstTokenAfter(e.getName(), 92), bounds);
        }
        t.typeBinding = e.resolveBinding();
        return t;
    }

    private TypeTree applyExtraDimensions(TypeTree type, List<?> extraDimensions) {
        ITypeBinding typeBinding = ((AbstractTypedTree)((Object)type)).typeBinding;
        for (int i = 0; i < extraDimensions.size(); ++i) {
            Dimension e = (Dimension)extraDimensions.get(i);
            type = new JavaTree.ArrayTypeTreeImpl(type, this.convertAnnotations(e.annotations()), this.firstTokenIn(e, 6), this.firstTokenIn(e, 69));
            if (typeBinding == null) continue;
            ((JavaTree.ArrayTypeTreeImpl)type).typeBinding = typeBinding.createArrayType(i + 1);
        }
        return type;
    }

    private VariableTreeImpl convertVariable(SingleVariableDeclaration e) {
        TypeTree type = this.convertType(e.getType());
        type = this.applyExtraDimensions(type, e.extraDimensions());
        if (e.isVarargs()) {
            ITypeBinding typeBinding = ((AbstractTypedTree)((Object)type)).typeBinding;
            type = new JavaTree.ArrayTypeTreeImpl(type, this.convertAnnotations(e.varargsAnnotations()), this.firstTokenAfter(e.getType(), 120));
            if (typeBinding != null) {
                ((JavaTree.ArrayTypeTreeImpl)type).typeBinding = typeBinding.createArrayType(1);
            }
        }
        VariableTreeImpl t = new VariableTreeImpl((ModifiersTree)this.convertModifiers(e.modifiers()), type, this.createSimpleName(e.getName()));
        if (e.getInitializer() != null) {
            t.completeTypeAndInitializer(t.type(), this.firstTokenAfter(e.getName(), 77), this.convertExpression(e.getInitializer()));
        }
        t.variableBinding = e.resolveBinding();
        this.declaration(t.variableBinding, t);
        return t;
    }

    private void addVariableToList(VariableDeclarationExpression e2, List list) {
        ModifiersTreeImpl modifiers = this.convertModifiers(e2.modifiers());
        TypeTree type = this.convertType(e2.getType());
        for (int i = 0; i < e2.fragments().size(); ++i) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)e2.fragments().get(i);
            VariableTreeImpl t = new VariableTreeImpl(this.createSimpleName(fragment.getName()));
            t.completeModifiers(modifiers);
            if (fragment.getInitializer() == null) {
                t.completeType(this.applyExtraDimensions(type, fragment.extraDimensions()));
            } else {
                t.completeTypeAndInitializer(this.applyExtraDimensions(type, fragment.extraDimensions()), this.firstTokenBefore(fragment.getInitializer(), 77), this.convertExpression(fragment.getInitializer()));
            }
            if (i < e2.fragments().size() - 1) {
                t.setEndToken(this.firstTokenAfter(fragment, 32));
            }
            t.variableBinding = fragment.resolveBinding();
            this.declaration(t.variableBinding, t);
            list.add(t);
        }
    }

    private VarTypeTreeImpl convertVarType(SimpleType simpleType) {
        VarTypeTreeImpl varTree = new VarTypeTreeImpl(this.firstTokenIn(simpleType.getName(), 19));
        varTree.typeBinding = simpleType.resolveBinding();
        return varTree;
    }

    private IdentifierTreeImpl createSimpleName(SimpleName e) {
        IdentifierTreeImpl t = new IdentifierTreeImpl(this.firstTokenIn(e, 19));
        t.typeBinding = e.resolveTypeBinding();
        t.binding = e.resolveBinding();
        return t;
    }

    private BlockTreeImpl convertBlock(Block e) {
        ArrayList<StatementTree> statements = new ArrayList<StatementTree>();
        for (Object o : e.statements()) {
            this.addStatementToList((Statement)o, statements);
        }
        return new BlockTreeImpl(this.firstTokenIn(e, 39), statements, this.lastTokenIn(e, 33));
    }

    private void addStatementToList(Statement node, List<StatementTree> statements) {
        if (node.getNodeType() == 60) {
            VariableDeclarationStatement e = (VariableDeclarationStatement)node;
            TypeTree tType = this.convertType(e.getType());
            ModifiersTreeImpl modifiers = this.convertModifiers(e.modifiers());
            for (int i = 0; i < e.fragments().size(); ++i) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)e.fragments().get(i);
                VariableTreeImpl t = new VariableTreeImpl(this.createSimpleName(fragment.getName())).completeType(this.applyExtraDimensions(tType, fragment.extraDimensions())).completeModifiers(modifiers);
                Expression initalizer = fragment.getInitializer();
                if (initalizer != null) {
                    InternalSyntaxToken equalToken = this.firstTokenAfter(fragment.getName(), 77);
                    t.completeTypeAndInitializer(t.type(), equalToken, this.convertExpression(initalizer));
                }
                int endTokenType = i < e.fragments().size() - 1 ? 32 : 25;
                t.setEndToken(this.firstTokenAfter(fragment, endTokenType));
                t.variableBinding = fragment.resolveBinding();
                this.declaration(t.variableBinding, t);
                statements.add(t);
            }
        } else if (node.getNodeType() != 10 || node.getLength() >= "break".length()) {
            statements.add(this.createStatement(node));
        }
    }

    private StatementTree createStatement(Statement node) {
        switch (node.getNodeType()) {
            case 8: {
                return this.convertBlock((Block)node);
            }
            case 20: {
                return this.convertEmptyStatement((EmptyStatement)node);
            }
            case 41: {
                return this.convertReturn((ReturnStatement)node);
            }
            case 24: {
                return this.convertFor((ForStatement)node);
            }
            case 61: {
                return this.convertWhile((WhileStatement)node);
            }
            case 25: {
                return this.convertIf((IfStatement)node);
            }
            case 10: {
                return this.convertBreak((BreakStatement)node);
            }
            case 19: {
                return this.convertDoWhile((DoStatement)node);
            }
            case 6: {
                return this.convertAssert((AssertStatement)node);
            }
            case 50: {
                return this.convertSwitchStatement((SwitchStatement)node);
            }
            case 51: {
                return this.convertSynchronized((SynchronizedStatement)node);
            }
            case 21: {
                return this.convertExpressionStatement((ExpressionStatement)node);
            }
            case 18: {
                return this.convertContinue((ContinueStatement)node);
            }
            case 30: {
                return this.convertLabel((LabeledStatement)node);
            }
            case 70: {
                return this.convertForeach((EnhancedForStatement)node);
            }
            case 53: {
                return this.convertThrow((ThrowStatement)node);
            }
            case 54: {
                return this.convertTry((TryStatement)node);
            }
            case 56: {
                return this.convertTypeDeclaration(((TypeDeclarationStatement)node).getDeclaration());
            }
            case 17: {
                return this.convertConstructorInvocation((ConstructorInvocation)node);
            }
            case 46: {
                return this.convertSuperConstructorInvocation((SuperConstructorInvocation)node);
            }
            case 101: {
                return this.convertYield((YieldStatement)node);
            }
        }
        throw new IllegalStateException(ASTNode.nodeClassForType(node.getNodeType()).toString());
    }

    private EmptyStatementTreeImpl convertEmptyStatement(EmptyStatement e) {
        return new EmptyStatementTreeImpl(this.lastTokenIn(e, 25));
    }

    private ReturnStatementTreeImpl convertReturn(ReturnStatement e) {
        Expression expression = e.getExpression();
        return new ReturnStatementTreeImpl(this.firstTokenIn(e, 87), expression == null ? null : this.convertExpression(expression), this.lastTokenIn(e, 25));
    }

    private ForStatementTreeImpl convertFor(ForStatement e) {
        StatementListTreeImpl forInitStatement = StatementListTreeImpl.emptyList();
        for (int i = 0; i < e.initializers().size(); ++i) {
            Expression o = (Expression)e.initializers().get(i);
            if (i > 0) {
                forInitStatement.separators().add(this.firstTokenBefore(o, 32));
            }
            if (58 == o.getNodeType()) {
                this.addVariableToList((VariableDeclarationExpression)o, forInitStatement);
                continue;
            }
            forInitStatement.add(new ExpressionStatementTreeImpl(this.convertExpression(o), null));
        }
        StatementListTreeImpl forUpdateStatement = StatementListTreeImpl.emptyList();
        for (int i = 0; i < e.updaters().size(); ++i) {
            Expression o = (Expression)e.updaters().get(i);
            if (i > 0) {
                forUpdateStatement.separators().add(this.firstTokenBefore(o, 32));
            }
            forUpdateStatement.add(new ExpressionStatementTreeImpl(this.convertExpression(o), null));
        }
        int firstSemicolonTokenIndex = e.initializers().isEmpty() ? this.tokenManager.firstIndexIn(e, 25) : this.tokenManager.firstIndexAfter((ASTNode)e.initializers().get(e.initializers().size() - 1), 25);
        Expression expression = e.getExpression();
        int secondSemicolonTokenIndex = expression == null ? this.nextTokenIndex(firstSemicolonTokenIndex, 25) : this.tokenManager.firstIndexAfter(expression, 25);
        return new ForStatementTreeImpl(this.firstTokenIn(e, 85), this.firstTokenIn(e, 23), forInitStatement, this.createSyntaxToken(firstSemicolonTokenIndex), expression == null ? null : this.convertExpression(expression), this.createSyntaxToken(secondSemicolonTokenIndex), forUpdateStatement, this.firstTokenBefore(e.getBody(), 26), this.createStatement(e.getBody()));
    }

    private WhileStatementTreeImpl convertWhile(WhileStatement e) {
        Expression expression = e.getExpression();
        return new WhileStatementTreeImpl(this.firstTokenIn(e, 79), this.firstTokenBefore(expression, 23), this.convertExpression(expression), this.firstTokenAfter(expression, 26), this.createStatement(e.getBody()));
    }

    private IfStatementTreeImpl convertIf(IfStatement e) {
        Expression expression = e.getExpression();
        Statement thenStatement = e.getThenStatement();
        Statement elseStatement = e.getElseStatement();
        return new IfStatementTreeImpl(this.firstTokenIn(e, 86), this.firstTokenBefore(expression, 23), this.convertExpression(expression), this.firstTokenAfter(expression, 26), this.createStatement(thenStatement), elseStatement == null ? null : this.firstTokenAfter(thenStatement, 121), elseStatement == null ? null : this.createStatement(elseStatement));
    }

    private BreakStatementTreeImpl convertBreak(BreakStatement e) {
        IdentifierTreeImpl identifier = e.getLabel() == null ? null : this.createSimpleName(e.getLabel());
        this.usageLabel(identifier);
        return new BreakStatementTreeImpl(this.firstTokenIn(e, 82), identifier, this.lastTokenIn(e, 25));
    }

    private DoWhileStatementTreeImpl convertDoWhile(DoStatement e) {
        Statement body = e.getBody();
        Expression expression = e.getExpression();
        return new DoWhileStatementTreeImpl(this.firstTokenIn(e, 84), this.createStatement(body), this.firstTokenAfter(body, 79), this.firstTokenBefore(expression, 23), this.convertExpression(expression), this.firstTokenAfter(expression, 26), this.lastTokenIn(e, 25));
    }

    private AssertStatementTreeImpl convertAssert(AssertStatement e) {
        Expression message = e.getMessage();
        AssertStatementTreeImpl t = new AssertStatementTreeImpl(this.firstTokenIn(e, 81), this.convertExpression(e.getExpression()), this.lastTokenIn(e, 25));
        if (message != null) {
            t.complete(this.firstTokenBefore(message, 65), this.convertExpression(message));
        }
        return t;
    }

    private SwitchStatementTreeImpl convertSwitchStatement(SwitchStatement e) {
        Expression expression = e.getExpression();
        return new SwitchStatementTreeImpl(this.firstTokenIn(e, 63), this.firstTokenBefore(expression, 23), this.convertExpression(expression), this.firstTokenAfter(expression, 26), this.firstTokenAfter(expression, 39), this.convertSwitchStatements(e.statements()), this.lastTokenIn(e, 33));
    }

    private List<CaseGroupTreeImpl> convertSwitchStatements(List<?> list) {
        ArrayList<CaseGroupTreeImpl> groups = new ArrayList<CaseGroupTreeImpl>();
        ArrayList<CaseLabelTreeImpl> caselabels = null;
        StatementListTreeImpl body = null;
        for (Object o : list) {
            if (o instanceof SwitchCase) {
                if (caselabels == null) {
                    caselabels = new ArrayList<CaseLabelTreeImpl>();
                    body = StatementListTreeImpl.emptyList();
                }
                SwitchCase c = (SwitchCase)o;
                ArrayList<ExpressionTree> expressions = new ArrayList<ExpressionTree>();
                for (Object oo : c.expressions()) {
                    expressions.add(this.convertExpressionFromCase((Expression)oo));
                }
                caselabels.add(new CaseLabelTreeImpl(this.firstTokenIn(c, c.isDefault() ? 76 : 91), expressions, this.lastTokenIn(c, -1)));
                continue;
            }
            if (caselabels != null) {
                groups.add(new CaseGroupTreeImpl(caselabels, body));
            }
            caselabels = null;
            this.addStatementToList((Statement)o, Objects.requireNonNull(body));
        }
        if (caselabels != null) {
            groups.add(new CaseGroupTreeImpl(caselabels, body));
        }
        return groups;
    }

    private ExpressionTree convertExpressionFromCase(Expression e) {
        if (e.getNodeType() == 109) {
            return new DefaultPatternTreeImpl(this.firstTokenIn(e, 76));
        }
        if (e.getNodeType() == 33) {
            return new NullPatternTreeImpl((LiteralTreeImpl)this.convertExpression(e));
        }
        if (e instanceof Pattern) {
            return this.convertPattern((Pattern)e);
        }
        return this.convertExpression(e);
    }

    private PatternTree convertPattern(Pattern p) {
        switch (p.getNodeType()) {
            case 106: {
                return new TypePatternTreeImpl(this.convertVariable(((TypePattern)p).getPatternVariable()));
            }
            case 107: {
                GuardedPattern g = (GuardedPattern)p;
                return new GuardedPatternTreeImpl(this.convertPattern(g.getPattern()), this.firstTokenBefore(g.getExpression(), 29), this.convertExpression(g.getExpression()));
            }
        }
        throw new IllegalStateException(ASTNode.nodeClassForType(p.getNodeType()).toString());
    }

    private SynchronizedStatementTreeImpl convertSynchronized(SynchronizedStatement e) {
        Expression expression = e.getExpression();
        return new SynchronizedStatementTreeImpl(this.firstTokenIn(e, 40), this.firstTokenBefore(expression, 23), this.convertExpression(expression), this.firstTokenAfter(expression, 26), this.convertBlock(e.getBody()));
    }

    private ExpressionStatementTreeImpl convertExpressionStatement(ExpressionStatement e) {
        return new ExpressionStatementTreeImpl(this.convertExpression(e.getExpression()), this.lastTokenIn(e, 25));
    }

    private ContinueStatementTreeImpl convertContinue(ContinueStatement e) {
        SimpleName label = e.getLabel();
        IdentifierTreeImpl i = label == null ? null : this.createSimpleName(label);
        this.usageLabel(i);
        return new ContinueStatementTreeImpl(this.firstTokenIn(e, 83), i, this.lastTokenIn(e, 25));
    }

    private LabeledStatementTreeImpl convertLabel(LabeledStatement e) {
        IdentifierTreeImpl i = this.createSimpleName(e.getLabel());
        JLabelSymbol symbol = new JLabelSymbol(i.name());
        this.labels.push(symbol);
        LabeledStatementTreeImpl t = new LabeledStatementTreeImpl(i, this.firstTokenAfter(e.getLabel(), 65), this.createStatement(e.getBody()));
        this.labels.pop();
        symbol.declaration = t;
        t.labelSymbol = symbol;
        return t;
    }

    private ForEachStatementImpl convertForeach(EnhancedForStatement e) {
        SingleVariableDeclaration parameter = e.getParameter();
        Expression expression = e.getExpression();
        return new ForEachStatementImpl(this.firstTokenIn(e, 85), this.firstTokenBefore(parameter, 23), this.convertVariable(parameter), this.firstTokenAfter(parameter, 65), this.convertExpression(expression), this.firstTokenAfter(expression, 26), this.createStatement(e.getBody()));
    }

    private ThrowStatementTreeImpl convertThrow(ThrowStatement e) {
        return new ThrowStatementTreeImpl(this.firstTokenIn(e, 78), this.convertExpression(e.getExpression()), this.firstTokenAfter(e.getExpression(), 25));
    }

    private TryStatementTreeImpl convertTry(TryStatement e) {
        ResourceListTreeImpl resources = this.convertResources(e);
        List<CatchTree> catches = this.convertCatchClauses(e);
        Block f = e.getFinally();
        return new TryStatementTreeImpl(this.firstTokenIn(e, 88), resources.isEmpty() ? null : this.firstTokenIn(e, 23), resources, resources.isEmpty() ? null : this.firstTokenBefore(e.getBody(), 26), this.convertBlock(e.getBody()), catches, f == null ? null : this.firstTokenBefore(f, 116), f == null ? null : this.convertBlock(f));
    }

    private ResourceListTreeImpl convertResources(TryStatement e) {
        List r = e.resources();
        ResourceListTreeImpl resources = ResourceListTreeImpl.emptyList();
        for (int i = 0; i < r.size(); ++i) {
            Expression o = (Expression)r.get(i);
            if (58 == o.getNodeType()) {
                this.addVariableToList((VariableDeclarationExpression)o, resources);
            } else {
                resources.add(this.convertExpression(o));
            }
            this.addSeparatorToList(e, o, resources.separators(), i < e.resources().size() - 1);
        }
        return resources;
    }

    private void addSeparatorToList(TryStatement tryStatement, Expression resource, List<SyntaxToken> separators, boolean isLast) {
        if (isLast) {
            separators.add(this.firstTokenAfter(resource, 25));
        } else {
            int tokenIndex = this.tokenManager.firstIndexBefore(tryStatement.getBody(), 26);
            while (true) {
                Token token;
                if ((token = this.tokenManager.get(--tokenIndex)).isComment()) {
                    continue;
                }
                if (token.tokenType != 25) break;
                separators.add(this.createSyntaxToken(tokenIndex));
            }
        }
    }

    private List<CatchTree> convertCatchClauses(TryStatement e) {
        ArrayList<CatchTree> catches = new ArrayList<CatchTree>();
        for (Object o : e.catchClauses()) {
            CatchClause c = (CatchClause)o;
            catches.add(new CatchTreeImpl(this.firstTokenIn(c, 107), this.firstTokenBefore(c.getException(), 23), this.convertVariable(c.getException()), this.firstTokenAfter(c.getException(), 26), this.convertBlock(c.getBody())));
        }
        return catches;
    }

    private ExpressionStatementTreeImpl convertConstructorInvocation(ConstructorInvocation e) {
        ArgumentListTreeImpl arguments = this.convertArguments(e.arguments().isEmpty() ? this.lastTokenIn(e, 23) : this.firstTokenBefore((ASTNode)e.arguments().get(0), 23), e.arguments(), this.lastTokenIn(e, 26));
        IdentifierTreeImpl i = new IdentifierTreeImpl(e.arguments().isEmpty() ? this.lastTokenIn(e, 35) : this.firstTokenBefore((ASTNode)e.arguments().get(0), 35));
        MethodInvocationTreeImpl t = new MethodInvocationTreeImpl(i, this.convertTypeArguments(e.typeArguments()), arguments);
        t.methodBinding = e.resolveConstructorBinding();
        if (t.methodBinding != null) {
            t.typeBinding = t.methodBinding.getDeclaringClass();
            t.methodBinding = JParser.excludeRecovery(t.methodBinding, arguments.size());
        }
        i.binding = t.methodBinding;
        this.usage(i.binding, i);
        return new ExpressionStatementTreeImpl(t, this.lastTokenIn(e, 25));
    }

    private ExpressionStatementTreeImpl convertSuperConstructorInvocation(SuperConstructorInvocation e) {
        IdentifierTreeImpl i;
        AssessableExpressionTree methodSelect = i = new IdentifierTreeImpl(this.firstTokenIn(e, 34));
        if (e.getExpression() != null) {
            methodSelect = new MemberSelectExpressionTreeImpl(this.convertExpression(e.getExpression()), this.firstTokenAfter(e.getExpression(), 1), i);
        }
        ArgumentListTreeImpl arguments = this.convertArguments(this.firstTokenIn(e, 23), e.arguments(), this.lastTokenIn(e, 26));
        MethodInvocationTreeImpl t = new MethodInvocationTreeImpl(methodSelect, this.convertTypeArguments(e.typeArguments()), arguments);
        t.methodBinding = e.resolveConstructorBinding();
        if (t.methodBinding != null) {
            t.typeBinding = t.methodBinding.getDeclaringClass();
            t.methodBinding = JParser.excludeRecovery(t.methodBinding, arguments.size());
        }
        i.binding = t.methodBinding;
        this.usage(i.binding, i);
        return new ExpressionStatementTreeImpl(t, this.lastTokenIn(e, 25));
    }

    private YieldStatementTreeImpl convertYield(YieldStatement e) {
        return new YieldStatementTreeImpl(e.isImplicit() ? null : this.firstTokenIn(e, 19), this.convertExpression(e.getExpression()), this.lastTokenIn(e, 25));
    }

    private ExpressionTree convertExpression(Expression node) {
        ExpressionTree t = this.createExpression(node);
        ((AbstractTypedTree)((Object)t)).typeBinding = node.resolveTypeBinding();
        return t;
    }

    private ExpressionTree createExpression(Expression node) {
        switch (node.getNodeType()) {
            case 42: {
                return this.convertSimpleName((SimpleName)node);
            }
            case 40: {
                return this.convertQualifiedName((QualifiedName)node);
            }
            case 22: {
                return this.convertFieldAccess((FieldAccess)node);
            }
            case 47: {
                return this.convertFieldAccess((SuperFieldAccess)node);
            }
            case 52: {
                return this.convertThisExpression((ThisExpression)node);
            }
            case 2: {
                return this.convertArrayAccess((ArrayAccess)node);
            }
            case 3: {
                return this.convertArrayCreation((ArrayCreation)node);
            }
            case 4: {
                return this.convertArrayInitializer((ArrayInitializer)node);
            }
            case 7: {
                return this.convertAssignment((Assignment)node);
            }
            case 11: {
                return this.convertTypeCastExpression((CastExpression)node);
            }
            case 14: {
                return this.convertClassInstanceCreation((ClassInstanceCreation)node);
            }
            case 16: {
                return this.convertConditionalExpression((ConditionalExpression)node);
            }
            case 27: {
                return this.convertInfixExpression((InfixExpression)node);
            }
            case 32: {
                return this.convertMethodInvocation((MethodInvocation)node);
            }
            case 48: {
                return this.convertMethodInvocation((SuperMethodInvocation)node);
            }
            case 36: {
                return this.convertParenthesizedExpression((ParenthesizedExpression)node);
            }
            case 37: {
                return this.convertPostfixExpression((PostfixExpression)node);
            }
            case 38: {
                return this.convertPrefixExpression((PrefixExpression)node);
            }
            case 62: {
                return this.convertInstanceOf((InstanceofExpression)node);
            }
            case 104: {
                return this.convertInstanceOf((PatternInstanceofExpression)node);
            }
            case 86: {
                return this.convertLambdaExpression((LambdaExpression)node);
            }
            case 89: {
                return this.convertMethodReference((CreationReference)node);
            }
            case 90: {
                return this.convertMethodReference((ExpressionMethodReference)node);
            }
            case 92: {
                return this.convertMethodReference((TypeMethodReference)node);
            }
            case 91: {
                return this.convertMethodReference((SuperMethodReference)node);
            }
            case 100: {
                return this.convertSwitchExpression((SwitchExpression)node);
            }
            case 57: {
                return this.convertTypeLiteral((TypeLiteral)node);
            }
            case 33: {
                return this.convertLiteral((NullLiteral)node);
            }
            case 34: {
                return this.convertLiteral((NumberLiteral)node);
            }
            case 13: {
                return this.convertLiteral((CharacterLiteral)node);
            }
            case 9: {
                return this.convertLiteral((BooleanLiteral)node);
            }
            case 45: {
                return this.convertLiteral((StringLiteral)node);
            }
            case 102: {
                return this.convertTextBlock((TextBlock)node);
            }
            case 77: 
            case 78: 
            case 79: {
                return this.convertAnnotation((Annotation)node);
            }
        }
        throw new IllegalStateException(ASTNode.nodeClassForType(node.getNodeType()).toString());
    }

    private IdentifierTreeImpl convertSimpleName(SimpleName e) {
        IdentifierTreeImpl t = this.createSimpleName(e);
        this.usage(t.binding, t);
        return t;
    }

    private MemberSelectExpressionTreeImpl convertQualifiedName(QualifiedName e) {
        IdentifierTreeImpl rhs = this.createSimpleName(e.getName());
        this.usage(rhs.binding, rhs);
        return new MemberSelectExpressionTreeImpl(this.convertExpression(e.getQualifier()), this.firstTokenAfter(e.getQualifier(), 1), rhs);
    }

    private MemberSelectExpressionTreeImpl convertFieldAccess(FieldAccess e) {
        IdentifierTreeImpl rhs = this.createSimpleName(e.getName());
        this.usage(rhs.binding, rhs);
        return new MemberSelectExpressionTreeImpl(this.convertExpression(e.getExpression()), this.firstTokenAfter(e.getExpression(), 1), rhs);
    }

    private MemberSelectExpressionTreeImpl convertFieldAccess(SuperFieldAccess e) {
        IdentifierTreeImpl rhs = this.createSimpleName(e.getName());
        this.usage(rhs.binding, rhs);
        if (e.getQualifier() == null) {
            return new MemberSelectExpressionTreeImpl(this.unqualifiedKeywordSuper(e), this.firstTokenIn(e, 1), rhs);
        }
        AbstractTypedTree qualifier = (AbstractTypedTree)((Object)this.convertExpression(e.getQualifier()));
        KeywordSuper keywordSuper = new KeywordSuper(this.firstTokenAfter(e.getQualifier(), 34), null);
        MemberSelectExpressionTreeImpl qualifiedSuper = new MemberSelectExpressionTreeImpl((ExpressionTree)((Object)qualifier), this.firstTokenAfter(e.getQualifier(), 1), keywordSuper);
        if (qualifier.typeBinding != null) {
            keywordSuper.typeBinding = qualifier.typeBinding;
            qualifiedSuper.typeBinding = keywordSuper.typeBinding.getSuperclass();
        }
        return new MemberSelectExpressionTreeImpl(qualifiedSuper, this.firstTokenBefore(e.getName(), 1), rhs);
    }

    private ExpressionTree convertThisExpression(ThisExpression e) {
        if (e.getQualifier() == null) {
            return new KeywordThis(this.firstTokenIn(e, 35), null);
        }
        KeywordThis keywordThis = new KeywordThis(this.firstTokenAfter(e.getQualifier(), 35), e.resolveTypeBinding());
        return new MemberSelectExpressionTreeImpl(this.convertExpression(e.getQualifier()), this.firstTokenAfter(e.getQualifier(), 1), keywordThis);
    }

    private MemberSelectExpressionTreeImpl convertTypeLiteral(TypeLiteral e) {
        return new MemberSelectExpressionTreeImpl((ExpressionTree)((Object)this.convertType(e.getType())), this.lastTokenIn(e, 1), new IdentifierTreeImpl(this.lastTokenIn(e, 70)));
    }

    private ArrayAccessExpressionTreeImpl convertArrayAccess(ArrayAccess e) {
        Expression index = e.getIndex();
        return new ArrayAccessExpressionTreeImpl(this.convertExpression(e.getArray()), new ArrayDimensionTreeImpl(this.firstTokenBefore(index, 6), this.convertExpression(index), this.firstTokenAfter(index, 69)));
    }

    private NewArrayTreeImpl convertArrayCreation(ArrayCreation e) {
        TypeTree type;
        ArrayList<ArrayDimensionTree> dimensions = new ArrayList<ArrayDimensionTree>();
        for (Object o : e.dimensions()) {
            dimensions.add(new ArrayDimensionTreeImpl(this.firstTokenBefore((Expression)o, 6), this.convertExpression((Expression)o), this.firstTokenAfter((Expression)o, 69)));
        }
        InitializerListTreeImpl initializers = InitializerListTreeImpl.emptyList();
        if (e.getInitializer() != null) {
            assert (dimensions.isEmpty());
            type = this.convertType(e.getType());
            while (type.is(Tree.Kind.ARRAY_TYPE)) {
                ArrayTypeTree arrayType = (ArrayTypeTree)type;
                ArrayDimensionTreeImpl dimension = new ArrayDimensionTreeImpl(arrayType.openBracketToken(), null, arrayType.closeBracketToken()).completeAnnotations(arrayType.annotations());
                dimensions.add(0, dimension);
                type = arrayType.type();
            }
            return ((NewArrayTreeImpl)this.convertExpression(e.getInitializer())).completeWithNewKeyword(this.firstTokenIn(e, 37)).complete(type).completeDimensions(dimensions);
        }
        type = this.convertType(e.getType());
        int index = dimensions.size() - 1;
        while (type.is(Tree.Kind.ARRAY_TYPE)) {
            if (!type.annotations().isEmpty()) {
                ((ArrayDimensionTreeImpl)dimensions.get(index)).completeAnnotations(type.annotations());
            }
            --index;
            type = ((ArrayTypeTree)type).type();
        }
        return new NewArrayTreeImpl(dimensions, initializers).complete(type).completeWithNewKeyword(this.firstTokenIn(e, 37));
    }

    private NewArrayTreeImpl convertArrayInitializer(ArrayInitializer e) {
        InitializerListTreeImpl initializers = InitializerListTreeImpl.emptyList();
        for (int i = 0; i < e.expressions().size(); ++i) {
            Expression o = (Expression)e.expressions().get(i);
            initializers.add(this.convertExpression(o));
            int commaTokenIndex = this.firstTokenIndexAfter(o);
            if (this.tokenManager.get((int)commaTokenIndex).tokenType != 32) continue;
            initializers.separators().add(this.firstTokenAfter(o, 32));
        }
        return new NewArrayTreeImpl(Collections.emptyList(), initializers).completeWithCurlyBraces(this.firstTokenIn(e, 39), this.lastTokenIn(e, 33));
    }

    private AssignmentExpressionTreeImpl convertAssignment(Assignment e) {
        Op op = operators.get(e.getOperator());
        return new AssignmentExpressionTreeImpl(op.kind, this.convertExpression(e.getLeftHandSide()), this.firstTokenAfter(e.getLeftHandSide(), op.tokenType), this.convertExpression(e.getRightHandSide()));
    }

    private TypeCastExpressionTreeImpl convertTypeCastExpression(CastExpression e) {
        Type type = e.getType();
        if (type.getNodeType() == 87) {
            List intersectionTypes = ((IntersectionType)type).types();
            QualifiedIdentifierListTreeImpl bounds = QualifiedIdentifierListTreeImpl.emptyList();
            for (int i = 1; i < intersectionTypes.size(); ++i) {
                Type o = (Type)intersectionTypes.get(i);
                bounds.add(this.convertType(o));
                if (i >= intersectionTypes.size() - 1) continue;
                bounds.separators().add(this.firstTokenAfter(o, 22));
            }
            return new TypeCastExpressionTreeImpl(this.firstTokenBefore(type, 23), this.convertType((Type)intersectionTypes.get(0)), this.firstTokenAfter((Type)intersectionTypes.get(0), 22), bounds, this.firstTokenAfter(type, 26), this.convertExpression(e.getExpression()));
        }
        return new TypeCastExpressionTreeImpl(this.firstTokenBefore(type, 23), this.convertType(type), this.firstTokenAfter(type, 26), this.convertExpression(e.getExpression()));
    }

    private NewClassTreeImpl convertClassInstanceCreation(ClassInstanceCreation e) {
        ArgumentListTreeImpl arguments = this.convertArguments(this.firstTokenAfter(e.getType(), 23), e.arguments(), this.firstTokenAfter(e.arguments().isEmpty() ? e.getType() : (ASTNode)e.arguments().get(e.arguments().size() - 1), 26));
        ClassTreeImpl classBody = null;
        if (e.getAnonymousClassDeclaration() != null) {
            ArrayList<Tree> members = new ArrayList<Tree>();
            for (Object o : e.getAnonymousClassDeclaration().bodyDeclarations()) {
                this.processBodyDeclaration((BodyDeclaration)o, members);
            }
            classBody = new ClassTreeImpl(Tree.Kind.CLASS, this.firstTokenIn(e.getAnonymousClassDeclaration(), 39), members, this.lastTokenIn(e.getAnonymousClassDeclaration(), 33));
            classBody.typeBinding = e.getAnonymousClassDeclaration().resolveBinding();
            this.declaration(classBody.typeBinding, classBody);
        }
        NewClassTreeImpl t = new NewClassTreeImpl(this.convertType(e.getType()), arguments, classBody).completeWithNewKeyword(e.getExpression() == null ? this.firstTokenIn(e, 37) : this.firstTokenAfter(e.getExpression(), 37)).completeWithTypeArguments(this.convertTypeArguments(e.typeArguments()));
        if (e.getExpression() != null) {
            t.completeWithEnclosingExpression(this.convertExpression(e.getExpression()));
            t.completeWithDotToken(this.firstTokenAfter(e.getExpression(), 1));
        }
        IdentifierTreeImpl i = (IdentifierTreeImpl)t.getConstructorIdentifier();
        int nbArguments = arguments.size();
        i.binding = e.getAnonymousClassDeclaration() == null ? JParser.excludeRecovery(e.resolveConstructorBinding(), nbArguments) : JParser.excludeRecovery(JParser.findConstructorForAnonymousClass(e.getAST(), i.typeBinding, e.resolveConstructorBinding()), nbArguments);
        this.usage(i.binding, i);
        return t;
    }

    private ConditionalExpressionTreeImpl convertConditionalExpression(ConditionalExpression e) {
        return new ConditionalExpressionTreeImpl(this.convertExpression(e.getExpression()), this.firstTokenAfter(e.getExpression(), 30), this.convertExpression(e.getThenExpression()), this.firstTokenAfter(e.getThenExpression(), 65), this.convertExpression(e.getElseExpression()));
    }

    private BinaryExpressionTreeImpl convertInfixExpression(InfixExpression e) {
        Op op = operators.get(e.getOperator());
        BinaryExpressionTreeImpl t = new BinaryExpressionTreeImpl(op.kind, this.convertExpression(e.getLeftOperand()), this.firstTokenAfter(e.getLeftOperand(), op.tokenType), this.convertExpression(e.getRightOperand()));
        for (Object o : e.extendedOperands()) {
            Expression e2 = (Expression)o;
            t.typeBinding = e.resolveTypeBinding();
            t = new BinaryExpressionTreeImpl(op.kind, t, this.firstTokenBefore(e2, op.tokenType), this.convertExpression(e2));
        }
        return t;
    }

    private MethodInvocationTreeImpl convertMethodInvocation(MethodInvocation e) {
        ArgumentListTreeImpl arguments = this.convertArguments(this.firstTokenAfter(e.getName(), 23), e.arguments(), this.lastTokenIn(e, 26));
        IdentifierTreeImpl rhs = this.createSimpleName(e.getName());
        AssessableExpressionTree memberSelect = e.getExpression() == null ? rhs : new MemberSelectExpressionTreeImpl(this.convertExpression(e.getExpression()), this.firstTokenAfter(e.getExpression(), 1), rhs);
        MethodInvocationTreeImpl t = new MethodInvocationTreeImpl(memberSelect, this.convertTypeArguments(e.typeArguments()), arguments);
        t.methodBinding = JParser.excludeRecovery(e.resolveMethodBinding(), arguments.size());
        rhs.binding = t.methodBinding;
        this.usage(rhs.binding, rhs);
        return t;
    }

    private MethodInvocationTreeImpl convertMethodInvocation(SuperMethodInvocation e) {
        MemberSelectExpressionTreeImpl outermostSelect;
        ArgumentListTreeImpl arguments = this.convertArguments(this.firstTokenIn(e, 23), e.arguments(), this.lastTokenIn(e, 26));
        IdentifierTreeImpl rhs = this.createSimpleName(e.getName());
        if (e.getQualifier() == null) {
            outermostSelect = new MemberSelectExpressionTreeImpl(this.unqualifiedKeywordSuper(e), this.firstTokenIn(e, 1), rhs);
        } else {
            int firstDotTokenIndex = this.tokenManager.firstIndexAfter(e.getQualifier(), 1);
            AbstractTypedTree qualifier = (AbstractTypedTree)((Object)this.convertExpression(e.getQualifier()));
            KeywordSuper keywordSuper = new KeywordSuper(this.firstTokenAfter(e.getQualifier(), 34), null);
            MemberSelectExpressionTreeImpl qualifiedSuper = new MemberSelectExpressionTreeImpl((ExpressionTree)((Object)qualifier), this.createSyntaxToken(firstDotTokenIndex), keywordSuper);
            if (qualifier.typeBinding != null) {
                keywordSuper.typeBinding = qualifier.typeBinding;
                qualifiedSuper.typeBinding = keywordSuper.typeBinding.getSuperclass();
            }
            outermostSelect = new MemberSelectExpressionTreeImpl(qualifiedSuper, this.createSyntaxToken(this.nextTokenIndex(firstDotTokenIndex, 1)), rhs);
        }
        MethodInvocationTreeImpl t = new MethodInvocationTreeImpl(outermostSelect, null, arguments);
        t.methodBinding = JParser.excludeRecovery(e.resolveMethodBinding(), arguments.size());
        rhs.binding = t.methodBinding;
        this.usage(rhs.binding, rhs);
        return t;
    }

    private ParenthesizedTreeImpl convertParenthesizedExpression(ParenthesizedExpression e) {
        return new ParenthesizedTreeImpl(this.firstTokenIn(e, 23), this.convertExpression(e.getExpression()), this.firstTokenAfter(e.getExpression(), 26));
    }

    private InternalPostfixUnaryExpression convertPostfixExpression(PostfixExpression e) {
        Op op = operators.get(e.getOperator());
        return new InternalPostfixUnaryExpression(op.kind, this.convertExpression(e.getOperand()), this.firstTokenAfter(e.getOperand(), op.tokenType));
    }

    private InternalPrefixUnaryExpression convertPrefixExpression(PrefixExpression e) {
        Op op = operators.get(e.getOperator());
        return new InternalPrefixUnaryExpression(op.kind, this.firstTokenIn(e, op.tokenType), this.convertExpression(e.getOperand()));
    }

    private InstanceOfTreeImpl convertInstanceOf(InstanceofExpression e) {
        Expression leftOperand = e.getLeftOperand();
        InternalSyntaxToken instanceofToken = this.firstTokenAfter(leftOperand, 17);
        return new InstanceOfTreeImpl(this.convertExpression(leftOperand), instanceofToken, this.convertType(e.getRightOperand()));
    }

    private InstanceOfTreeImpl convertInstanceOf(PatternInstanceofExpression e) {
        Expression leftOperand = e.getLeftOperand();
        InternalSyntaxToken instanceofToken = this.firstTokenAfter(leftOperand, 17);
        return new InstanceOfTreeImpl(this.convertExpression(leftOperand), instanceofToken, this.convertVariable(e.getRightOperand()));
    }

    private LambdaExpressionTreeImpl convertLambdaExpression(LambdaExpression e) {
        ArrayList<VariableTree> parameters = new ArrayList<VariableTree>();
        for (int i = 0; i < e.parameters().size(); ++i) {
            VariableTreeImpl t;
            VariableDeclaration o = (VariableDeclaration)e.parameters().get(i);
            if (o.getNodeType() == 59) {
                t = new VariableTreeImpl(this.createSimpleName(o.getName()));
                IVariableBinding variableBinding = o.resolveBinding();
                if (variableBinding != null) {
                    t.variableBinding = variableBinding;
                    ((InferedTypeTree)t.type()).typeBinding = variableBinding.getType();
                    this.declaration(t.variableBinding, t);
                }
            } else {
                t = this.convertVariable((SingleVariableDeclaration)o);
            }
            parameters.add(t);
            if (i >= e.parameters().size() - 1) continue;
            t.setEndToken(this.firstTokenAfter(o, 32));
        }
        ASTNode body = e.getBody();
        return new LambdaExpressionTreeImpl(e.hasParentheses() ? this.firstTokenIn(e, 23) : null, parameters, e.hasParentheses() ? this.firstTokenBefore(body, 26) : null, this.firstTokenBefore(body, 104), body.getNodeType() == 8 ? this.convertBlock((Block)body) : this.convertExpression((Expression)body));
    }

    private MethodReferenceTreeImpl convertMethodReference(CreationReference e) {
        MethodReferenceTreeImpl t = new MethodReferenceTreeImpl(this.convertType(e.getType()), this.lastTokenIn(e, 7));
        IdentifierTreeImpl i = new IdentifierTreeImpl(this.lastTokenIn(e, 37));
        i.binding = e.resolveMethodBinding();
        this.usage(i.binding, i);
        t.complete(this.convertTypeArguments(e.typeArguments()), i);
        return t;
    }

    private MethodReferenceTreeImpl convertMethodReference(ExpressionMethodReference e) {
        MethodReferenceTreeImpl t = new MethodReferenceTreeImpl(this.convertExpression(e.getExpression()), this.firstTokenAfter(e.getExpression(), 7));
        IdentifierTreeImpl i = this.createSimpleName(e.getName());
        this.usage(i.binding, i);
        t.complete(this.convertTypeArguments(e.typeArguments()), i);
        return t;
    }

    private MethodReferenceTreeImpl convertMethodReference(TypeMethodReference e) {
        MethodReferenceTreeImpl t = new MethodReferenceTreeImpl(this.convertType(e.getType()), this.firstTokenAfter(e.getType(), 7));
        IdentifierTreeImpl i = this.createSimpleName(e.getName());
        this.usage(i.binding, i);
        t.complete(this.convertTypeArguments(e.typeArguments()), i);
        return t;
    }

    private MethodReferenceTreeImpl convertMethodReference(SuperMethodReference e) {
        MethodReferenceTreeImpl t = e.getQualifier() != null ? new MethodReferenceTreeImpl(new MemberSelectExpressionTreeImpl(this.convertExpression(e.getQualifier()), this.firstTokenAfter(e.getQualifier(), 1), this.unqualifiedKeywordSuper(e)), this.firstTokenAfter(e.getQualifier(), 7)) : new MethodReferenceTreeImpl(this.unqualifiedKeywordSuper(e), this.firstTokenIn(e, 7));
        IdentifierTreeImpl i = this.createSimpleName(e.getName());
        this.usage(i.binding, i);
        t.complete(this.convertTypeArguments(e.typeArguments()), i);
        return t;
    }

    private SwitchExpressionTreeImpl convertSwitchExpression(SwitchExpression e) {
        Expression expr = e.getExpression();
        return new SwitchExpressionTreeImpl(this.firstTokenIn(e, 63), this.firstTokenIn(e, 23), this.convertExpression(expr), this.firstTokenAfter(expr, 26), this.firstTokenAfter(expr, 39), this.convertSwitchStatements(e.statements()), this.lastTokenIn(e, 33));
    }

    private LiteralTreeImpl convertLiteral(NullLiteral e) {
        return new LiteralTreeImpl(Tree.Kind.NULL_LITERAL, this.firstTokenIn(e, 53));
    }

    private ExpressionTree convertLiteral(NumberLiteral e) {
        LiteralTreeImpl result;
        boolean unaryMinus;
        int tokenIndex = this.tokenManager.findIndex(e.getStartPosition(), -1, true);
        int tokenType = this.tokenManager.get((int)tokenIndex).tokenType;
        boolean bl = unaryMinus = tokenType == 5;
        if (unaryMinus) {
            tokenType = this.tokenManager.get((int)(++tokenIndex)).tokenType;
        }
        switch (tokenType) {
            case 55: {
                result = new LiteralTreeImpl(Tree.Kind.INT_LITERAL, this.createSyntaxToken(tokenIndex));
                break;
            }
            case 56: {
                result = new LiteralTreeImpl(Tree.Kind.LONG_LITERAL, this.createSyntaxToken(tokenIndex));
                break;
            }
            case 57: {
                result = new LiteralTreeImpl(Tree.Kind.FLOAT_LITERAL, this.createSyntaxToken(tokenIndex));
                break;
            }
            case 58: {
                result = new LiteralTreeImpl(Tree.Kind.DOUBLE_LITERAL, this.createSyntaxToken(tokenIndex));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        result.typeBinding = e.resolveTypeBinding();
        if (unaryMinus) {
            return new InternalPrefixUnaryExpression(Tree.Kind.UNARY_MINUS, this.createSyntaxToken(tokenIndex - 1), result);
        }
        return result;
    }

    private LiteralTreeImpl convertLiteral(CharacterLiteral e) {
        return new LiteralTreeImpl(Tree.Kind.CHAR_LITERAL, this.firstTokenIn(e, 59));
    }

    private LiteralTreeImpl convertLiteral(BooleanLiteral e) {
        InternalSyntaxToken value = this.firstTokenIn(e, e.booleanValue() ? 54 : 52);
        return new LiteralTreeImpl(Tree.Kind.BOOLEAN_LITERAL, value);
    }

    private LiteralTreeImpl convertLiteral(StringLiteral e) {
        return new LiteralTreeImpl(Tree.Kind.STRING_LITERAL, this.firstTokenIn(e, 60));
    }

    private LiteralTreeImpl convertTextBlock(TextBlock e) {
        return new LiteralTreeImpl(Tree.Kind.TEXT_BLOCK, this.firstTokenIn(e, 61));
    }

    private AnnotationTreeImpl convertAnnotation(Annotation e) {
        ArgumentListTreeImpl arguments = ArgumentListTreeImpl.emptyList();
        if (e.getNodeType() == 79) {
            arguments.add(this.convertExpression(((SingleMemberAnnotation)e).getValue()));
            arguments.complete(this.firstTokenIn(e, 23), this.lastTokenIn(e, 26));
        } else if (e.getNodeType() == 77) {
            for (int i = 0; i < ((NormalAnnotation)e).values().size(); ++i) {
                MemberValuePair o = (MemberValuePair)((NormalAnnotation)e).values().get(i);
                arguments.add(new AssignmentExpressionTreeImpl(Tree.Kind.ASSIGNMENT, this.createSimpleName(o.getName()), this.firstTokenAfter(o.getName(), 77), this.convertExpression(o.getValue())));
                if (i >= ((NormalAnnotation)e).values().size() - 1) continue;
                arguments.separators().add(this.firstTokenAfter(o, 32));
            }
            arguments.complete(this.firstTokenIn(e, 23), this.lastTokenIn(e, 26));
        }
        return new AnnotationTreeImpl(this.firstTokenIn(e, 36), (TypeTree)((Object)this.convertExpression(e.getTypeName())), arguments);
    }

    private KeywordSuper unqualifiedKeywordSuper(ASTNode node) {
        InternalSyntaxToken token = this.firstTokenIn(node, 34);
        while (!(node instanceof AbstractTypeDeclaration)) {
            if (node instanceof AnonymousClassDeclaration) {
                return new KeywordSuper(token, ((AnonymousClassDeclaration)node).resolveBinding());
            }
            node = node.getParent();
        }
        return new KeywordSuper(token, ((AbstractTypeDeclaration)node).resolveBinding());
    }

    private TypeTree convertType(Type node) {
        switch (node.getNodeType()) {
            case 39: {
                return this.convertPrimitiveType((PrimitiveType)node);
            }
            case 43: {
                return this.convertSimpleType((SimpleType)node);
            }
            case 84: {
                return this.convertUnionType((UnionType)node);
            }
            case 5: {
                return this.convertArrayType((ArrayType)node);
            }
            case 74: {
                return this.convertParameterizedType((ParameterizedType)node);
            }
            case 75: {
                return this.convertQualifiedType((QualifiedType)node);
            }
            case 88: {
                return this.convertNamedQualifiedType((NameQualifiedType)node);
            }
            case 76: {
                return this.convertWildcardType((WildcardType)node);
            }
        }
        throw new IllegalStateException(ASTNode.nodeClassForType(node.getNodeType()).toString());
    }

    private JavaTree.PrimitiveTypeTreeImpl convertPrimitiveType(PrimitiveType e) {
        JavaTree.PrimitiveTypeTreeImpl t;
        switch (e.getPrimitiveTypeCode().toString()) {
            case "byte": {
                t = new JavaTree.PrimitiveTypeTreeImpl(this.lastTokenIn(e, 106));
                break;
            }
            case "short": {
                t = new JavaTree.PrimitiveTypeTreeImpl(this.lastTokenIn(e, 114));
                break;
            }
            case "char": {
                t = new JavaTree.PrimitiveTypeTreeImpl(this.lastTokenIn(e, 108));
                break;
            }
            case "int": {
                t = new JavaTree.PrimitiveTypeTreeImpl(this.lastTokenIn(e, 112));
                break;
            }
            case "long": {
                t = new JavaTree.PrimitiveTypeTreeImpl(this.lastTokenIn(e, 113));
                break;
            }
            case "float": {
                t = new JavaTree.PrimitiveTypeTreeImpl(this.lastTokenIn(e, 110));
                break;
            }
            case "double": {
                t = new JavaTree.PrimitiveTypeTreeImpl(this.lastTokenIn(e, 109));
                break;
            }
            case "boolean": {
                t = new JavaTree.PrimitiveTypeTreeImpl(this.lastTokenIn(e, 105));
                break;
            }
            case "void": {
                t = new JavaTree.PrimitiveTypeTreeImpl(this.lastTokenIn(e, 115));
                break;
            }
            default: {
                throw new IllegalStateException(e.getPrimitiveTypeCode().toString());
            }
        }
        t.complete(this.convertAnnotations(e.annotations()));
        t.typeBinding = e.resolveBinding();
        return t;
    }

    private JavaTree.AnnotatedTypeTree convertSimpleType(SimpleType e) {
        ArrayList<AnnotationTree> annotations = new ArrayList<AnnotationTree>();
        for (Object o : e.annotations()) {
            annotations.add((AnnotationTree)this.convertExpression((Annotation)o));
        }
        VarTypeTreeImpl t = e.isVar() ? this.convertVarType(e) : (JavaTree.AnnotatedTypeTree)((Object)this.convertExpression(e.getName()));
        t.complete(annotations);
        return t;
    }

    private JavaTree.UnionTypeTreeImpl convertUnionType(UnionType e) {
        QualifiedIdentifierListTreeImpl alternatives = QualifiedIdentifierListTreeImpl.emptyList();
        for (int i = 0; i < e.types().size(); ++i) {
            Type o = (Type)e.types().get(i);
            alternatives.add(this.convertType(o));
            if (i >= e.types().size() - 1) continue;
            alternatives.separators().add(this.firstTokenAfter(o, 28));
        }
        JavaTree.UnionTypeTreeImpl t = new JavaTree.UnionTypeTreeImpl(alternatives);
        t.typeBinding = e.resolveBinding();
        return t;
    }

    private TypeTree convertArrayType(ArrayType e) {
        ITypeBinding elementTypeBinding = e.getElementType().resolveBinding();
        TypeTree t = this.convertType(e.getElementType());
        int tokenIndex = this.tokenManager.firstIndexAfter(e.getElementType(), 6);
        for (int i = 0; i < e.dimensions().size(); ++i) {
            if (i > 0) {
                tokenIndex = this.nextTokenIndex(tokenIndex, 6);
            }
            t = new JavaTree.ArrayTypeTreeImpl(t, this.convertAnnotations(((Dimension)e.dimensions().get(i)).annotations()), this.createSyntaxToken(tokenIndex), this.createSyntaxToken(this.nextTokenIndex(tokenIndex, 69)));
            if (elementTypeBinding == null) continue;
            ((JavaTree.ArrayTypeTreeImpl)t).typeBinding = elementTypeBinding.createArrayType(i + 1);
        }
        return t;
    }

    private JavaTree.ParameterizedTypeTreeImpl convertParameterizedType(ParameterizedType e) {
        int pos = e.getStartPosition() + e.getLength() - 1;
        JavaTree.ParameterizedTypeTreeImpl t = new JavaTree.ParameterizedTypeTreeImpl(this.convertType(e.getType()), this.convertTypeArguments(this.firstTokenAfter(e.getType(), 11), e.typeArguments(), new InternalSyntaxToken(this.compilationUnit.getLineNumber(pos), this.compilationUnit.getColumnNumber(pos), ">", Collections.emptyList(), false)));
        t.typeBinding = e.resolveBinding();
        return t;
    }

    private MemberSelectExpressionTreeImpl convertQualifiedType(QualifiedType e) {
        MemberSelectExpressionTreeImpl t = new MemberSelectExpressionTreeImpl((ExpressionTree)((Object)this.convertType(e.getQualifier())), this.firstTokenAfter(e.getQualifier(), 1), this.createSimpleName(e.getName()));
        ((IdentifierTreeImpl)t.identifier()).complete(this.convertAnnotations(e.annotations()));
        t.typeBinding = e.resolveBinding();
        return t;
    }

    private MemberSelectExpressionTreeImpl convertNamedQualifiedType(NameQualifiedType e) {
        MemberSelectExpressionTreeImpl t = new MemberSelectExpressionTreeImpl(this.convertExpression(e.getQualifier()), this.firstTokenAfter(e.getQualifier(), 1), this.createSimpleName(e.getName()));
        ((IdentifierTreeImpl)t.identifier()).complete(this.convertAnnotations(e.annotations()));
        t.typeBinding = e.resolveBinding();
        return t;
    }

    private JavaTree.WildcardTreeImpl convertWildcardType(WildcardType e) {
        InternalSyntaxToken questionToken = e.annotations().isEmpty() ? this.firstTokenIn(e, 30) : this.firstTokenAfter((ASTNode)e.annotations().get(e.annotations().size() - 1), 30);
        Type bound = e.getBound();
        JavaTree.WildcardTreeImpl t = bound == null ? new JavaTree.WildcardTreeImpl(questionToken) : new JavaTree.WildcardTreeImpl(e.isUpperBound() ? Tree.Kind.EXTENDS_WILDCARD : Tree.Kind.SUPER_WILDCARD, e.isUpperBound() ? this.firstTokenBefore(bound, 92) : this.firstTokenBefore(bound, 34), this.convertType(bound)).complete(questionToken);
        t.complete(this.convertAnnotations(e.annotations()));
        t.typeBinding = e.resolveBinding();
        return t;
    }

    @Nullable
    private static IMethodBinding excludeRecovery(@Nullable IMethodBinding methodBinding, int arguments) {
        if (methodBinding == null) {
            return null;
        }
        if (methodBinding.isVarargs() ? arguments + 1 < methodBinding.getParameterTypes().length : arguments != methodBinding.getParameterTypes().length) {
            return null;
        }
        return methodBinding;
    }

    @Nullable
    private static IMethodBinding findConstructorForAnonymousClass(AST ast, @Nullable ITypeBinding typeBinding, @Nullable IMethodBinding methodBinding) {
        if (typeBinding == null || methodBinding == null) {
            return null;
        }
        if (typeBinding.isInterface()) {
            typeBinding = ast.resolveWellKnownType("java.lang.Object");
        }
        for (IMethodBinding m : typeBinding.getDeclaredMethods()) {
            if (!methodBinding.isSubsignature(m)) continue;
            return m;
        }
        return null;
    }

    private List<AnnotationTree> convertAnnotations(List<?> e) {
        ArrayList<AnnotationTree> annotations = new ArrayList<AnnotationTree>();
        for (Object o : e) {
            annotations.add((AnnotationTree)this.convertExpression((Annotation)o));
        }
        return annotations;
    }

    private ModifiersTreeImpl convertModifiers(List<?> source) {
        ArrayList<ModifierTree> modifiers = new ArrayList<ModifierTree>();
        for (Object o : source) {
            modifiers.add(this.convertModifier((IExtendedModifier)o));
        }
        return new ModifiersTreeImpl((List<ModifierTree>)modifiers);
    }

    private ModifierTree convertModifier(IExtendedModifier node) {
        switch (((ASTNode)((Object)node)).getNodeType()) {
            case 77: 
            case 78: 
            case 79: {
                return (AnnotationTree)this.convertExpression((Expression)((Object)node));
            }
            case 83: {
                return this.convertModifier((org.eclipse.jdt.core.dom.Modifier)node);
            }
        }
        throw new IllegalStateException(ASTNode.nodeClassForType(((ASTNode)((Object)node)).getNodeType()).toString());
    }

    private ModifierTree convertModifier(org.eclipse.jdt.core.dom.Modifier node) {
        switch (node.getKeyword().toString()) {
            case "public": {
                return new ModifierKeywordTreeImpl(Modifier.PUBLIC, this.firstTokenIn(node, 48));
            }
            case "protected": {
                return new ModifierKeywordTreeImpl(Modifier.PROTECTED, this.firstTokenIn(node, 47));
            }
            case "private": {
                return new ModifierKeywordTreeImpl(Modifier.PRIVATE, this.firstTokenIn(node, 46));
            }
            case "static": {
                return new ModifierKeywordTreeImpl(Modifier.STATIC, this.firstTokenIn(node, 38));
            }
            case "abstract": {
                return new ModifierKeywordTreeImpl(Modifier.ABSTRACT, this.firstTokenIn(node, 42));
            }
            case "final": {
                return new ModifierKeywordTreeImpl(Modifier.FINAL, this.firstTokenIn(node, 43));
            }
            case "native": {
                return new ModifierKeywordTreeImpl(Modifier.NATIVE, this.firstTokenIn(node, 44));
            }
            case "synchronized": {
                return new ModifierKeywordTreeImpl(Modifier.SYNCHRONIZED, this.firstTokenIn(node, 40));
            }
            case "transient": {
                return new ModifierKeywordTreeImpl(Modifier.TRANSIENT, this.firstTokenIn(node, 50));
            }
            case "volatile": {
                return new ModifierKeywordTreeImpl(Modifier.VOLATILE, this.firstTokenIn(node, 51));
            }
            case "strictfp": {
                return new ModifierKeywordTreeImpl(Modifier.STRICTFP, this.firstTokenIn(node, 49));
            }
            case "default": {
                return new ModifierKeywordTreeImpl(Modifier.DEFAULT, this.firstTokenIn(node, 76));
            }
            case "sealed": {
                return new ModifierKeywordTreeImpl(Modifier.SEALED, this.firstTokenIn(node, 41));
            }
            case "non-sealed": {
                return new ModifierKeywordTreeImpl(Modifier.NON_SEALED, this.firstTokenIn(node, 45));
            }
        }
        throw new IllegalStateException(node.getKeyword().toString());
    }

    static {
        operators.put(PrefixExpression.Operator.PLUS, new Op(Tree.Kind.UNARY_PLUS, 4));
        operators.put(PrefixExpression.Operator.MINUS, new Op(Tree.Kind.UNARY_MINUS, 5));
        operators.put(PrefixExpression.Operator.NOT, new Op(Tree.Kind.LOGICAL_COMPLEMENT, 66));
        operators.put(PrefixExpression.Operator.COMPLEMENT, new Op(Tree.Kind.BITWISE_COMPLEMENT, 67));
        operators.put(PrefixExpression.Operator.DECREMENT, new Op(Tree.Kind.PREFIX_DECREMENT, 3));
        operators.put(PrefixExpression.Operator.INCREMENT, new Op(Tree.Kind.PREFIX_INCREMENT, 2));
        operators.put(PostfixExpression.Operator.DECREMENT, new Op(Tree.Kind.POSTFIX_DECREMENT, 3));
        operators.put(PostfixExpression.Operator.INCREMENT, new Op(Tree.Kind.POSTFIX_INCREMENT, 2));
        operators.put(InfixExpression.Operator.TIMES, new Op(Tree.Kind.MULTIPLY, 8));
        operators.put(InfixExpression.Operator.DIVIDE, new Op(Tree.Kind.DIVIDE, 10));
        operators.put(InfixExpression.Operator.REMAINDER, new Op(Tree.Kind.REMAINDER, 9));
        operators.put(InfixExpression.Operator.PLUS, new Op(Tree.Kind.PLUS, 4));
        operators.put(InfixExpression.Operator.MINUS, new Op(Tree.Kind.MINUS, 5));
        operators.put(InfixExpression.Operator.LEFT_SHIFT, new Op(Tree.Kind.LEFT_SHIFT, 18));
        operators.put(InfixExpression.Operator.RIGHT_SHIFT_SIGNED, new Op(Tree.Kind.RIGHT_SHIFT, 14));
        operators.put(InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED, new Op(Tree.Kind.UNSIGNED_RIGHT_SHIFT, 16));
        operators.put(InfixExpression.Operator.LESS, new Op(Tree.Kind.LESS_THAN, 11));
        operators.put(InfixExpression.Operator.GREATER, new Op(Tree.Kind.GREATER_THAN, 15));
        operators.put(InfixExpression.Operator.LESS_EQUALS, new Op(Tree.Kind.LESS_THAN_OR_EQUAL_TO, 12));
        operators.put(InfixExpression.Operator.GREATER_EQUALS, new Op(Tree.Kind.GREATER_THAN_OR_EQUAL_TO, 13));
        operators.put(InfixExpression.Operator.EQUALS, new Op(Tree.Kind.EQUAL_TO, 20));
        operators.put(InfixExpression.Operator.NOT_EQUALS, new Op(Tree.Kind.NOT_EQUAL_TO, 21));
        operators.put(InfixExpression.Operator.XOR, new Op(Tree.Kind.XOR, 24));
        operators.put(InfixExpression.Operator.OR, new Op(Tree.Kind.OR, 28));
        operators.put(InfixExpression.Operator.AND, new Op(Tree.Kind.AND, 22));
        operators.put(InfixExpression.Operator.CONDITIONAL_OR, new Op(Tree.Kind.CONDITIONAL_OR, 31));
        operators.put(InfixExpression.Operator.CONDITIONAL_AND, new Op(Tree.Kind.CONDITIONAL_AND, 29));
        operators.put(Assignment.Operator.ASSIGN, new Op(Tree.Kind.ASSIGNMENT, 77));
        operators.put(Assignment.Operator.PLUS_ASSIGN, new Op(Tree.Kind.PLUS_ASSIGNMENT, 93));
        operators.put(Assignment.Operator.MINUS_ASSIGN, new Op(Tree.Kind.MINUS_ASSIGNMENT, 94));
        operators.put(Assignment.Operator.TIMES_ASSIGN, new Op(Tree.Kind.MULTIPLY_ASSIGNMENT, 95));
        operators.put(Assignment.Operator.DIVIDE_ASSIGN, new Op(Tree.Kind.DIVIDE_ASSIGNMENT, 96));
        operators.put(Assignment.Operator.BIT_AND_ASSIGN, new Op(Tree.Kind.AND_ASSIGNMENT, 97));
        operators.put(Assignment.Operator.BIT_OR_ASSIGN, new Op(Tree.Kind.OR_ASSIGNMENT, 98));
        operators.put(Assignment.Operator.BIT_XOR_ASSIGN, new Op(Tree.Kind.XOR_ASSIGNMENT, 99));
        operators.put(Assignment.Operator.REMAINDER_ASSIGN, new Op(Tree.Kind.REMAINDER_ASSIGNMENT, 100));
        operators.put(Assignment.Operator.LEFT_SHIFT_ASSIGN, new Op(Tree.Kind.LEFT_SHIFT_ASSIGNMENT, 101));
        operators.put(Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN, new Op(Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, 102));
        operators.put(Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN, new Op(Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, 103));
    }

    private static class Op {
        final Tree.Kind kind;
        final int tokenType;

        Op(Tree.Kind kind, int tokenType) {
            this.kind = kind;
            this.tokenType = tokenType;
        }
    }
}

