/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.scan.issue.filter.IssueFilterChain;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.filters.EclipseI18NFilter;
import org.sonar.java.filters.GeneratedCodeFilter;
import org.sonar.java.filters.GoogleAutoFilter;
import org.sonar.java.filters.JavaIssueFilter;
import org.sonar.java.filters.LombokFilter;
import org.sonar.java.filters.SonarJavaIssueFilter;
import org.sonar.java.filters.SuppressWarningFilter;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;

public class PostAnalysisIssueFilter
implements JavaFileScanner,
SonarJavaIssueFilter {
    private List<JavaIssueFilter> issueFilters;

    @VisibleForTesting
    List<JavaIssueFilter> issueFilters() {
        if (this.issueFilters == null) {
            this.issueFilters = Collections.unmodifiableList(Arrays.asList(new EclipseI18NFilter(), new LombokFilter(), new GoogleAutoFilter(), new SuppressWarningFilter(), new GeneratedCodeFilter()));
        }
        return this.issueFilters;
    }

    public boolean accept(FilterableIssue issue, IssueFilterChain chain) {
        return this.issueFilters().stream().allMatch(filter -> filter.accept(issue)) && chain.accept(issue);
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.issueFilters().forEach(filter -> filter.scanFile(context));
    }
}

