/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.externalreport;

import java.io.File;
import java.util.List;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.externalreport.ExternalIssueUtils;
import org.sonar.java.externalreport.PmdXmlReportReader;
import org.sonarsource.analyzer.commons.ExternalReportProvider;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;

public class PmdSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(PmdSensor.class);
    public static final String REPORT_PROPERTY_KEY = "sonar.java.pmd.reportPaths";
    public static final String LINTER_KEY = "pmd";
    private static final String LINTER_NAME = "PMD";
    private static final String LANGUAGE_KEY = "java";
    public static final ExternalRuleLoader RULE_LOADER = new ExternalRuleLoader("pmd", "PMD", "org/sonar/l10n/java/rules/pmd/rules.json", "java");

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyWhenConfiguration(conf -> conf.hasKey(REPORT_PROPERTY_KEY)).name("Import of PMD issues");
    }

    public void execute(SensorContext context) {
        List<File> reportFiles = ExternalReportProvider.getReportFiles(context, REPORT_PROPERTY_KEY);
        reportFiles.forEach(report -> ExternalIssueUtils.importIfExist(LINTER_NAME, context, report, PmdSensor::importReport));
    }

    private static void importReport(File reportFile, SensorContext context) {
        try {
            LOG.info("Importing {}", (Object)reportFile);
            PmdXmlReportReader.read(context, reportFile, RULE_LOADER);
        }
        catch (Exception e) {
            LOG.error("Failed to import external issues report: " + reportFile.getAbsolutePath(), (Throwable)e);
        }
    }
}

