/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.sonar.java.checks.tests.AssertJChainSimplificationQuickFix;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

class ActualExpectedInSubjectQuickFix
implements AssertJChainSimplificationQuickFix {
    final String replacement;
    final String predicateName;

    ActualExpectedInSubjectQuickFix(String replacement, String predicateName) {
        this.replacement = replacement;
        this.predicateName = predicateName;
    }

    @Override
    public Supplier<List<JavaQuickFix>> apply(MethodInvocationTree subject, MethodInvocationTree predicate) {
        return () -> {
            Optional<MethodInvocationTree> methodInvocationInArguments = ActualExpectedInSubjectQuickFix.getMethodInvocationInArguments(subject.arguments());
            if (methodInvocationInArguments.isPresent()) {
                MethodInvocationTree invocationTree = methodInvocationInArguments.get();
                ExpressionTree methodSelect = invocationTree.methodSelect();
                if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
                    MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)methodSelect;
                    return Collections.singletonList(this.getJavaQuickFix(predicate, memberSelect, invocationTree));
                }
            }
            return Collections.emptyList();
        };
    }

    private static Optional<MethodInvocationTree> getMethodInvocationInArguments(Arguments arguments) {
        if (arguments.size() == 1) {
            ExpressionTree argument = (ExpressionTree)arguments.get(0);
            if (argument.is(Tree.Kind.METHOD_INVOCATION)) {
                return Optional.of((MethodInvocationTree)argument);
            }
        }
        return Optional.empty();
    }

    private JavaQuickFix getJavaQuickFix(MethodInvocationTree predicate, MemberSelectExpressionTree memberSelect, MethodInvocationTree invocationTree) {
        return JavaQuickFix.newQuickFix("Use \"%s\"", this.replacement).addTextEdit(JavaTextEdit.replaceTextSpan(AnalyzerMessage.textSpanBetween(memberSelect.expression(), false, (Tree)invocationTree.arguments().get(0), false), String.format(").%s(", this.predicateName)), JavaTextEdit.removeTextSpan(AnalyzerMessage.textSpanBetween(invocationTree.arguments(), false, predicate, true))).build();
    }
}

