/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.sonar.java.checks.tests.AssertJChainSimplificationQuickFix;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

class ActualExpectedInPredicateQuickFix
implements AssertJChainSimplificationQuickFix {
    private final boolean keepPredicateArgument;
    final String replacement;
    final String predicateName;

    ActualExpectedInPredicateQuickFix(String replacement, String predicateName, boolean keepPredicateArgument) {
        this.replacement = replacement;
        this.predicateName = predicateName;
        this.keepPredicateArgument = keepPredicateArgument;
    }

    @Override
    public Supplier<List<JavaQuickFix>> apply(MethodInvocationTree subject, MethodInvocationTree predicate) {
        return () -> {
            ExpressionTree argument;
            Optional<MemberSelectExpressionTree> memberSelectInSubject;
            Arguments arguments = subject.arguments();
            if (arguments.size() == 1 && (memberSelectInSubject = ActualExpectedInPredicateQuickFix.getMemberSelectInSubject(argument = (ExpressionTree)arguments.get(0))).isPresent()) {
                MemberSelectExpressionTree memberSelect = memberSelectInSubject.get();
                return Collections.singletonList(this.getJavaQuick(predicate, argument, memberSelect));
            }
            return Collections.emptyList();
        };
    }

    private JavaQuickFix getJavaQuick(MethodInvocationTree predicate, ExpressionTree argument, MemberSelectExpressionTree memberSelect) {
        JavaQuickFix.Builder builder = JavaQuickFix.newQuickFix("Use \"%s\"", this.replacement);
        builder.addTextEdit(JavaTextEdit.removeTextSpan(AnalyzerMessage.textSpanBetween(memberSelect.expression(), false, argument, true)));
        if (this.keepPredicateArgument) {
            builder.addTextEdit(JavaTextEdit.replaceTree(ExpressionUtils.methodName(predicate), this.predicateName));
        } else {
            builder.addTextEdit(JavaTextEdit.replaceBetweenTree(ExpressionUtils.methodName(predicate), predicate, this.predicateName + "()"));
        }
        return builder.build();
    }

    private static Optional<MemberSelectExpressionTree> getMemberSelectInSubject(ExpressionTree tree) {
        if (tree.is(Tree.Kind.MEMBER_SELECT)) {
            return Optional.of((MemberSelectExpressionTree)tree);
        }
        if (tree.is(Tree.Kind.METHOD_INVOCATION)) {
            return ActualExpectedInPredicateQuickFix.getMemberSelectInSubject(((MethodInvocationTree)tree).methodSelect());
        }
        return Optional.empty();
    }
}

