/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.List;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AbstractMockitoArgumentChecker
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers METHODS_USING_ARGUMENT_MATCHER_IN_ARGUMENTS = MethodMatchers.or(MethodMatchers.create().ofTypes("org.mockito.Mockito").names("when").addParametersMatcher("*").build(), MethodMatchers.create().ofTypes("org.mockito.BDDMockito").names("given").addParametersMatcher("*").build());
    private static final MethodMatchers METHODS_USING_ARGUMENT_MATCHER_IN_CONSECUTIVE_CALL = MethodMatchers.or(MethodMatchers.create().ofTypes("org.mockito.Mockito").names("verify").withAnyParameters().build(), MethodMatchers.create().ofTypes("org.mockito.InOrder").names("verify").withAnyParameters().build(), MethodMatchers.create().ofTypes("org.mockito.stubbing.Stubber").names("when").withAnyParameters().build());

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodInvocationTree invocation = (MethodInvocationTree)tree;
        if (METHODS_USING_ARGUMENT_MATCHER_IN_ARGUMENTS.matches(invocation)) {
            ExpressionTree argument = (ExpressionTree)invocation.arguments().get(0);
            argument = ExpressionUtils.skipParentheses(argument);
            if (argument.is(Tree.Kind.METHOD_INVOCATION)) {
                this.visitArguments(((MethodInvocationTree)argument).arguments());
            }
        } else if (METHODS_USING_ARGUMENT_MATCHER_IN_CONSECUTIVE_CALL.matches(invocation)) {
            MethodTreeUtils.consecutiveMethodInvocation(invocation).ifPresent(m -> this.visitArguments(m.arguments()));
        }
    }

    protected abstract void visitArguments(Arguments var1);
}

