/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.EndOfAnalysisCheck;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.SetUtils;

@Rule(key="S4605")
public class SpringBeansShouldBeAccessibleCheck
extends IssuableSubscriptionVisitor
implements EndOfAnalysisCheck {
    private static final String MESSAGE_FORMAT = "'%s' is not reachable by @ComponentsScan or @SpringBootApplication. Either move it to a package configured in @ComponentsScan or update your @ComponentsScan configuration.";
    private static final String[] SPRING_BEAN_ANNOTATIONS = new String[]{"org.springframework.stereotype.Component", "org.springframework.stereotype.Service", "org.springframework.stereotype.Repository", "org.springframework.stereotype.Controller", "org.springframework.web.bind.annotation.RestController"};
    private static final String COMPONENT_SCAN_ANNOTATION = "org.springframework.context.annotation.ComponentScan";
    private static final Set<String> COMPONENT_SCAN_ARGUMENTS = SetUtils.immutableSetOf("basePackages", "value");
    private static final String SPRING_BOOT_APP_ANNOTATION = "org.springframework.boot.autoconfigure.SpringBootApplication";
    private final Map<String, List<AnalyzerMessage>> messagesPerPackage = new HashMap<String, List<AnalyzerMessage>>();
    private final Set<String> packagesScannedBySpring = new HashSet<String>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void endOfAnalysis() {
        DefaultJavaFileScannerContext defaultContext = (DefaultJavaFileScannerContext)this.context;
        this.messagesPerPackage.entrySet().stream().filter(entry -> this.packagesScannedBySpring.stream().noneMatch(((String)entry.getKey())::contains)).forEach(entry -> ((List)entry.getValue()).forEach(defaultContext::reportIssue));
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (classTree.simpleName() == null) {
            return;
        }
        String classPackageName = SpringBeansShouldBeAccessibleCheck.packageNameOf(classTree.symbol());
        SymbolMetadata classSymbolMetadata = classTree.symbol().metadata();
        List<SymbolMetadata.AnnotationValue> componentScanValues = classSymbolMetadata.valuesForAnnotation(COMPONENT_SCAN_ANNOTATION);
        if (componentScanValues != null) {
            componentScanValues.forEach(this::addToScannedPackages);
        } else if (SpringBeansShouldBeAccessibleCheck.hasAnnotation(classSymbolMetadata, SPRING_BOOT_APP_ANNOTATION)) {
            this.packagesScannedBySpring.addAll(SpringBeansShouldBeAccessibleCheck.targetedPackages(classPackageName, classSymbolMetadata));
        } else if (SpringBeansShouldBeAccessibleCheck.hasAnnotation(classSymbolMetadata, SPRING_BEAN_ANNOTATIONS)) {
            this.addMessageToMap(classPackageName, classTree.simpleName());
        }
    }

    private static List<String> targetedPackages(String classPackageName, SymbolMetadata classSymbolMetadata) {
        return Objects.requireNonNull(classSymbolMetadata.valuesForAnnotation(SPRING_BOOT_APP_ANNOTATION)).stream().filter(v -> "scanBasePackages".equals(v.name())).map(SymbolMetadata.AnnotationValue::value).findFirst().filter(Object[].class::isInstance).map(Object[].class::cast).map(SpringBeansShouldBeAccessibleCheck::asStringList).orElse(Collections.singletonList(classPackageName));
    }

    private static List<String> asStringList(Object[] array) {
        return Arrays.asList(array).stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toList());
    }

    private void addMessageToMap(String classPackageName, IdentifierTree classNameTree) {
        DefaultJavaFileScannerContext defaultContext = (DefaultJavaFileScannerContext)this.context;
        AnalyzerMessage analyzerMessage = defaultContext.createAnalyzerMessage(this, classNameTree, String.format(MESSAGE_FORMAT, classNameTree.name()));
        this.messagesPerPackage.computeIfAbsent(classPackageName, k -> new ArrayList()).add(analyzerMessage);
    }

    private void addToScannedPackages(SymbolMetadata.AnnotationValue annotationValue) {
        if (!COMPONENT_SCAN_ARGUMENTS.contains(annotationValue.name())) {
            return;
        }
        if (annotationValue.value() instanceof Object[]) {
            for (Object o : (Object[])annotationValue.value()) {
                if (!(o instanceof String)) continue;
                this.packagesScannedBySpring.add((String)o);
            }
        }
    }

    private static String packageNameOf(Symbol symbol) {
        Symbol owner = symbol.owner();
        while (!owner.isPackageSymbol()) {
            owner = owner.owner();
        }
        return owner.name();
    }

    private static boolean hasAnnotation(SymbolMetadata classSymbolMetadata, String ... annotationName) {
        return Arrays.stream(annotationName).anyMatch(classSymbolMetadata::isAnnotatedWith);
    }
}

