/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6209")
public class RecordSerializationIgnoredMembersCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers SERIALIZABLE_MATCHERS = MethodMatchers.or(RecordSerializationIgnoredMembersCheck.methodMatcher("readObjectNoData", new String[0]), RecordSerializationIgnoredMembersCheck.methodMatcher("readObject", "java.io.ObjectInputStream"), RecordSerializationIgnoredMembersCheck.methodMatcher("writeObject", "java.io.ObjectOutputStream"), RecordSerializationIgnoredMembersCheck.methodMatcher("readExternal", "java.io.ObjectInput"), RecordSerializationIgnoredMembersCheck.methodMatcher("writeExternal", "java.io.ObjectOutput"));

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.RECORD);
    }

    @Override
    public void visitNode(Tree tree) {
        for (Tree member : ((ClassTree)tree).members()) {
            if (member.is(Tree.Kind.VARIABLE)) {
                this.checkField((VariableTree)member);
                continue;
            }
            if (!member.is(Tree.Kind.METHOD)) continue;
            this.checkMethod((MethodTree)member);
        }
    }

    private void checkField(VariableTree field) {
        if (RecordSerializationIgnoredMembersCheck.isSerialPersistentFields(field.symbol())) {
            this.reportIssue(field.simpleName(), RecordSerializationIgnoredMembersCheck.issueMessage("field"));
        }
    }

    private static boolean isSerialPersistentFields(Symbol field) {
        return "serialPersistentFields".equals(field.name()) && field.isPrivate() && field.isFinal() && field.type().is("java.io.ObjectStreamField[]");
    }

    private void checkMethod(MethodTree method) {
        Symbol.MethodSymbol methodSymbol = method.symbol();
        if (!SERIALIZABLE_MATCHERS.matches(methodSymbol)) {
            return;
        }
        if (RecordSerializationIgnoredMembersCheck.isFromExternalizable(methodSymbol) || RecordSerializationIgnoredMembersCheck.isFromSerializable(methodSymbol)) {
            this.reportIssue(method.simpleName(), RecordSerializationIgnoredMembersCheck.issueMessage("method"));
        }
    }

    private static boolean isFromSerializable(Symbol.MethodSymbol method) {
        return method.name().contains("Object") && method.isPrivate();
    }

    private static boolean isFromExternalizable(Symbol.MethodSymbol method) {
        return method.name().contains("External") && !method.overriddenSymbols().isEmpty();
    }

    private static String issueMessage(String tree) {
        return String.format("Remove this %s that will be ignored during record serialization.", tree);
    }

    private static MethodMatchers methodMatcher(String methodName, String ... parameterTypes) {
        return MethodMatchers.create().ofAnyType().names(methodName).addParametersMatcher(parameterTypes).build();
    }
}

