/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

@Rule(key="S4426")
public class CryptographicKeySizeCheck
extends AbstractMethodDetection {
    private static final String KEY_PAIR_GENERATOR = "java.security.KeyPairGenerator";
    private static final String KEY_GENERATOR = "javax.crypto.KeyGenerator";
    private static final String EC_GEN_PARAMETER_SPEC = "java.security.spec.ECGenParameterSpec";
    private static final String GET_INSTANCE_METHOD = "getInstance";
    private static final String STRING = "java.lang.String";
    private static final int EC_MIN_KEY = 224;
    private static final Pattern EC_KEY_PATTERN = Pattern.compile("^(secp|prime|sect|c2tnb)(\\d+)");
    private static final Map<String, Integer> ALGORITHM_KEY_SIZE_MAP = MapBuilder.newMap().put("RSA", 2048).put("DH", 2048).put("DIFFIEHELLMAN", 2048).put("DSA", 2048).put("AES", 128).build();
    private static final MethodMatchers KEY_GEN = MethodMatchers.or(MethodMatchers.create().ofTypes("javax.crypto.KeyGenerator").names("init").addParametersMatcher("int").build(), MethodMatchers.create().ofTypes("java.security.KeyPairGenerator").names("initialize").addParametersMatcher("int").addParametersMatcher("int", "java.security.SecureRandom").build());

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or(MethodMatchers.create().ofTypes(KEY_GENERATOR, KEY_PAIR_GENERATOR).names(GET_INSTANCE_METHOD).addParametersMatcher(STRING).build(), MethodMatchers.create().ofTypes(EC_GEN_PARAMETER_SPEC).constructor().addParametersMatcher(STRING).build());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        MethodTree methodTree = ExpressionUtils.getEnclosingMethod(mit);
        String getInstanceArg = ExpressionsHelper.getConstantValueAsString((ExpressionTree)mit.arguments().get(0)).value();
        if (methodTree != null && getInstanceArg != null) {
            Optional<Symbol> assignedSymbol = ExpressionUtils.getAssignedSymbol(mit);
            MethodVisitor methodVisitor = new MethodVisitor(getInstanceArg, assignedSymbol.orElse(null));
            methodTree.accept(methodVisitor);
        }
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        Matcher matcher;
        String firstArgument = ExpressionsHelper.getConstantValueAsString((ExpressionTree)newClassTree.arguments().get(0)).value();
        if (firstArgument != null && (matcher = EC_KEY_PATTERN.matcher(firstArgument)).find() && Integer.valueOf(matcher.group(2)) < 224) {
            this.reportIssue(newClassTree, "Use a key length of at least 224 bits for EC cipher algorithm.");
        }
    }

    private class MethodVisitor
    extends BaseTreeVisitor {
        private final String algorithm;
        private final Integer minKeySize;
        private final Symbol variable;

        public MethodVisitor(@Nullable String getInstanceArg, Symbol variable) {
            this.algorithm = getInstanceArg;
            this.minKeySize = ALGORITHM_KEY_SIZE_MAP.get(this.algorithm.toUpperCase(Locale.ENGLISH));
            this.variable = variable;
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree mit) {
            Integer keySize;
            if (this.minKeySize != null && KEY_GEN.matches(mit) && (keySize = LiteralUtils.intLiteralValue((ExpressionTree)mit.arguments().get(0))) != null && keySize < this.minKeySize && ExpressionUtils.isInvocationOnVariable(mit, this.variable, false)) {
                CryptographicKeySizeCheck.this.reportIssue(mit, "Use a key length of at least " + this.minKeySize + " bits for " + this.algorithm + " cipher algorithm.");
            }
        }
    }
}

