/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6291")
public class AndroidUnencryptedDatabaseCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String ANDROID_CONTENT_CONTEXT = "android.content.Context";
    private static final String REALM_CONFIGURATION_BUILDER_TYPE = "io.realm.RealmConfiguration$Builder";
    private static final MethodMatchers UNSAFE_DATABASE_CALL = MethodMatchers.or(MethodMatchers.create().ofSubTypes("android.app.Activity").names("getPreferences").addParametersMatcher("int").build(), MethodMatchers.create().ofSubTypes("android.preference.PreferenceManager").names("getDefaultSharedPreferences").addParametersMatcher("android.content.Context").build(), MethodMatchers.create().ofSubTypes("android.content.Context").names("getSharedPreferences").addParametersMatcher("java.lang.String", "int").addParametersMatcher("java.io.File", "int").build(), MethodMatchers.create().ofSubTypes("android.content.Context").names("openOrCreateDatabase").addParametersMatcher("java.lang.String", "int", "android.database.sqlite.SQLiteDatabase$CursorFactory").addParametersMatcher("java.lang.String", "int", "android.database.sqlite.SQLiteDatabase$CursorFactory", "android.database.DatabaseErrorHandler").build());
    private static final MethodMatchers REALM_CONFIGURATION_BUILDER_BUILD = MethodMatchers.create().ofSubTypes("io.realm.RealmConfiguration$Builder").names("build").addWithoutParametersMatcher().build();
    private static final MethodMatchers REALM_CONFIGURATION_BUILDER_ENCRYPTION_KEY = MethodMatchers.create().ofSubTypes("io.realm.RealmConfiguration$Builder").names("encryptionKey").withAnyParameters().build();
    private static final MethodMatchers REALM_CONFIGURATION_BUILDER_BUILDER = MethodMatchers.create().ofSubTypes("io.realm.RealmConfiguration$Builder").constructor().withAnyParameters().build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        if (UNSAFE_DATABASE_CALL.matches(mit) || REALM_CONFIGURATION_BUILDER_BUILD.matches(mit) && !AndroidUnencryptedDatabaseCheck.isEncrypted(mit.methodSelect())) {
            this.reportIssue(ExpressionUtils.methodName(mit), "Make sure using an unencrypted database is safe here.");
        }
    }

    private static boolean isEncrypted(ExpressionTree expression) {
        if (expression.is(Tree.Kind.MEMBER_SELECT)) {
            expression = ((MemberSelectExpressionTree)expression).expression();
        }
        if (expression.is(Tree.Kind.METHOD_INVOCATION)) {
            MethodInvocationTree mit = (MethodInvocationTree)expression;
            if (!REALM_CONFIGURATION_BUILDER_ENCRYPTION_KEY.matches(mit)) {
                return AndroidUnencryptedDatabaseCheck.isEncrypted(mit.methodSelect());
            }
        } else {
            NewClassTree newClassTree;
            if (expression.is(Tree.Kind.IDENTIFIER)) {
                Symbol symbol = ((IdentifierTree)expression).symbol();
                if (symbol.usages().stream().anyMatch(AndroidUnencryptedDatabaseCheck::canEncryptToken)) {
                    return true;
                }
                return AndroidUnencryptedDatabaseCheck.declarationIsEncrypted(symbol);
            }
            if (expression.is(Tree.Kind.NEW_CLASS) && REALM_CONFIGURATION_BUILDER_BUILDER.matches(newClassTree = (NewClassTree)expression)) {
                return false;
            }
        }
        return true;
    }

    private static boolean canEncryptToken(IdentifierTree tokenIdentifier) {
        Tree parent = tokenIdentifier.parent();
        return parent != null && parent.is(Tree.Kind.ARGUMENTS) || MethodTreeUtils.subsequentMethodInvocation(tokenIdentifier, REALM_CONFIGURATION_BUILDER_ENCRYPTION_KEY).isPresent();
    }

    private static boolean declarationIsEncrypted(Symbol symbol) {
        Tree declaration;
        if (JUtils.isLocalVariable(symbol) && (declaration = symbol.declaration()) instanceof VariableTree) {
            ExpressionTree initializer = ((VariableTree)declaration).initializer();
            return initializer instanceof MethodInvocationTree && AndroidUnencryptedDatabaseCheck.isEncrypted(initializer);
        }
        return true;
    }
}

