/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6301")
public class AndroidMobileDatabaseEncryptionKeysCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final MethodMatchers SQLITE_DATABASE_CONSTRUCTOR = MethodMatchers.create().ofTypes("net.sqlcipher.database.SQLiteDatabase").constructor().addParametersMatcher(args -> !args.isEmpty()).build();
    private static final MethodMatchers SQLITE_DATABASE_METHODS = MethodMatchers.create().ofTypes("net.sqlcipher.database.SQLiteDatabase").names("changePassword", "openDatabase", "openOrCreateDatabase", "create").addParametersMatcher(args -> !args.isEmpty()).build();
    private static final MethodMatchers REALM_CONFIGURATION_BUILDER_ENCRYPTION_KEY = MethodMatchers.create().ofTypes("io.realm.RealmConfiguration$Builder").names("encryptionKey").addParametersMatcher("byte[]").build();
    private static final MethodMatchers JAVA_LANG_STRING_TO_CHAR_GET_BYTES = MethodMatchers.or(MethodMatchers.create().ofTypes("java.lang.String").names("toCharArray").addWithoutParametersMatcher().build(), MethodMatchers.create().ofTypes("java.lang.String").names("getBytes").addParametersMatcher("*").build());

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.NEW_CLASS)) {
            NewClassTree newClassTree = (NewClassTree)tree;
            if (SQLITE_DATABASE_CONSTRUCTOR.matches(newClassTree)) {
                this.reportIssueIfHardCoded((ExpressionTree)newClassTree.arguments().get(1), "password");
            }
        } else {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            if (REALM_CONFIGURATION_BUILDER_ENCRYPTION_KEY.matches(mit)) {
                this.reportIssueIfHardCoded(mit, "encryptionKey");
            } else if (SQLITE_DATABASE_METHODS.matches(mit)) {
                this.reportIssueIfHardCoded(mit, "password");
            }
        }
    }

    private void reportIssueIfHardCoded(MethodInvocationTree mit, String argName) {
        Arguments arguments = mit.arguments();
        ExpressionTree passwordArg = arguments.size() == 1 ? (ExpressionTree)arguments.get(0) : (ExpressionTree)arguments.get(1);
        this.reportIssueIfHardCoded(passwordArg, argName);
    }

    private void reportIssueIfHardCoded(ExpressionTree expressionTree, String messageArg) {
        ExpressionTree stringExpression = expressionTree;
        if (!expressionTree.symbolType().is(JAVA_LANG_STRING) && (stringExpression = AndroidMobileDatabaseEncryptionKeysCheck.tryGetOriginStringFromByteOrCharArray(expressionTree)) == null) {
            return;
        }
        ExpressionsHelper.ValueResolution<String> constantValueAsString = ExpressionsHelper.getConstantValueAsString(stringExpression);
        if (constantValueAsString.value() != null) {
            this.reportIssue(expressionTree, "The \"" + messageArg + "\" parameter should not be hardcoded.", constantValueAsString.valuePath(), null);
        }
    }

    @CheckForNull
    private static ExpressionTree tryGetOriginStringFromByteOrCharArray(ExpressionTree givenExpression) {
        MethodInvocationTree mit;
        IdentifierTree identifier;
        ExpressionTree singleWriteUsage;
        ExpressionTree expression = givenExpression;
        if (expression.is(Tree.Kind.IDENTIFIER) && (singleWriteUsage = ExpressionsHelper.getSingleWriteUsage((identifier = (IdentifierTree)expression).symbol())) != null) {
            expression = singleWriteUsage;
        }
        if (expression.is(Tree.Kind.METHOD_INVOCATION) && JAVA_LANG_STRING_TO_CHAR_GET_BYTES.matches(mit = (MethodInvocationTree)expression)) {
            return ((MemberSelectExpressionTree)mit.methodSelect()).expression();
        }
        return null;
    }
}

