/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;

@Rule(key="S6293")
public class AndroidBiometricAuthWithoutCryptoCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or(MethodMatchers.create().ofTypes("android.hardware.biometrics.BiometricPrompt").names("authenticate").addParametersMatcher("android.os.CancellationSignal", "java.util.concurrent.Executor", "android.hardware.biometrics.BiometricPrompt$AuthenticationCallback").build(), MethodMatchers.create().ofTypes("androidx.biometric.BiometricPrompt").names("authenticate").addParametersMatcher("androidx.biometric.BiometricPrompt$PromptInfo").build());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue(ExpressionUtils.methodName(mit), "Make sure performing a biometric authentication without a \"CryptoObject\" is safe here.");
    }
}

