/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.regex.RegexCheck;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;
import org.sonarsource.analyzer.commons.collections.SetUtils;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.CharacterRangeTree;
import org.sonarsource.analyzer.commons.regex.ast.EscapedCharacterClassTree;
import org.sonarsource.analyzer.commons.regex.ast.NonCapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;

@Rule(key="S5867")
public class UnicodeAwareCharClassesCheck
extends AbstractRegexCheck {
    private static final List<Character> unicodeAwareClassesWithFlag = Arrays.asList(Character.valueOf('s'), Character.valueOf('S'), Character.valueOf('w'), Character.valueOf('W'));
    private static final Set<String> unicodeAwarePropertiesWithFlag = SetUtils.immutableSetOf("Lower", "Upper", "Alpha", "Alnum", "Punct", "Graph", "Print", "Blank", "Space");
    private static final Map<Character, Character> unicodeUnawareCharacterRanges = MapBuilder.newMap().put(Character.valueOf('a'), Character.valueOf('z')).put(Character.valueOf('A'), Character.valueOf('Z')).build();

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation) {
        new UnicodeUnawareCharClassFinder(methodInvocationOrAnnotation).visit(regexForLiterals);
    }

    private class UnicodeUnawareCharClassFinder
    extends RegexBaseVisitor {
        private final ExpressionTree methodInvocationOrAnnotation;
        private final List<CharacterRangeTree> unicodeUnawareRanges = new ArrayList<CharacterRangeTree>();
        private final List<RegexTree> unicodeAwareWithFlag = new ArrayList<RegexTree>();
        private boolean containsUnicodeCharacterFlag = false;

        public UnicodeUnawareCharClassFinder(ExpressionTree methodInvocationOrAnnotation) {
            this.methodInvocationOrAnnotation = methodInvocationOrAnnotation;
        }

        @Override
        protected void before(RegexParseResult regexParseResult) {
            this.containsUnicodeCharacterFlag |= regexParseResult.getInitialFlags().contains(256);
        }

        @Override
        protected void after(RegexParseResult regexParseResult) {
            List<RegexCheck.RegexIssueLocation> secondaries;
            int unicodeUnawareRangeSize = this.unicodeUnawareRanges.size();
            if (unicodeUnawareRangeSize == 1) {
                UnicodeAwareCharClassesCheck.this.reportIssue(this.unicodeUnawareRanges.get(0), "Replace this character range with a Unicode-aware character class.", null, Collections.emptyList());
            } else if (unicodeUnawareRangeSize > 1) {
                secondaries = this.unicodeUnawareRanges.stream().map(tree -> new RegexCheck.RegexIssueLocation((RegexSyntaxElement)tree, "Character range")).collect(Collectors.toList());
                UnicodeAwareCharClassesCheck.this.reportIssue(regexParseResult.getResult(), "Replace these character ranges with Unicode-aware character classes.", null, secondaries);
            }
            if (!this.unicodeAwareWithFlag.isEmpty() && !this.containsUnicodeCharacterFlag) {
                secondaries = this.unicodeAwareWithFlag.stream().map(tree -> new RegexCheck.RegexIssueLocation((RegexSyntaxElement)tree, "Predefined/POSIX character class")).collect(Collectors.toList());
                String flagName = this.methodInvocationOrAnnotation.is(Tree.Kind.ANNOTATION) ? "(?U)" : "UNICODE_CHARACTER_CLASS";
                UnicodeAwareCharClassesCheck.this.reportIssue(UnicodeAwareCharClassesCheck.this.methodOrAnnotationName(this.methodInvocationOrAnnotation), "Enable the \"" + flagName + "\" flag or use a Unicode-aware alternative.", null, secondaries);
            }
        }

        @Override
        public void visitCharacterRange(CharacterRangeTree tree) {
            Character expectedUpperBoundChar;
            int lowerBound = tree.getLowerBound().codePointOrUnit();
            if (lowerBound < 65535 && (expectedUpperBoundChar = unicodeUnawareCharacterRanges.get(Character.valueOf((char)lowerBound))) != null && expectedUpperBoundChar.charValue() == tree.getUpperBound().codePointOrUnit()) {
                this.unicodeUnawareRanges.add(tree);
            }
        }

        @Override
        public void visitEscapedCharacterClass(EscapedCharacterClassTree tree) {
            String property = tree.property();
            if (property != null && unicodeAwarePropertiesWithFlag.contains(property) || unicodeAwareClassesWithFlag.contains(Character.valueOf(tree.getType()))) {
                this.unicodeAwareWithFlag.add(tree);
            }
        }

        @Override
        public void visitNonCapturingGroup(NonCapturingGroupTree tree) {
            this.containsUnicodeCharacterFlag |= tree.activeFlags().contains(256);
            super.visitNonCapturingGroup(tree);
        }
    }
}

