/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1191")
public class SunPackagesUsedCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private List<Tree> reportedTrees = new ArrayList<Tree>();
    private static final String DEFAULT_EXCLUDE = "com.sun.jersey,com.sun.faces";
    @RuleProperty(key="Exclude", description="Comma separated list of Sun packages to be ignored by this rule. Example: com.sun.jna,sun.misc", defaultValue="com.sun.jersey,com.sun.faces")
    public String exclude = "com.sun.jersey,com.sun.faces";
    private String[] excludePackages = null;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.reportedTrees.clear();
        this.excludePackages = this.exclude.split(",");
        this.scan(context.getTree());
        if (!this.reportedTrees.isEmpty()) {
            this.reportIssueWithSecondaries(context);
        }
    }

    private void reportIssueWithSecondaries(JavaFileScannerContext context) {
        List<JavaFileScannerContext.Location> secondaries = this.reportedTrees.stream().skip(1L).map(tree -> new JavaFileScannerContext.Location("Replace also this \"Sun\" reference.", (Tree)tree)).collect(Collectors.toList());
        int effortToFix = this.reportedTrees.size();
        context.reportIssue(this, this.reportedTrees.get(0), "Use classes from the Java API instead of Sun classes.", secondaries, effortToFix);
    }

    @Override
    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        String reference = ExpressionsHelper.concatenate(tree);
        if (!this.isExcluded(reference) && SunPackagesUsedCheck.isSunClass(reference)) {
            this.reportedTrees.add(tree);
        }
    }

    private static boolean isSunClass(String reference) {
        return reference.startsWith("com.sun.") || reference.startsWith("sun.");
    }

    private boolean isExcluded(String reference) {
        for (String str : this.excludePackages) {
            if (str.isEmpty() || !reference.startsWith(str)) continue;
            return true;
        }
        return false;
    }
}

