/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S1858")
public class StringToStringCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes("java.lang.String").names("toString").addWithoutParametersMatcher().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree tree) {
        ExpressionTree expressionRaw = ((MemberSelectExpressionTree)tree.methodSelect()).expression();
        ExpressionTree expressionTree = StringToStringCheck.extractBaseExpression(expressionRaw);
        ExpressionTree reportTree = null;
        Object message = null;
        if (expressionTree.is(Tree.Kind.IDENTIFIER)) {
            reportTree = expressionTree;
            message = String.format("\"%s\" is already a string, there's no need to call \"toString()\" on it.", ((IdentifierTree)expressionTree).identifierToken().text());
        } else if (expressionTree.is(Tree.Kind.STRING_LITERAL)) {
            reportTree = expressionTree;
            message = "there's no need to call \"toString()\" on a string literal.";
        } else if (expressionTree.is(Tree.Kind.TEXT_BLOCK)) {
            reportTree = expressionTree;
            message = "there's no need to call \"toString()\" on a text block.";
        } else if (expressionTree.is(Tree.Kind.METHOD_INVOCATION)) {
            IdentifierTree methodName = ExpressionUtils.methodName((MethodInvocationTree)expressionTree);
            reportTree = methodName;
            message = "\"" + methodName + "\" returns a string, there's no need to call \"toString()\".";
        } else if (expressionTree.is(Tree.Kind.ARRAY_ACCESS_EXPRESSION)) {
            ArrayAccessExpressionTree arrayAccess = (ArrayAccessExpressionTree)expressionTree;
            IdentifierTree name = StringToStringCheck.extractName(arrayAccess.expression());
            if (name == null) {
                reportTree = arrayAccess.expression();
                message = "There's no need to call \"toString()\" on an array of String.";
            } else {
                reportTree = name;
                message = String.format("\"%s\" is an array of strings, there's no need to call \"toString()\".", name.identifierToken().text());
            }
        }
        this.reportIssue((Tree)reportTree, (String)message, tree, expressionRaw);
    }

    private void reportIssue(@Nullable Tree reportTree, @Nullable String message, MethodInvocationTree toStringInvocation, ExpressionTree baseExpression) {
        if (reportTree != null) {
            Objects.requireNonNull(message, "Message should always be set with a report tree.");
            ((InternalJavaIssueBuilder)QuickFixHelper.newIssue(this.context).forRule(this).onTree(reportTree).withMessage(message).withQuickFix(() -> JavaQuickFix.newQuickFix("Remove \"toString()\"").addTextEdit(JavaTextEdit.removeTextSpan(AnalyzerMessage.textSpanBetween(baseExpression, false, toStringInvocation, true))).build())).report();
        }
    }

    private static ExpressionTree extractBaseExpression(ExpressionTree tree) {
        ExpressionTree expressionTree = tree;
        while (true) {
            if (expressionTree.is(Tree.Kind.MEMBER_SELECT)) {
                expressionTree = ((MemberSelectExpressionTree)expressionTree).identifier();
                continue;
            }
            if (expressionTree.is(Tree.Kind.PARENTHESIZED_EXPRESSION)) {
                expressionTree = ((ParenthesizedTree)expressionTree).expression();
                continue;
            }
            if (!expressionTree.is(Tree.Kind.TYPE_CAST)) break;
            expressionTree = ((TypeCastTree)expressionTree).expression();
        }
        return expressionTree;
    }

    private static IdentifierTree extractName(ExpressionTree tree) {
        ExpressionTree expressionTree = StringToStringCheck.extractBaseExpression(tree);
        if (expressionTree.is(Tree.Kind.IDENTIFIER)) {
            return (IdentifierTree)expressionTree;
        }
        return null;
    }
}

