/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4635")
public class StringOffsetMethodsCheck
extends AbstractMethodDetection {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String INT = "int";
    private static final MethodMatchers SUBSTRING = MethodMatchers.create().ofTypes("java.lang.String").names("substring").addParametersMatcher("int").build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or(MethodMatchers.create().ofTypes(JAVA_LANG_STRING).names("indexOf", "lastIndexOf").addParametersMatcher(INT).build(), MethodMatchers.create().ofTypes(JAVA_LANG_STRING).names("indexOf", "lastIndexOf", "startsWith").addParametersMatcher(JAVA_LANG_STRING).build());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree expression;
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(Tree.Kind.MEMBER_SELECT) && (expression = ((MemberSelectExpressionTree)methodSelect).expression()).is(Tree.Kind.METHOD_INVOCATION) && SUBSTRING.matches(((MethodInvocationTree)expression).symbol())) {
            this.reportIssue(ExpressionUtils.methodName((MethodInvocationTree)expression), mit, String.format("Replace \"%s\" with the overload that accepts an offset parameter.", mit.symbol().name()));
        }
    }
}

