/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1711")
public class StandardFunctionalInterfaceCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers OBJECT_METHODS = MethodMatchers.or(MethodMatchers.create().ofAnyType().names("equals").addParametersMatcher("java.lang.Object").build(), MethodMatchers.create().ofAnyType().names("getClass", "hashcode", "notify", "notifyAll", "toString").addWithoutParametersMatcher().build(), MethodMatchers.create().ofAnyType().names("wait").addWithoutParametersMatcher().addParametersMatcher("long").addParametersMatcher("long", "int").build());
    private static final Set<String> STD_INTERFACE_NAMES = new HashSet<String>();
    private static final Map<Integer, List<FunctionalInterface>> STD_INTERFACE_BY_PARAMETER_COUNT = new HashMap<Integer, List<FunctionalInterface>>();

    private static void registerInterface(String name, String returnType, String ... parameters) {
        FunctionalInterface functionalInterface = new FunctionalInterface(name, returnType, parameters);
        STD_INTERFACE_NAMES.add(functionalInterface.getName());
        STD_INTERFACE_BY_PARAMETER_COUNT.computeIfAbsent(functionalInterface.getParameterCount(), key -> new ArrayList()).add(functionalInterface);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.INTERFACE);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        IdentifierTree issueLocation = classTree.simpleName();
        Optional.of(classTree).filter(StandardFunctionalInterfaceCheck::isFunctionalInterface).filter(StandardFunctionalInterfaceCheck::isNonStandardFunctionalInterface).filter(StandardFunctionalInterfaceCheck::hasNoExtension).flatMap(StandardFunctionalInterfaceCheck::lookupFunctionalMethod).flatMap(StandardFunctionalInterfaceCheck::lookupMatchingStandardInterface).ifPresent(standardInterface -> this.reportIssue(issueLocation, StandardFunctionalInterfaceCheck.buildIssueMessage(classTree, standardInterface)));
    }

    private static boolean isFunctionalInterface(ClassTree tree) {
        return tree.symbol().metadata().isAnnotatedWith("java.lang.FunctionalInterface");
    }

    private static boolean isNonStandardFunctionalInterface(ClassTree tree) {
        return !STD_INTERFACE_NAMES.contains(tree.symbol().type().fullyQualifiedName());
    }

    private static boolean hasNoExtension(ClassTree tree) {
        return tree.superInterfaces().isEmpty();
    }

    private static Optional<Symbol.MethodSymbol> lookupFunctionalMethod(ClassTree interfaceTree) {
        return interfaceTree.symbol().memberSymbols().stream().filter(Symbol::isMethodSymbol).map(Symbol.MethodSymbol.class::cast).filter(Symbol::isAbstract).filter(StandardFunctionalInterfaceCheck::isNotObjectMethod).findFirst();
    }

    private static Optional<String> lookupMatchingStandardInterface(Symbol.MethodSymbol functionalMethod) {
        MethodTree declaration = functionalMethod.declaration();
        if (!functionalMethod.thrownTypes().isEmpty() || declaration != null && !declaration.typeParameters().isEmpty()) {
            return Optional.empty();
        }
        Type returnType = declaration != null ? declaration.returnType().symbolType() : functionalMethod.returnType().type();
        return STD_INTERFACE_BY_PARAMETER_COUNT.getOrDefault(functionalMethod.parameterTypes().size(), Collections.emptyList()).stream().map(standardInterface -> standardInterface.matchingSpecialization(functionalMethod, returnType)).filter(Objects::nonNull).findFirst();
    }

    private static String buildIssueMessage(ClassTree interfaceTree, String standardInterface) {
        if (interfaceTree.members().size() <= 1) {
            return "Drop this interface in favor of \"" + standardInterface + "\".";
        }
        return "Make this interface extend \"" + standardInterface + "\" and remove the functional method declaration.";
    }

    private static boolean isNotObjectMethod(Symbol.MethodSymbol method) {
        MethodTree declaration = method.declaration();
        return declaration == null || !OBJECT_METHODS.matches(declaration);
    }

    static {
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.BiConsumer<T,U>", "void", "T", "U");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.BiFunction<T,U,R>", "R", "T", "U");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.BinaryOperator<T>", "T", "T", "T");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.BiPredicate<T,U>", "boolean", "T", "U");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.BooleanSupplier", "boolean", new String[0]);
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.Consumer<T>", "void", "T");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.DoubleBinaryOperator", "double", "double", "double");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.DoubleConsumer", "void", "double");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.DoubleFunction<R>", "R", "double");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.DoublePredicate", "boolean", "double");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.DoubleSupplier", "double", new String[0]);
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.DoubleToIntFunction", "int", "double");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.DoubleToLongFunction", "long", "double");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.DoubleUnaryOperator", "double", "double");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.Function<T,R>", "R", "T");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.IntBinaryOperator", "int", "int", "int");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.IntConsumer", "void", "int");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.IntFunction<R>", "R", "int");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.IntPredicate", "boolean", "int");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.IntSupplier", "int", new String[0]);
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.IntToDoubleFunction", "double", "int");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.IntToLongFunction", "long", "int");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.IntUnaryOperator", "int", "int");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.LongBinaryOperator", "long", "long", "long");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.LongConsumer", "void", "long");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.LongFunction<R>", "R", "long");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.LongPredicate", "boolean", "long");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.LongSupplier", "long", new String[0]);
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.LongToDoubleFunction", "double", "long");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.LongToIntFunction", "int", "long");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.LongUnaryOperator", "long", "long");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.ObjDoubleConsumer<T>", "void", "T", "double");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.ObjIntConsumer<T>", "void", "T", "int");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.ObjLongConsumer<T>", "void", "T", "long");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.Predicate<T>", "boolean", "T");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.Supplier<T>", "T", new String[0]);
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.ToDoubleBiFunction<T,U>", "double", "T", "U");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.ToDoubleFunction<T>", "double", "T");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.ToIntBiFunction<T,U>", "int", "T", "U");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.ToIntFunction<T>", "int", "T");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.ToLongBiFunction<T,U>", "long", "T", "U");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.ToLongFunction<T>", "long", "T");
        StandardFunctionalInterfaceCheck.registerInterface("java.util.function.UnaryOperator<T>", "T", "T");
        STD_INTERFACE_BY_PARAMETER_COUNT.values().forEach(list -> list.sort((a, b) -> Integer.compare(a.getGenericTypeCount(), b.getGenericTypeCount())));
    }

    private static class FunctionalInterface {
        private final String name;
        private final List<String> genericTypes;
        private final String returnType;
        private final List<String> parameters;

        private FunctionalInterface(String name, String returnType, String ... parameters) {
            int genericStart = name.indexOf(60);
            if (genericStart != -1) {
                this.name = name.substring(0, genericStart);
                this.genericTypes = Arrays.asList(name.substring(genericStart + 1, name.length() - 1).split(","));
            } else {
                this.name = name;
                this.genericTypes = Collections.emptyList();
            }
            this.returnType = returnType;
            this.parameters = Arrays.asList(parameters);
        }

        private String getName() {
            return this.name;
        }

        private int getGenericTypeCount() {
            return this.genericTypes.size();
        }

        private int getParameterCount() {
            return this.parameters.size();
        }

        @CheckForNull
        private String matchingSpecialization(Symbol.MethodSymbol method, Type actualReturnType) {
            HashMap<String, String> genericTypeMapping = this.genericTypes.isEmpty() ? Collections.emptyMap() : new HashMap<String, String>();
            String expectedReturnType = this.convertGenericType(this.returnType, actualReturnType, genericTypeMapping);
            if (!expectedReturnType.equals(actualReturnType.fullyQualifiedName())) {
                return null;
            }
            List<Type> methodParameters = method.parameterTypes();
            for (int i = 0; i < this.parameters.size(); ++i) {
                Type actualType = methodParameters.get(i);
                String expectedType = this.convertGenericType(this.parameters.get(i), actualType, genericTypeMapping);
                if (expectedType.equals(actualType.fullyQualifiedName())) continue;
                return null;
            }
            return this.buildSpecializationName(genericTypeMapping);
        }

        private String convertGenericType(String expectedType, Type actualType, Map<String, String> genericTypeMapping) {
            if (this.genericTypes.isEmpty() || !this.genericTypes.contains(expectedType)) {
                return expectedType;
            }
            String convertedType = genericTypeMapping.get(expectedType);
            if (convertedType == null) {
                if (actualType.isPrimitive() || actualType.isVoid() || actualType.isArray() || actualType.isUnknown()) {
                    return "!unknown!";
                }
                convertedType = actualType.fullyQualifiedName();
                genericTypeMapping.put(expectedType, convertedType);
            }
            return convertedType;
        }

        private String buildSpecializationName(Map<String, String> genericTypeMapping) {
            if (this.genericTypes.isEmpty()) {
                return this.name;
            }
            StringBuilder genericName = new StringBuilder();
            genericName.append(this.name);
            genericName.append('<');
            boolean addComma = false;
            for (String genericType : this.genericTypes) {
                if (addComma) {
                    genericName.append(',');
                } else {
                    addComma = true;
                }
                String typeName = genericTypeMapping.getOrDefault(genericType, genericType);
                int packageEnd = typeName.lastIndexOf(46);
                if (packageEnd != -1) {
                    typeName = typeName.substring(packageEnd + 1);
                }
                genericName.append(typeName);
            }
            genericName.append('>');
            return genericName.toString();
        }
    }
}

