/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.ListUtils;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

@Rule(key="S4719")
public class StandardCharsetsConstantsCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final String INT = "int";
    private static final String BOOLEAN = "boolean";
    private static final String BYTE_ARRAY = "byte[]";
    private static final String TO_STRING = "toString";
    private static final String WRITE = "write";
    private static final String JAVA_IO_FILE = "java.io.File";
    private static final String JAVA_IO_INPUTSTREAM = "java.io.InputStream";
    private static final String JAVA_IO_OUTPUTSTREAM = "java.io.OutputStream";
    private static final String JAVA_IO_OUTPUTSTREAMWRITER = "java.io.OutputStreamWriter";
    private static final String JAVA_IO_INPUTSTREAMREADER = "java.io.InputStreamReader";
    private static final String JAVA_IO_BYTEARRAYOUTPUTSTREAM = "java.io.ByteArrayOutputStream";
    private static final String JAVA_IO_WRITER = "java.io.Writer";
    private static final String JAVA_IO_READER = "java.io.Reader";
    private static final String JAVA_NIO_CHARSET = "java.nio.charset.Charset";
    private static final String JAVA_NIO_FILE_PATH = "java.nio.file.Path";
    private static final String JAVA_NIO_CHANNELS_READABLEBYTECHANNEL = "java.nio.channels.ReadableByteChannel";
    private static final String JAVA_NET_URI = "java.net.URI";
    private static final String JAVA_NET_URL = "java.net.URL";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_LANG_STRINGBUFFER = "java.lang.StringBuffer";
    private static final String JAVA_LANG_CHARSEQUENCE = "java.lang.CharSequence";
    private static final String JAVA_UTIL_COLLECTION = "java.util.Collection";
    private static final String JAVA_UTIL_SCANNER = "java.util.Scanner";
    private static final String COMMONS_CODEC_CHARSETS = "org.apache.commons.codec.Charsets";
    private static final String COMMONS_CODEC_HEX = "org.apache.commons.codec.binary.Hex";
    private static final String COMMONS_CODEC_QUOTEDPRINTABLECODEC = "org.apache.commons.codec.net.QuotedPrintableCodec";
    private static final String COMMONS_IO = "org.apache.commons.io";
    private static final String COMMONS_IO_CHARSETS = "org.apache.commons.io.Charsets";
    private static final String COMMONS_IO_FILEUTILS = "org.apache.commons.io.FileUtils";
    private static final String COMMONS_IO_IOUTILS = "org.apache.commons.io.IOUtils";
    private static final String COMMONS_IO_CHARSEQUENCEINPUTSTREAM = "org.apache.commons.io.input.CharSequenceInputStream";
    private static final String COMMONS_IO_READERINPUTSTREAM = "org.apache.commons.io.input.ReaderInputStream";
    private static final String COMMONS_IO_REVERSEDLINESFILEREADER = "org.apache.commons.io.input.ReversedLinesFileReader";
    private static final String COMMONS_IO_LOCKABLEFILEWRITER = "org.apache.commons.io.output.LockableFileWriter";
    private static final String COMMONS_IO_WRITEROUTPUTSTREAM = "org.apache.commons.io.output.WriterOutputStream";
    private static final List<Charset> STANDARD_CHARSETS = Arrays.asList(StandardCharsets.ISO_8859_1, StandardCharsets.US_ASCII, StandardCharsets.UTF_16, StandardCharsets.UTF_16BE, StandardCharsets.UTF_16LE, StandardCharsets.UTF_8);
    private static final Map<String, String> ALIAS_TO_CONSTANT = StandardCharsetsConstantsCheck.createAliasToConstantNameMap();
    private static final int JAVA_10 = 10;
    private static final MethodMatchers JAVA10_METHOD_MATCHERS = MethodMatchers.or(MethodMatchers.create().ofTypes("java.io.ByteArrayOutputStream").names("toString").addParametersMatcher("java.lang.String").build(), MethodMatchers.create().ofTypes("java.util.Scanner").constructor().addParametersMatcher("java.io.InputStream", "java.lang.String").addParametersMatcher("java.io.File", "java.lang.String").addParametersMatcher("java.nio.file.Path", "java.lang.String").addParametersMatcher("java.nio.channels.ReadableByteChannel", "java.lang.String").build());
    private static final MethodMatchers JAVA8_METHOD_MATCHERS = MethodMatchers.or(MethodMatchers.create().ofTypes("java.nio.charset.Charset").names("forName").addParametersMatcher("java.lang.String").build(), MethodMatchers.create().ofTypes("java.lang.String").names("getBytes").addParametersMatcher("java.lang.String").addParametersMatcher("java.nio.charset.Charset").build(), MethodMatchers.create().ofTypes("org.apache.commons.codec.Charsets", "org.apache.commons.io.Charsets").names("toCharset").addParametersMatcher("java.lang.String").build(), MethodMatchers.create().ofTypes("org.apache.commons.io.FileUtils").names("readFileToString", "readLines").addParametersMatcher("java.io.File", "java.lang.String").build(), MethodMatchers.create().ofTypes("org.apache.commons.io.FileUtils").names("write").addParametersMatcher("java.io.File", "java.lang.CharSequence", "java.lang.String").addParametersMatcher("java.io.File", "java.lang.CharSequence", "java.lang.String", "boolean").build(), MethodMatchers.create().ofTypes("org.apache.commons.io.FileUtils").names("writeStringToFile").addParametersMatcher("java.io.File", "java.lang.String", "java.lang.String").addParametersMatcher("java.io.File", "java.lang.String", "java.lang.String", "boolean").build(), MethodMatchers.create().ofTypes("org.apache.commons.io.IOUtils").names("copy").addParametersMatcher("java.io.InputStream", "java.io.Writer", "java.lang.String").addParametersMatcher("java.io.Reader", "java.io.OutputStream", "java.lang.String").build(), MethodMatchers.create().ofTypes("org.apache.commons.io.IOUtils").names("lineIterator").addParametersMatcher("java.io.InputStream", "java.lang.String").build(), MethodMatchers.create().ofTypes("org.apache.commons.io.IOUtils").names("readLines").addParametersMatcher("java.io.InputStream", "java.lang.String").build(), MethodMatchers.create().ofTypes("org.apache.commons.io.IOUtils").names("toByteArray").addParametersMatcher("java.io.Reader", "java.lang.String").build(), MethodMatchers.create().ofTypes("org.apache.commons.io.IOUtils").names("toCharArray").addParametersMatcher("java.io.InputStream", "java.lang.String").build(), MethodMatchers.create().ofTypes("org.apache.commons.io.IOUtils").names("toInputStream").addParametersMatcher("java.lang.CharSequence", "java.lang.String").addParametersMatcher("java.lang.String", "java.lang.String").build(), MethodMatchers.create().ofTypes("org.apache.commons.io.IOUtils").names("toString").addParametersMatcher("byte[]", "java.lang.String").addParametersMatcher("java.io.InputStream", "java.lang.String").addParametersMatcher("java.net.URI", "java.lang.String").addParametersMatcher("java.net.URL", "java.lang.String").build(), MethodMatchers.create().ofTypes("org.apache.commons.io.IOUtils").names("write").addParametersMatcher("byte[]", "java.io.Writer", "java.lang.String").addParametersMatcher("char[]", "java.io.OutputStream", "java.lang.String").addParametersMatcher("java.lang.CharSequence", "java.io.OutputStream", "java.lang.String").addParametersMatcher("java.lang.String", "java.io.OutputStream", "java.lang.String").addParametersMatcher("java.lang.StringBuffer", "java.io.OutputStream", "java.lang.String").build(), MethodMatchers.create().ofTypes("org.apache.commons.io.IOUtils").names("writeLines").addParametersMatcher("java.util.Collection", "java.lang.String", "java.io.OutputStream", "java.lang.String").build(), MethodMatchers.create().ofTypes("java.lang.String").constructor().addParametersMatcher("byte[]", "java.lang.String").addParametersMatcher("byte[]", "int", "int", "java.lang.String").build(), MethodMatchers.create().ofTypes("java.io.InputStreamReader").constructor().addParametersMatcher("java.io.InputStream", "java.lang.String").build(), MethodMatchers.create().ofTypes("java.io.OutputStreamWriter").constructor().addParametersMatcher("java.io.OutputStream", "java.lang.String").build(), MethodMatchers.create().ofTypes("org.apache.commons.io.input.CharSequenceInputStream").constructor().addParametersMatcher("java.lang.CharSequence", "java.lang.String").addParametersMatcher("java.lang.CharSequence", "java.lang.String", "int").build(), MethodMatchers.create().ofTypes("org.apache.commons.io.input.ReaderInputStream").constructor().addParametersMatcher("java.io.Reader", "java.lang.String").addParametersMatcher("java.io.Reader", "java.lang.String", "int").build(), MethodMatchers.create().ofTypes("org.apache.commons.io.input.ReversedLinesFileReader").constructor().addParametersMatcher("java.io.File", "int", "java.lang.String").build(), MethodMatchers.create().ofTypes("org.apache.commons.io.output.LockableFileWriter").constructor().addParametersMatcher("java.io.File", "java.lang.String").addParametersMatcher("java.io.File", "java.lang.String", "boolean", "java.lang.String").build(), MethodMatchers.create().ofTypes("org.apache.commons.io.output.WriterOutputStream").constructor().addParametersMatcher("java.io.Writer", "java.lang.String").addParametersMatcher("java.io.Writer", "java.lang.String", "int", "boolean").build(), MethodMatchers.create().ofTypes("org.apache.commons.codec.binary.Hex").constructor().addParametersMatcher("java.lang.String").build(), MethodMatchers.create().ofTypes("org.apache.commons.codec.net.QuotedPrintableCodec").constructor().addParametersMatcher("java.lang.String").build());

    private static Map<String, String> createAliasToConstantNameMap() {
        MapBuilder<String, String> constantNames = MapBuilder.newMap();
        for (Charset charset : STANDARD_CHARSETS) {
            String constantName = charset.name().replace("-", "_");
            constantNames.put(charset.name(), constantName);
            for (String alias : charset.aliases()) {
                constantNames.put(alias.toUpperCase(Locale.ROOT), constantName);
            }
        }
        return constantNames.build();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS, Tree.Kind.IDENTIFIER);
    }

    @Override
    public void visitNode(Tree tree) {
        super.visitNode(tree);
        if (tree.is(Tree.Kind.IDENTIFIER)) {
            this.onMemberSelectExpressionFound((IdentifierTree)tree);
        }
    }

    private void onMemberSelectExpressionFound(IdentifierTree identifierTree) {
        Symbol symbol = identifierTree.symbol();
        if (symbol.isVariableSymbol() && symbol.owner().type().is("com.google.common.base.Charsets")) {
            String identifier = identifierTree.name();
            String aliasedIdentifier = identifier.replace("_", "-");
            if (STANDARD_CHARSETS.stream().anyMatch(c -> c.name().equals(aliasedIdentifier))) {
                this.reportIssue(identifierTree, "Replace \"com.google.common.base.Charsets." + identifier + "\" with \"StandardCharsets." + identifier + "\".");
            }
        }
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        if (this.context.getJavaVersion().asInt() >= 10) {
            return MethodMatchers.or(JAVA8_METHOD_MATCHERS, JAVA10_METHOD_MATCHERS);
        }
        return JAVA8_METHOD_MATCHERS;
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.checkCall(mit, mit.symbol(), mit.arguments());
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.checkCall(newClassTree, newClassTree.constructorSymbol(), newClassTree.arguments());
    }

    private void checkCall(ExpressionTree callExpression, Symbol symbol, Arguments arguments) {
        StandardCharsetsConstantsCheck.getCharsetNameArgument(symbol, arguments).ifPresent(charsetNameArgument -> StandardCharsetsConstantsCheck.getConstantName(charsetNameArgument).ifPresent(constantName -> {
            String methodRef;
            switch (methodRef = StandardCharsetsConstantsCheck.getMethodRef(symbol)) {
                case "Charset.forName": 
                case "Charsets.toCharset": {
                    this.reportIssue(callExpression, String.format("Replace %s() call with StandardCharsets.%s", methodRef, constantName));
                    break;
                }
                case "IOUtils.toString": {
                    if (arguments.size() == 2 && ((ExpressionTree)arguments.get(0)).symbolType().is(BYTE_ARRAY)) {
                        this.reportIssue(callExpression, "Replace IOUtils.toString() call with new String(..., StandardCharsets." + constantName + ");");
                        break;
                    }
                    this.reportDefaultIssue((ExpressionTree)charsetNameArgument, (String)constantName);
                    break;
                }
                default: {
                    this.reportDefaultIssue((ExpressionTree)charsetNameArgument, (String)constantName);
                }
            }
        }));
    }

    private void reportDefaultIssue(ExpressionTree charsetNameArgument, String constantName) {
        this.reportIssue(charsetNameArgument, "Replace charset name argument with StandardCharsets." + constantName);
    }

    private static Optional<ExpressionTree> getCharsetNameArgument(Symbol symbol, Arguments arguments) {
        List stringArguments = arguments.stream().filter(argument -> argument.symbolType().is(JAVA_LANG_STRING)).collect(Collectors.toList());
        if (stringArguments.isEmpty()) {
            return Optional.empty();
        }
        if (stringArguments.size() == 1) {
            return Optional.of((ExpressionTree)stringArguments.get(0));
        }
        switch (StandardCharsetsConstantsCheck.getMethodRef(symbol)) {
            case "FileUtils.writeStringToFile": 
            case "IOUtils.toInputStream": 
            case "IOUtils.write": 
            case "IOUtils.writeLines": {
                return Optional.of((ExpressionTree)ListUtils.getLast(stringArguments));
            }
            case "LockableFileWriter.<init>": {
                return Optional.of((ExpressionTree)stringArguments.get(0));
            }
        }
        return Optional.empty();
    }

    private static String getMethodRef(Symbol symbol) {
        return symbol.enclosingClass().name() + "." + symbol.name();
    }

    private static Optional<String> getConstantName(ExpressionTree argument) {
        return argument.asConstant(String.class).map(String::toUpperCase).map(ALIAS_TO_CONSTANT::get);
    }

    @Override
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava7Compatible();
    }
}

