/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JProblem;
import org.sonar.java.model.JWarning;
import org.sonar.java.model.JavaTree;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S1905")
public class RedundantTypeCastCheck
extends IssuableSubscriptionVisitor {
    private List<JWarning> warnings;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.COMPILATION_UNIT, Tree.Kind.TYPE_CAST);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.COMPILATION_UNIT)) {
            this.warnings = ((JavaTree.CompilationUnitTreeImpl)tree).warnings(JProblem.Type.REDUNDANT_CAST);
            return;
        }
        TypeCastTree typeCastTree = (TypeCastTree)tree;
        Type cast = typeCastTree.type().symbolType();
        if (this.isUnnecessaryCast(typeCastTree)) {
            String newType = cast.erasure().name();
            ((InternalJavaIssueBuilder)QuickFixHelper.newIssue(this.context).forRule(this).onRange(typeCastTree.openParenToken(), typeCastTree.closeParenToken()).withMessage("Remove this unnecessary cast to \"%s\".", newType).withQuickFix(() -> JavaQuickFix.newQuickFix("Remove the cast to \"%s\"", newType).addTextEdit(JavaTextEdit.removeTextSpan(AnalyzerMessage.textSpanBetween(typeCastTree.openParenToken(), true, typeCastTree.expression(), false))).build())).report();
        }
    }

    public static Tree skipParentheses(Tree tree) {
        if (tree instanceof ExpressionTree) {
            return ExpressionUtils.skipParentheses((ExpressionTree)tree);
        }
        return tree;
    }

    private boolean isUnnecessaryCast(TypeCastTree typeCastTree) {
        if (RedundantTypeCastCheck.skipParentheses(typeCastTree.expression()).is(Tree.Kind.NULL_LITERAL)) {
            Tree parentTree = RedundantTypeCastCheck.skipParentheses(typeCastTree.parent());
            return !parentTree.is(Tree.Kind.ARGUMENTS);
        }
        return this.warnings.stream().anyMatch(warning -> RedundantTypeCastCheck.matchesWarning(warning, typeCastTree));
    }

    private static boolean matchesWarning(JWarning warning, TypeCastTree tree) {
        Tree warningTree = warning.syntaxTree();
        if (warningTree.is(Tree.Kind.PARENTHESIZED_EXPRESSION)) {
            return tree.equals(RedundantTypeCastCheck.skipParentheses(warningTree));
        }
        return tree.equals(warningTree);
    }
}

