/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.cfg.LiveVariables;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.se.ProgramState;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1450")
public class PrivateFieldUsedLocallyCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Remove the \"%s\" field and declare it as a local variable in the relevant methods.";

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        Symbol.TypeSymbol classSymbol = ((ClassTree)tree).symbol();
        Set<Symbol> fieldsReadOnAnotherInstance = FieldsReadOnAnotherInstanceVisitor.getFrom(tree);
        classSymbol.memberSymbols().stream().filter(PrivateFieldUsedLocallyCheck::isPrivateField).filter(s -> !s.isFinal() || !s.isStatic()).filter(s -> !PrivateFieldUsedLocallyCheck.hasAnnotation(s)).filter(s -> !s.usages().isEmpty()).filter(s -> !fieldsReadOnAnotherInstance.contains(s)).forEach(s -> this.checkPrivateField((Symbol)s, classSymbol));
    }

    private static boolean hasAnnotation(Symbol s) {
        return !s.metadata().annotations().isEmpty();
    }

    private void checkPrivateField(Symbol privateFieldSymbol, Symbol.TypeSymbol classSymbol) {
        MethodTree methodWhereUsed = PrivateFieldUsedLocallyCheck.usedInOneMethodOnly(privateFieldSymbol, classSymbol);
        if (methodWhereUsed != null && !PrivateFieldUsedLocallyCheck.isLiveInMethodEntry(privateFieldSymbol, methodWhereUsed)) {
            IdentifierTree declarationIdentifier = ((VariableTree)privateFieldSymbol.declaration()).simpleName();
            String message = String.format(MESSAGE, privateFieldSymbol.name());
            this.reportIssue(declarationIdentifier, message);
        }
    }

    private static boolean isLiveInMethodEntry(Symbol privateFieldSymbol, MethodTree methodTree) {
        CFG cfg = (CFG)methodTree.cfg();
        LiveVariables liveVariables = LiveVariables.analyzeWithFields(cfg);
        return liveVariables.getIn(cfg.entryBlock()).contains(privateFieldSymbol);
    }

    private static boolean isPrivateField(Symbol memberSymbol) {
        return memberSymbol.isPrivate() && memberSymbol.isVariableSymbol();
    }

    @CheckForNull
    private static MethodTree usedInOneMethodOnly(Symbol privateFieldSymbol, Symbol.TypeSymbol classSymbol) {
        Object method = null;
        for (IdentifierTree usageIdentifier : privateFieldSymbol.usages()) {
            Tree containingClassOrMethod = PrivateFieldUsedLocallyCheck.containingClassOrMethod(usageIdentifier);
            if (PrivateFieldUsedLocallyCheck.noContainerOrClassContainer(containingClassOrMethod) || !((MethodTree)containingClassOrMethod).symbol().owner().equals(classSymbol) || method != null && !method.equals(containingClassOrMethod)) {
                return null;
            }
            method = (MethodTree)containingClassOrMethod;
        }
        return method;
    }

    private static boolean noContainerOrClassContainer(@Nullable Tree containingClassOrMethod) {
        return containingClassOrMethod == null || containingClassOrMethod.is(Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ENUM, Tree.Kind.ANNOTATION_TYPE);
    }

    private static Tree containingClassOrMethod(IdentifierTree usageIdentifier) {
        Tree parent = usageIdentifier;
        do {
            parent = parent.parent();
        } while (!parent.is(Tree.Kind.METHOD, Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ENUM, Tree.Kind.ANNOTATION_TYPE));
        return parent;
    }

    private static class FieldsReadOnAnotherInstanceVisitor
    extends BaseTreeVisitor {
        private Set<Symbol> fieldsReadOnAnotherInstance = new HashSet<Symbol>();

        private FieldsReadOnAnotherInstanceVisitor() {
        }

        static Set<Symbol> getFrom(Tree classTree) {
            FieldsReadOnAnotherInstanceVisitor fieldsReadOnAnotherInstanceVisitor = new FieldsReadOnAnotherInstanceVisitor();
            fieldsReadOnAnotherInstanceVisitor.scan(classTree);
            return fieldsReadOnAnotherInstanceVisitor.fieldsReadOnAnotherInstance;
        }

        @Override
        public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            Symbol symbol = tree.identifier().symbol();
            if (ProgramState.isField(symbol) && !symbol.isStatic()) {
                if (tree.expression().is(Tree.Kind.IDENTIFIER)) {
                    if (!ExpressionUtils.isThis(tree.expression())) {
                        this.fieldsReadOnAnotherInstance.add(symbol);
                    }
                } else {
                    this.fieldsReadOnAnotherInstance.add(symbol);
                }
            }
            super.visitMemberSelectExpression(tree);
        }
    }
}

