/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S4682")
public final class PrimitivesMarkedNullableCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        SymbolMetadata.NullabilityData nullabilityData;
        MethodTree methodTree = (MethodTree)tree;
        TypeTree returnType = methodTree.returnType();
        if (returnType.symbolType().isPrimitive() && (nullabilityData = methodTree.symbol().metadata().nullabilityData()).isNullable(SymbolMetadata.NullabilityLevel.METHOD, true, false)) {
            SymbolMetadata.AnnotationInstance annotation = nullabilityData.annotation();
            Tree annotationTree = nullabilityData.declaration();
            if (annotation != null && annotationTree != null) {
                String annotationName = annotation.symbol().name();
                ((InternalJavaIssueBuilder)QuickFixHelper.newIssue(this.context).forRule(this).onTree(returnType).withMessage("\"@%s\" annotation should not be used on primitive types", annotationName).withSecondaries(new JavaFileScannerContext.Location("Child annotation", annotationTree)).withQuickFix(() -> JavaQuickFix.newQuickFix("Remove \"@%s\"", annotationName).addTextEdit(JavaTextEdit.removeTextSpan(AnalyzerMessage.textSpanBetween(annotationTree, true, QuickFixHelper.nextToken(annotationTree), false))).build())).report();
            }
        }
    }
}

