/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.EndOfAnalysisCheck;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;

@Rule(key="S1228")
public class PackageInfoCheck
implements JavaFileScanner,
EndOfAnalysisCheck {
    @VisibleForTesting
    final Set<String> missingPackageWithoutPackageFile = new HashSet<String>();
    private final Set<String> knownPackageWithPackageFile = new HashSet<String>();
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        PackageDeclarationTree packageDeclaration = context.getTree().packageDeclaration();
        if (packageDeclaration == null) {
            return;
        }
        String packageName = ExpressionsHelper.concatenate(packageDeclaration.packageName());
        File parentFile = context.getInputFile().file().getParentFile();
        if (!new File(parentFile, "package-info.java").isFile()) {
            this.missingPackageWithoutPackageFile.add(packageName);
        } else {
            this.knownPackageWithPackageFile.add(packageName);
        }
    }

    @Override
    public void endOfAnalysis() {
        this.missingPackageWithoutPackageFile.removeAll(this.knownPackageWithPackageFile);
        for (String missingPackageInfo : this.missingPackageWithoutPackageFile) {
            this.context.addIssueOnProject(this, "Add a 'package-info.java' file to document the '" + missingPackageInfo + "' package");
        }
    }
}

