/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3553")
public class OptionalAsParameterCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_UTIL_OPTIONAL = "java.util.Optional";
    private static final String GUAVA_OPTIONAL = "com.google.common.base.Optional";
    private static final List<String> PRIMITIVE_OPTIONALS = Arrays.asList("java.util.OptionalDouble", "java.util.OptionalInt", "java.util.OptionalLong");

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    @Override
    public void visitNode(Tree tree) {
        for (VariableTree parameter : ((MethodTree)tree).parameters()) {
            TypeTree typeTree = parameter.type();
            Optional<String> msg = OptionalAsParameterCheck.expectedTypeInsteadOfOptional(typeTree.symbolType());
            if (!msg.isPresent()) continue;
            this.reportIssue(typeTree, msg.get());
        }
    }

    private static Optional<String> expectedTypeInsteadOfOptional(Type type) {
        if (type.is(JAVA_UTIL_OPTIONAL) || type.is(GUAVA_OPTIONAL)) {
            String msg;
            if (type.isParameterized()) {
                String parameterTypeName = type.typeArguments().get(0).erasure().name();
                msg = OptionalAsParameterCheck.formatMsg(parameterTypeName);
            } else {
                msg = "Specify a type instead.";
            }
            return Optional.of(msg);
        }
        return PRIMITIVE_OPTIONALS.stream().filter(type::is).findFirst().map(optional -> OptionalAsParameterCheck.formatMsg(optional.substring(JAVA_UTIL_OPTIONAL.length()).toLowerCase()));
    }

    private static String formatMsg(String typeName) {
        return "Specify a \"" + typeName + "\" parameter instead.";
    }
}

