/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonarsource.analyzer.commons.collections.SetUtils;

@Rule(key="S864")
public class OperatorPrecedenceCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Map<OperatorRelation, Boolean> OPERATORS_RELATION_TABLE = new HashMap<OperatorRelation, Boolean>();
    private static final Set<Tree.Kind> ARITHMETIC_OPERATORS = EnumSet.of(Tree.Kind.MINUS, Tree.Kind.REMAINDER, Tree.Kind.MULTIPLY, Tree.Kind.PLUS);
    private static final Set<Tree.Kind> EQUALITY_RELATIONAL_OPERATORS = EnumSet.of(Tree.Kind.EQUAL_TO, new Tree.Kind[]{Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.NOT_EQUAL_TO});
    private static final Set<Tree.Kind> SHIFT_OPERATORS = EnumSet.of(Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT);
    private static final Tree.Kind[] CONDITIONAL_EXCLUSIONS = new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION, Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT, Tree.Kind.PARENTHESIZED_EXPRESSION, Tree.Kind.TYPE_CAST, Tree.Kind.NEW_CLASS, Tree.Kind.ARRAY_ACCESS_EXPRESSION, Tree.Kind.NEW_ARRAY, Tree.Kind.METHOD_REFERENCE};
    private JavaFileScannerContext context;
    private Deque<Tree.Kind> stack = new LinkedList<Tree.Kind>();
    private Set<Integer> reportedLines = new HashSet<Integer>();

    private static void put(Iterable<Tree.Kind> firstSet, Iterable<Tree.Kind> secondSet) {
        for (Tree.Kind first : firstSet) {
            for (Tree.Kind second : secondSet) {
                OPERATORS_RELATION_TABLE.put(new OperatorRelation(first, second), true);
            }
        }
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.reportedLines.clear();
        this.scan(context.getTree());
        this.reportedLines.clear();
    }

    @Override
    public void visitAnnotation(AnnotationTree tree) {
        this.stack.push(null);
        for (ExpressionTree argument : tree.arguments()) {
            if (argument.is(Tree.Kind.ASSIGNMENT)) {
                this.scan(((AssignmentExpressionTree)argument).expression());
                continue;
            }
            this.scan(argument);
        }
        this.stack.pop();
    }

    @Override
    public void visitArrayAccessExpression(ArrayAccessExpressionTree tree) {
        this.scan(tree.expression());
        this.stack.push(null);
        this.scan(tree.dimension());
        this.stack.pop();
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        Tree.Kind kind;
        Tree.Kind peek = this.stack.peek();
        if (OperatorPrecedenceCheck.requiresParenthesis(peek, kind = tree.kind())) {
            this.raiseIssue(tree.operatorToken().range().start().line(), tree);
        }
        this.stack.push(kind);
        super.visitBinaryExpression(tree);
        this.stack.pop();
    }

    private static boolean requiresParenthesis(Tree.Kind kind1, Tree.Kind kind2) {
        return BooleanUtils.isTrue(OPERATORS_RELATION_TABLE.get(new OperatorRelation(kind1, kind2)));
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        super.visitIfStatement(tree);
        ExpressionTree condition = tree.condition();
        if (condition.is(Tree.Kind.ASSIGNMENT) && EQUALITY_RELATIONAL_OPERATORS.contains(((AssignmentExpressionTree)condition).expression().kind())) {
            this.raiseIssue(((AssignmentExpressionTree)condition).operatorToken().range().start().line(), tree);
        }
    }

    @Override
    public void visitMethodInvocation(MethodInvocationTree tree) {
        this.scan(tree.methodSelect());
        this.scan(tree.typeArguments());
        for (ExpressionTree argument : tree.arguments()) {
            this.stack.push(null);
            this.scan(argument);
            this.stack.pop();
        }
    }

    @Override
    public void visitNewArray(NewArrayTree tree) {
        this.stack.push(null);
        super.visitNewArray(tree);
        this.stack.pop();
    }

    @Override
    public void visitNewClass(NewClassTree tree) {
        this.stack.push(null);
        super.visitNewClass(tree);
        this.stack.pop();
    }

    @Override
    public void visitParenthesized(ParenthesizedTree tree) {
        this.stack.push(null);
        super.visitParenthesized(tree);
        this.stack.pop();
    }

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        this.checkConditionalOperand(tree.trueExpression());
        this.checkConditionalOperand(tree.falseExpression());
        super.visitConditionalExpression(tree);
    }

    private void checkConditionalOperand(ExpressionTree tree) {
        if (tree.is(CONDITIONAL_EXCLUSIONS) || tree instanceof LiteralTree || tree instanceof UnaryExpressionTree || OperatorPrecedenceCheck.isSimpleLambda(tree)) {
            return;
        }
        this.raiseIssue(tree.firstToken().range().start().line(), tree);
    }

    private static boolean isSimpleLambda(ExpressionTree tree) {
        if (!tree.is(Tree.Kind.LAMBDA_EXPRESSION)) {
            return false;
        }
        Tree body = ((LambdaExpressionTree)tree).body();
        return body instanceof LiteralTree || body instanceof UnaryExpressionTree || body.is(Tree.Kind.IDENTIFIER);
    }

    private void raiseIssue(int line, Tree tree) {
        if (this.reportedLines.add(line)) {
            this.context.reportIssue(this, tree, "Add parentheses to make the operator precedence explicit.");
        }
    }

    static {
        OperatorPrecedenceCheck.put(ARITHMETIC_OPERATORS, SetUtils.concat(SHIFT_OPERATORS, EnumSet.of(Tree.Kind.AND, Tree.Kind.XOR, Tree.Kind.OR)));
        OperatorPrecedenceCheck.put(SHIFT_OPERATORS, SetUtils.concat(ARITHMETIC_OPERATORS, EnumSet.of(Tree.Kind.AND, Tree.Kind.XOR, Tree.Kind.OR)));
        OperatorPrecedenceCheck.put(EnumSet.of(Tree.Kind.AND), SetUtils.concat(ARITHMETIC_OPERATORS, SHIFT_OPERATORS, EnumSet.of(Tree.Kind.XOR, Tree.Kind.OR)));
        OperatorPrecedenceCheck.put(EnumSet.of(Tree.Kind.XOR), SetUtils.concat(ARITHMETIC_OPERATORS, SHIFT_OPERATORS, EnumSet.of(Tree.Kind.AND, Tree.Kind.OR)));
        OperatorPrecedenceCheck.put(EnumSet.of(Tree.Kind.OR), SetUtils.concat(ARITHMETIC_OPERATORS, SHIFT_OPERATORS, EnumSet.of(Tree.Kind.AND, Tree.Kind.XOR)));
        OperatorPrecedenceCheck.put(EnumSet.of(Tree.Kind.CONDITIONAL_AND), EnumSet.of(Tree.Kind.CONDITIONAL_OR));
        OperatorPrecedenceCheck.put(EnumSet.of(Tree.Kind.CONDITIONAL_OR), EnumSet.of(Tree.Kind.CONDITIONAL_AND));
    }

    private static final class OperatorRelation {
        private final Tree.Kind first;
        private final Tree.Kind second;

        public OperatorRelation(Tree.Kind first, Tree.Kind second) {
            this.first = first;
            this.second = second;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperatorRelation that = (OperatorRelation)o;
            return this.first == that.first && this.second == that.second;
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }
    }
}

