/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchExpressionTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S134")
public class NestedIfStatementsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final int DEFAULT_MAX = 3;
    @RuleProperty(description="Maximum allowed control flow statement nesting depth.", defaultValue="3")
    public int max = 3;
    private JavaFileScannerContext context;
    private Deque<Tree> nestingLevel;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.nestingLevel = new ArrayDeque<Tree>();
        this.scan(context.getTree());
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        SyntaxToken ifKeyword = tree.ifKeyword();
        this.checkNesting(ifKeyword);
        this.nestingLevel.push(ifKeyword);
        this.visit(tree);
        this.nestingLevel.pop();
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        SyntaxToken forKeyword = tree.forKeyword();
        this.checkNesting(forKeyword);
        this.nestingLevel.push(forKeyword);
        super.visitForStatement(tree);
        this.nestingLevel.pop();
    }

    @Override
    public void visitForEachStatement(ForEachStatement tree) {
        SyntaxToken forKeyword = tree.forKeyword();
        this.checkNesting(forKeyword);
        this.nestingLevel.push(forKeyword);
        super.visitForEachStatement(tree);
        this.nestingLevel.pop();
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        SyntaxToken whileKeyword = tree.whileKeyword();
        this.checkNesting(whileKeyword);
        this.nestingLevel.push(whileKeyword);
        super.visitWhileStatement(tree);
        this.nestingLevel.pop();
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        SyntaxToken doKeyword = tree.doKeyword();
        this.checkNesting(doKeyword);
        this.nestingLevel.push(doKeyword);
        super.visitDoWhileStatement(tree);
        this.nestingLevel.pop();
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        SyntaxToken switchKeyword = tree.switchKeyword();
        this.checkNesting(switchKeyword);
        this.nestingLevel.push(switchKeyword);
        super.visitSwitchStatement(tree);
        this.nestingLevel.pop();
    }

    @Override
    public void visitSwitchExpression(SwitchExpressionTree tree) {
        SyntaxToken switchKeyword = tree.switchKeyword();
        this.checkNesting(switchKeyword);
        this.nestingLevel.push(switchKeyword);
        super.visitSwitchExpression(tree);
        this.nestingLevel.pop();
    }

    @Override
    public void visitTryStatement(TryStatementTree tree) {
        SyntaxToken tryKeyword = tree.tryKeyword();
        this.checkNesting(tryKeyword);
        this.nestingLevel.push(tryKeyword);
        this.scan(tree.block());
        this.nestingLevel.pop();
        this.scan(tree.resourceList());
        this.scan(tree.catches());
        this.scan(tree.finallyBlock());
    }

    private void checkNesting(Tree tree) {
        int size = this.nestingLevel.size();
        if (size == this.max) {
            ArrayList<JavaFileScannerContext.Location> secondary = new ArrayList<JavaFileScannerContext.Location>(size);
            for (Tree element : this.nestingLevel) {
                secondary.add(new JavaFileScannerContext.Location("Nesting + 1", element));
            }
            this.context.reportIssue(this, tree, "Refactor this code to not nest more than " + this.max + " if/for/while/switch/try statements.", secondary, null);
        }
    }

    private void visit(IfStatementTree tree) {
        this.scan(tree.condition());
        this.scan(tree.thenStatement());
        StatementTree elseStatementTree = tree.elseStatement();
        if (elseStatementTree != null && elseStatementTree.is(Tree.Kind.IF_STATEMENT)) {
            this.visit((IfStatementTree)elseStatementTree);
        } else {
            this.scan(elseStatementTree);
        }
    }
}

