/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1199")
public class NestedBlocksCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitCaseGroup(CaseGroupTree tree) {
        List<StatementTree> body = tree.body();
        int statementsInBody = body.size();
        if (statementsInBody == 0) {
            return;
        }
        if (NestedBlocksCheck.isTerminalStatement(body.get(statementsInBody - 1))) {
            --statementsInBody;
        }
        if (statementsInBody > 1) {
            this.checkStatements(tree.body());
        }
        super.visitCaseGroup(tree);
    }

    @Override
    public void visitBlock(BlockTree tree) {
        this.checkStatements(tree.body());
        super.visitBlock(tree);
    }

    private static boolean isTerminalStatement(StatementTree statementTree) {
        return statementTree.is(Tree.Kind.YIELD_STATEMENT, Tree.Kind.BREAK_STATEMENT, Tree.Kind.RETURN_STATEMENT);
    }

    private void checkStatements(List<StatementTree> statements) {
        for (StatementTree statement : statements) {
            if (!statement.is(Tree.Kind.BLOCK)) continue;
            this.context.reportIssue(this, ((BlockTree)statement).openBraceToken(), "Extract this nested code block into a method.");
        }
    }
}

