/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifierTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="ModifiersOrderCheck", repositoryKey="squid")
@Rule(key="S1124")
public class ModifiersOrderCheck
extends IssuableSubscriptionVisitor {
    private Set<Tree> alreadyReported = new HashSet<Tree>();

    @Override
    public void setContext(JavaFileScannerContext context) {
        this.alreadyReported.clear();
        super.setContext(context);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.MODIFIERS);
    }

    @Override
    public void visitNode(Tree tree) {
        if (!this.alreadyReported.contains(tree)) {
            ModifiersTree modifiers = (ModifiersTree)tree;
            this.alreadyReported.add(modifiers);
            ModifiersOrderCheck.getFirstBadlyOrdered(modifiers).ifPresent(wrongModifier -> ((InternalJavaIssueBuilder)QuickFixHelper.newIssue(this.context).forRule(this).onTree((Tree)wrongModifier).withMessage("Reorder the modifiers to comply with the Java Language Specification.").withQuickFix(() -> ModifiersOrderCheck.reorderedFix(modifiers))).report());
        }
    }

    private static Optional<ModifierTree> getFirstBadlyOrdered(ModifiersTree modifiersTree) {
        ModifierTree modifier;
        ListIterator<ModifierTree> modifiersIterator = modifiersTree.listIterator();
        ModifiersOrderCheck.skipAnnotations(modifiersIterator);
        Modifier[] modifiers = Modifier.values();
        int modifierIndex = 0;
        while (modifiersIterator.hasNext() && !(modifier = modifiersIterator.next()).is(Tree.Kind.ANNOTATION)) {
            ModifierKeywordTree mkt = (ModifierKeywordTree)modifier;
            while (modifierIndex < modifiers.length && !mkt.modifier().equals((Object)modifiers[modifierIndex])) {
                ++modifierIndex;
            }
            if (modifierIndex != modifiers.length) continue;
            return Optional.of(modifier);
        }
        return ModifiersOrderCheck.testOnlyAnnotationsAreLeft(modifiersIterator);
    }

    private static void skipAnnotations(ListIterator<ModifierTree> modifiersIterator) {
        while (modifiersIterator.hasNext() && modifiersIterator.next().is(Tree.Kind.ANNOTATION)) {
        }
        if (modifiersIterator.hasNext()) {
            modifiersIterator.previous();
        }
    }

    private static Optional<ModifierTree> testOnlyAnnotationsAreLeft(ListIterator<ModifierTree> modifiersIterator) {
        while (modifiersIterator.hasNext()) {
            ModifierTree modifier = modifiersIterator.next();
            if (modifier.is(Tree.Kind.ANNOTATION)) continue;
            modifiersIterator.previous();
            if (!modifiersIterator.hasPrevious()) continue;
            return Optional.of(modifiersIterator.previous());
        }
        return Optional.empty();
    }

    private static JavaQuickFix reorderedFix(ModifiersTree modifiersTree) {
        JavaQuickFix.Builder builder = JavaQuickFix.newQuickFix("Reorder modifiers");
        ArrayList<AnnotationTree> annotations = new ArrayList<AnnotationTree>(modifiersTree.annotations());
        if (annotations.isEmpty()) {
            builder.addTextEdit(JavaTextEdit.removeTree(modifiersTree));
            builder.addTextEdit(ModifiersOrderCheck.reorderedModifiers(modifiersTree, false));
        } else {
            ModifiersOrderCheck.removalOfAllModifiers(modifiersTree).stream().map(JavaTextEdit::removeTextSpan).forEach(xva$0 -> builder.addTextEdit((JavaTextEdit)xva$0));
            builder.addTextEdit(ModifiersOrderCheck.reorderedModifiers(modifiersTree, true));
        }
        return builder.build();
    }

    private static List<AnalyzerMessage.TextSpan> removalOfAllModifiers(ModifiersTree modifiersTree) {
        ArrayList<AnalyzerMessage.TextSpan> removals = new ArrayList<AnalyzerMessage.TextSpan>();
        int numberModifiers = modifiersTree.size();
        for (int i = 0; i < numberModifiers; ++i) {
            ModifierTree current = (ModifierTree)modifiersTree.get(i);
            if (current.is(Tree.Kind.ANNOTATION)) continue;
            if (i == numberModifiers - 1) {
                removals.add(AnalyzerMessage.textSpanBetween(current, true, QuickFixHelper.nextToken(modifiersTree), false));
                continue;
            }
            removals.add(AnalyzerMessage.textSpanBetween(current, true, (Tree)modifiersTree.get(i + 1), false));
        }
        return removals;
    }

    private static JavaTextEdit reorderedModifiers(ModifiersTree modifiersTree, boolean useParent) {
        String replacement = modifiersTree.modifiers().stream().sorted((m1, m2) -> m1.modifier().compareTo(m2.modifier())).map(ModifierKeywordTree::keyword).map(SyntaxToken::text).collect(Collectors.joining(" "));
        if (!useParent) {
            return JavaTextEdit.insertBeforeTree((Tree)modifiersTree.get(0), replacement);
        }
        return JavaTextEdit.insertBeforeTree(QuickFixHelper.nextToken(modifiersTree), replacement + " ");
    }
}

