/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3416")
public class LoggerClassCheck
extends IssuableSubscriptionVisitor {
    private static final String CLASS = "java.lang.Class";
    public static final String STRING = "java.lang.String";
    private static final MethodMatchers LOG_FACTORIES = MethodMatchers.or(MethodMatchers.create().ofAnyType().names("getLogger").addParametersMatcher("java.lang.Class").addParametersMatcher("java.lang.String").build(), MethodMatchers.create().ofTypes("org.apache.commons.logging.LogFactory").names("getLog").addParametersMatcher("java.lang.Class").addParametersMatcher("java.lang.String").build(), MethodMatchers.create().ofTypes("org.sonar.api.utils.log.Loggers").names("get").addParametersMatcher("java.lang.Class").addParametersMatcher("java.lang.String").build());
    private static final MethodMatchers CLAZZ_GETNAME = MethodMatchers.create().ofTypes("java.lang.Class").names("getName").addWithoutParametersMatcher().build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        Symbol.TypeSymbol clazz = ((ClassTree)tree).symbol();
        clazz.memberSymbols().stream().filter(Symbol::isVariableSymbol).forEach(field -> this.checkField(clazz, (Symbol.VariableSymbol)field));
    }

    private void checkField(Symbol.TypeSymbol clazz, Symbol.VariableSymbol field) {
        ExpressionTree firstArg;
        Symbol classLiteral;
        VariableTree declaration = field.declaration();
        if (declaration == null) {
            return;
        }
        ExpressionTree initializer = declaration.initializer();
        if (initializer != null && initializer.is(Tree.Kind.METHOD_INVOCATION) && LOG_FACTORIES.matches((MethodInvocationTree)initializer) && (classLiteral = LoggerClassCheck.classLiteral(firstArg = (ExpressionTree)((MethodInvocationTree)initializer).arguments().get(0))) != null && !clazz.type().erasure().equals(classLiteral.type().erasure())) {
            this.reportIssue(firstArg, "Update this logger to use \"" + clazz.name() + ".class\".");
        }
    }

    @CheckForNull
    private static Symbol classLiteral(ExpressionTree expression) {
        MethodInvocationTree mit;
        MemberSelectExpressionTree mset;
        if (expression.is(Tree.Kind.MEMBER_SELECT) && (mset = (MemberSelectExpressionTree)expression).identifier().name().equals("class")) {
            return mset.expression().symbolType().symbol();
        }
        if (expression.is(Tree.Kind.METHOD_INVOCATION) && CLAZZ_GETNAME.matches((MethodInvocationTree)expression) && (mit = (MethodInvocationTree)expression).methodSelect().is(Tree.Kind.MEMBER_SELECT)) {
            return LoggerClassCheck.classLiteral(((MemberSelectExpressionTree)mit.methodSelect()).expression());
        }
        return null;
    }
}

