/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1611")
public class LambdaOptionalParenthesisCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.LAMBDA_EXPRESSION);
    }

    @Override
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    @Override
    public void visitNode(Tree tree) {
        LambdaExpressionTree let = (LambdaExpressionTree)tree;
        SyntaxToken openParenToken = let.openParenToken();
        if (openParenToken != null && let.parameters().size() == 1) {
            VariableTree param = let.parameters().get(0);
            String identifier = param.simpleName().name();
            if (param.type().is(Tree.Kind.INFERED_TYPE)) {
                this.reportIssue(openParenToken, "Remove the parentheses around the \"" + identifier + "\" parameter" + this.context.getJavaVersion().java8CompatibilityMessage());
            }
        }
    }
}

