/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4348")
public class IterableIteratorCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers ITERATOR = MethodMatchers.create().ofSubTypes("java.lang.Iterable").names("iterator").addWithoutParametersMatcher().build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        ReturnThis returnThis = new ReturnThis();
        ClassTree classTree = (ClassTree)tree;
        Type classType = classTree.symbol().type();
        if (!classType.isSubtypeOf("java.util.Iterator") || !classType.isSubtypeOf("java.lang.Iterable")) {
            return;
        }
        classTree.members().stream().filter(m -> m.is(Tree.Kind.METHOD)).filter(m -> ITERATOR.matches((MethodTree)m)).forEach(t -> t.accept(returnThis));
        if (!returnThis.issueLocations.isEmpty()) {
            this.reportIssue(returnThis.issueLocations.get(0), "Refactor this code so that the Iterator supports multiple traversal", returnThis.issueLocations.stream().skip(1L).map(t -> new JavaFileScannerContext.Location("", (Tree)t)).collect(Collectors.toList()), null);
        }
    }

    private static class ReturnThis
    extends BaseTreeVisitor {
        private List<Tree> issueLocations = new ArrayList<Tree>();

        private ReturnThis() {
        }

        @Override
        public void visitClass(ClassTree tree) {
        }

        @Override
        public void visitReturnStatement(ReturnStatementTree tree) {
            ExpressionTree returnedExpression = tree.expression();
            if (ExpressionUtils.isThis(returnedExpression)) {
                this.issueLocations.add(returnedExpression);
            }
            super.visitReturnStatement(tree);
        }
    }
}

