/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

@Rule(key="S1488")
public class ImmediatelyReturnedVariableCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Map<Tree.Kind, String> MESSAGE_KEYS = MapBuilder.newMap().put(Tree.Kind.THROW_STATEMENT, "throw").put(Tree.Kind.RETURN_STATEMENT, "return").build();
    private JavaFileScannerContext context;
    private String lastTypeForMessage;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitBlock(BlockTree tree) {
        super.visitBlock(tree);
        List<StatementTree> statements = tree.body();
        int size = statements.size();
        if (size < 2) {
            return;
        }
        StatementTree butLastStatement = statements.get(size - 2);
        if (butLastStatement.is(Tree.Kind.VARIABLE)) {
            String identifier;
            VariableTree variableTree = (VariableTree)butLastStatement;
            if (!variableTree.modifiers().annotations().isEmpty()) {
                return;
            }
            StatementTree lastStatement = statements.get(size - 1);
            String lastStatementIdentifier = this.getReturnOrThrowIdentifier(lastStatement);
            if (lastStatementIdentifier != null && StringUtils.equals(lastStatementIdentifier, identifier = variableTree.simpleName().name())) {
                ExpressionTree initializer = variableTree.initializer();
                if (initializer == null) {
                    return;
                }
                ((InternalJavaIssueBuilder)QuickFixHelper.newIssue(this.context).forRule(this).onTree(initializer).withMessage("Immediately %s this expression instead of assigning it to the temporary variable \"%s\".", this.lastTypeForMessage, identifier).withQuickFix(() -> ImmediatelyReturnedVariableCheck.quickFix(butLastStatement, lastStatement, variableTree, this.lastTypeForMessage))).report();
            }
        }
    }

    private static JavaQuickFix quickFix(StatementTree butLastStatement, StatementTree lastStatement, VariableTree variableTree, String lastTypeForMessage) {
        return JavaQuickFix.newQuickFix("Inline expression").addTextEdit(JavaTextEdit.replaceTextSpan(AnalyzerMessage.textSpanBetween(variableTree.modifiers(), true, variableTree.initializer(), false), lastTypeForMessage + " "), JavaTextEdit.removeTextSpan(AnalyzerMessage.textSpanBetween(butLastStatement, false, lastStatement, true))).build();
    }

    @CheckForNull
    private String getReturnOrThrowIdentifier(StatementTree lastStatementOfBlock) {
        this.lastTypeForMessage = null;
        ExpressionTree expr = null;
        if (lastStatementOfBlock.is(Tree.Kind.THROW_STATEMENT)) {
            this.lastTypeForMessage = MESSAGE_KEYS.get(Tree.Kind.THROW_STATEMENT);
            expr = ((ThrowStatementTree)lastStatementOfBlock).expression();
        } else if (lastStatementOfBlock.is(Tree.Kind.RETURN_STATEMENT)) {
            this.lastTypeForMessage = MESSAGE_KEYS.get(Tree.Kind.RETURN_STATEMENT);
            expr = ((ReturnStatementTree)lastStatementOfBlock).expression();
        }
        if (expr != null && expr.is(Tree.Kind.IDENTIFIER)) {
            return ((IdentifierTree)expr).name();
        }
        return null;
    }
}

