/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractForLoopRule;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2251")
public class ForLoopIncrementSignCheck
extends AbstractForLoopRule {
    @Override
    public void visitForStatement(ForStatementTree forStatement) {
        ExpressionTree condition = forStatement.condition();
        AbstractForLoopRule.ForLoopIncrement loopIncrement = AbstractForLoopRule.ForLoopIncrement.findInUpdates(forStatement);
        if (condition == null || loopIncrement == null || !loopIncrement.hasValue()) {
            return;
        }
        this.checkIncrementSign(condition, loopIncrement);
    }

    private void checkIncrementSign(ExpressionTree condition, AbstractForLoopRule.ForLoopIncrement loopIncrement) {
        if (condition.is(Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO)) {
            BinaryExpressionTree binaryExp = (BinaryExpressionTree)condition;
            if (loopIncrement.hasSameIdentifier(binaryExp.leftOperand())) {
                this.checkNegativeIncrement(condition, loopIncrement);
            } else if (loopIncrement.hasSameIdentifier(binaryExp.rightOperand())) {
                this.checkPositiveIncrement(condition, loopIncrement);
            }
        } else if (condition.is(Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO)) {
            BinaryExpressionTree binaryExp = (BinaryExpressionTree)condition;
            if (loopIncrement.hasSameIdentifier(binaryExp.leftOperand())) {
                this.checkPositiveIncrement(condition, loopIncrement);
            } else if (loopIncrement.hasSameIdentifier(binaryExp.rightOperand())) {
                this.checkNegativeIncrement(condition, loopIncrement);
            }
        }
    }

    private void checkPositiveIncrement(Tree tree, AbstractForLoopRule.ForLoopIncrement loopIncrement) {
        if (loopIncrement.value() < 0) {
            this.reportIssue(tree, String.format("\"%s\" is decremented and will never reach \"stop condition\".", loopIncrement.identifier().name()));
        }
    }

    private void checkNegativeIncrement(Tree tree, AbstractForLoopRule.ForLoopIncrement loopIncrement) {
        if (loopIncrement.value() > 0) {
            this.reportIssue(tree, String.format("\"%s\" is incremented and will never reach \"stop condition\".", loopIncrement.identifier().name()));
        }
    }
}

