/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.CompareWithEqualsVisitor;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4973")
public class CompareStringsBoxedTypesWithEqualsCheck
extends CompareWithEqualsVisitor {
    private static final String ISSUE_MESSAGE = "Strings and Boxed types should be compared using \"equals()\".";
    private static final String QUICK_FIX_MESSAGE = "Replace with boxed comparison";
    private static final String DOT_EQUALS_AND_OPENING_PARENTHESIS = ".equals(";
    private QuickFixHelper.ImportSupplier importSupplier;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.importSupplier = null;
        super.scanFile(context);
    }

    @Override
    protected void checkEqualityExpression(BinaryExpressionTree tree) {
        Type rightOpType;
        Type leftOpType = tree.leftOperand().symbolType();
        if (!CompareStringsBoxedTypesWithEqualsCheck.isNullComparison(leftOpType, rightOpType = tree.rightOperand().symbolType()) && !CompareStringsBoxedTypesWithEqualsCheck.isCompareWithBooleanConstant(tree.leftOperand(), tree.rightOperand()) && (CompareStringsBoxedTypesWithEqualsCheck.isStringType(leftOpType, rightOpType) || CompareStringsBoxedTypesWithEqualsCheck.isBoxedType(leftOpType, rightOpType))) {
            ((InternalJavaIssueBuilder)QuickFixHelper.newIssue(this.context).forRule(this).onTree(tree.operatorToken()).withMessage(ISSUE_MESSAGE).withQuickFix(() -> CompareStringsBoxedTypesWithEqualsCheck.computeConciseQuickFix(tree).orElseGet(() -> this.computeDefaultQuickFix(tree)))).report();
        }
    }

    private static boolean isCompareWithBooleanConstant(ExpressionTree left, ExpressionTree right) {
        return ExpressionsHelper.getConstantValueAsBoolean(left).value() != null || ExpressionsHelper.getConstantValueAsBoolean(right).value() != null;
    }

    private static Optional<JavaQuickFix> computeConciseQuickFix(BinaryExpressionTree tree) {
        ExpressionTree leftOperand = tree.leftOperand();
        ExpressionTree rightOperand = tree.rightOperand();
        if (leftOperand.is(Tree.Kind.STRING_LITERAL)) {
            AnalyzerMessage.TextSpan interOperandSpace = AnalyzerMessage.textSpanBetween(leftOperand, false, rightOperand, false);
            JavaQuickFix.Builder quickFix = JavaQuickFix.newQuickFix(QUICK_FIX_MESSAGE).addTextEdit(JavaTextEdit.insertAfterTree(rightOperand, ")")).addTextEdit(JavaTextEdit.replaceTextSpan(interOperandSpace, DOT_EQUALS_AND_OPENING_PARENTHESIS));
            if (tree.is(Tree.Kind.NOT_EQUAL_TO)) {
                quickFix.addTextEdit(JavaTextEdit.insertBeforeTree(leftOperand, "!"));
            }
            return Optional.of(quickFix.build());
        }
        if (rightOperand.is(Tree.Kind.STRING_LITERAL)) {
            String callEqualsOnLiteral = ((LiteralTree)rightOperand).value() + DOT_EQUALS_AND_OPENING_PARENTHESIS;
            String callToEquals = tree.is(Tree.Kind.NOT_EQUAL_TO) ? "!" + callEqualsOnLiteral : callEqualsOnLiteral;
            AnalyzerMessage.TextSpan leftOfOperatorToEndOfComparison = AnalyzerMessage.textSpanBetween(leftOperand, false, rightOperand, true);
            return Optional.of(JavaQuickFix.newQuickFix(QUICK_FIX_MESSAGE).addTextEdit(JavaTextEdit.replaceTextSpan(leftOfOperatorToEndOfComparison, ")")).addTextEdit(JavaTextEdit.insertBeforeTree(leftOperand, callToEquals)).build());
        }
        return Optional.empty();
    }

    private JavaQuickFix computeDefaultQuickFix(BinaryExpressionTree tree) {
        String callToEquals = tree.is(Tree.Kind.NOT_EQUAL_TO) ? "!Objects.equals(" : "Objects.equals(";
        AnalyzerMessage.TextSpan interOperandSpace = AnalyzerMessage.textSpanBetween(tree.leftOperand(), false, tree.rightOperand(), false);
        JavaQuickFix.Builder builder = JavaQuickFix.newQuickFix(QUICK_FIX_MESSAGE).addTextEdit(JavaTextEdit.insertAfterTree(tree.rightOperand(), ")")).addTextEdit(JavaTextEdit.replaceTextSpan(interOperandSpace, ", ")).addTextEdit(JavaTextEdit.insertBeforeTree(tree.leftOperand(), callToEquals));
        if (this.importSupplier == null) {
            this.importSupplier = QuickFixHelper.newImportSupplier(this.context);
        }
        this.importSupplier.newImportEdit("java.util.Objects").ifPresent(xva$0 -> builder.addTextEdit((JavaTextEdit)xva$0));
        return builder.build();
    }
}

