/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

@Rule(key="S1596")
public class CollectionsEmptyConstantsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Map<String, String> IDENTIFIER_REPLACEMENT = MapBuilder.newMap().put("EMPTY_LIST", "emptyList()").put("EMPTY_MAP", "emptyMap()").put("EMPTY_SET", "emptySet()").build();
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        super.visitMemberSelectExpression(tree);
        String identifier = tree.identifier().name();
        boolean isCollectionsCall = tree.expression().is(Tree.Kind.IDENTIFIER) && "Collections".equals(((IdentifierTree)tree.expression()).name());
        boolean callEmptyConstant = identifier.startsWith("EMPTY_");
        if (isCollectionsCall && callEmptyConstant) {
            this.context.reportIssue(this, tree, "Replace \"Collections." + identifier + "\" by \"Collections." + IDENTIFIER_REPLACEMENT.get(identifier) + "\".");
        }
    }
}

