/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

@Rule(key="S1319")
public class CollectionImplementationReferencedCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String DEQUE = "java.util.Deque";
    private static final String LIST = "java.util.List";
    private static final String MAP = "java.util.Map";
    private static final String CONCURRENT_MAP = "java.util.concurrent.ConcurrentMap";
    private static final String QUEUE = "java.util.Queue";
    private static final String SET = "java.util.Set";
    private static final String SORTED_MAP = "java.util.SortedMap";
    private static final String SORTED_SET = "java.util.SortedSet";
    private static final Map<String, String> MAPPING = MapBuilder.newMap().put("java.util.ArrayDeque", "java.util.Deque").put("java.util.concurrent.ConcurrentLinkedDeque", "java.util.Deque").put("java.util.AbstractList", "java.util.List").put("java.util.AbstractSequentialList", "java.util.List").put("java.util.ArrayList", "java.util.List").put("java.util.LinkedList", "java.util.List").put("java.util.concurrent.CopyOnWriteArrayList", "java.util.List").put("java.util.AbstractMap", "java.util.Map").put("java.util.EnumMap", "java.util.Map").put("java.util.HashMap", "java.util.Map").put("java.util.Hashtable", "java.util.Map").put("java.util.IdentityHashMap", "java.util.Map").put("java.util.LinkedHashMap", "java.util.Map").put("java.util.WeakHashMap", "java.util.Map").put("java.util.concurrent.ConcurrentHashMap", "java.util.concurrent.ConcurrentMap").put("java.util.concurrent.ConcurrentSkipListMap", "java.util.concurrent.ConcurrentMap").put("java.util.AbstractQueue", "java.util.Queue").put("java.util.concurrent.ConcurrentLinkedQueue", "java.util.Queue").put("java.util.concurrent.SynchronousQueue", "java.util.Queue").put("java.util.AbstractSet", "java.util.Set").put("java.util.concurrent.CopyOnWriteArraySet", "java.util.Set").put("java.util.EnumSet", "java.util.Set").put("java.util.HashSet", "java.util.Set").put("java.util.LinkedHashSet", "java.util.Set").put("java.util.TreeMap", "java.util.SortedMap").put("java.util.TreeSet", "java.util.SortedSet").build();
    private JavaFileScannerContext context;
    private QuickFixHelper.ImportSupplier importSupplier;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.importSupplier = null;
        this.scan(context.getTree());
    }

    @Override
    public void visitVariable(VariableTree tree) {
        super.visitVariable(tree);
        if (CollectionImplementationReferencedCheck.isPublic(tree.modifiers())) {
            this.checkIfAllowed(tree.type(), String.format("The type of \"%s\"", tree.simpleName()));
        }
    }

    @Override
    public void visitMethod(MethodTree tree) {
        super.visitMethod(tree);
        if (CollectionImplementationReferencedCheck.isPublic(tree.modifiers()) && Boolean.FALSE.equals(tree.isOverriding())) {
            this.checkIfAllowed(tree.returnType(), "The return type of this method");
            for (VariableTree variableTree : tree.parameters()) {
                this.checkIfAllowed(variableTree.type(), String.format("The type of \"%s\"", variableTree.simpleName()));
            }
        }
    }

    private void checkIfAllowed(@Nullable TypeTree tree, String messagePrefix) {
        if (tree == null) {
            return;
        }
        String usedCollection = tree.symbolType().erasure().fullyQualifiedName();
        if (!MAPPING.containsKey(usedCollection)) {
            return;
        }
        TypeTree reportTree = tree.is(Tree.Kind.PARAMETERIZED_TYPE) ? ((ParameterizedTypeTree)tree).type() : tree;
        String targetCollection = MAPPING.get(usedCollection);
        String usedCollectionSimpleName = CollectionImplementationReferencedCheck.toSimpleName(usedCollection);
        ((InternalJavaIssueBuilder)QuickFixHelper.newIssue(this.context).forRule(this).onTree(reportTree).withMessage("%s should be an interface such as \"%s\" rather than the implementation \"%s\".", messagePrefix, CollectionImplementationReferencedCheck.toSimpleName(targetCollection), usedCollectionSimpleName).withQuickFix(() -> this.quickFix(reportTree, usedCollectionSimpleName, targetCollection))).report();
    }

    private JavaQuickFix quickFix(TypeTree typeTree, String usedCollection, String targetedCollection) {
        String targetedCollectionSimpleName = CollectionImplementationReferencedCheck.toSimpleName(targetedCollection);
        ArrayList<JavaTextEdit> edits = new ArrayList<JavaTextEdit>();
        edits.add(JavaTextEdit.replaceTree(typeTree, targetedCollectionSimpleName));
        this.getImportSupplier().newImportEdit(targetedCollection).ifPresent(edits::add);
        return JavaQuickFix.newQuickFix("Replace \"%s\" by \"%s\"", usedCollection, targetedCollectionSimpleName).addTextEdits(edits).build();
    }

    private QuickFixHelper.ImportSupplier getImportSupplier() {
        if (this.importSupplier == null) {
            this.importSupplier = QuickFixHelper.newImportSupplier(this.context);
        }
        return this.importSupplier;
    }

    private static String toSimpleName(String fullyQualifiedName) {
        return fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(46) + 1);
    }

    private static boolean isPublic(ModifiersTree modifiers) {
        return ModifiersUtils.hasModifier(modifiers, Modifier.PUBLIC);
    }
}

