/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1872")
public class ClassComparedByNameCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes("java.lang.String").names("equals").withAnyParameters().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (!mit.methodSelect().is(Tree.Kind.MEMBER_SELECT)) {
            return;
        }
        ExpressionTree firstOperand = ExpressionUtils.skipParentheses(((MemberSelectExpressionTree)mit.methodSelect()).expression());
        ExpressionTree secondOperand = ExpressionUtils.skipParentheses((ExpressionTree)mit.arguments().get(0));
        boolean firstOpIsClassGetNameMethod = ClassComparedByNameCheck.useClassGetNameMethod(firstOperand);
        boolean secondOpIsClassGetNameMethod = ClassComparedByNameCheck.useClassGetNameMethod(secondOperand);
        if (firstOpIsClassGetNameMethod && secondOpIsClassGetNameMethod) {
            this.reportIssue(mit, "Use \"isAssignableFrom\" instead.");
        } else if (firstOpIsClassGetNameMethod && secondOperand.is(Tree.Kind.STRING_LITERAL) || secondOpIsClassGetNameMethod && firstOperand.is(Tree.Kind.STRING_LITERAL)) {
            this.reportIssue(mit, "Use an \"instanceof\" comparison instead.");
        }
    }

    private static boolean useClassGetNameMethod(ExpressionTree expression) {
        ClassGetNameDetector visitor = new ClassGetNameDetector();
        expression.accept(visitor);
        return visitor.useClassGetName;
    }

    private static class ClassGetNameDetector
    extends BaseTreeVisitor {
        private boolean useClassGetName = false;
        private static final MethodMatchers METHOD_MATCHERS = MethodMatchers.create().ofTypes("java.lang.Class").names("getName", "getSimpleName").addWithoutParametersMatcher().build();

        private ClassGetNameDetector() {
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (METHOD_MATCHERS.matches(tree)) {
                this.useClassGetName = true;
            }
            this.scan(tree.methodSelect());
        }
    }
}

