/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S5411")
public class BoxedBooleanExpressionsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final MethodMatchers OPTIONAL_ORELSE = MethodMatchers.create().ofTypes("java.util.Optional").names("orElse").addParametersMatcher("*").build();
    private static final String BOOLEAN = "java.lang.Boolean";
    private JavaFileScannerContext context;
    private static final Map<Tree, IfStatementTree> ifStatementCache = new HashMap<Tree, IfStatementTree>();
    private static final Map<Symbol, ExpressionTree> firstNullCheckCache = new HashMap<Symbol, ExpressionTree>();

    @Override
    public void scanFile(JavaFileScannerContext context) {
        ifStatementCache.clear();
        firstNullCheckCache.clear();
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan(context.getTree());
        }
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        if (tree.condition() != null && !this.isSafeBooleanExpression(tree.condition())) {
            this.scan(tree.initializer());
            this.scan(tree.update());
            this.scan(tree.statement());
        } else {
            super.visitForStatement(tree);
        }
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        if (!this.isSafeBooleanExpression(tree.condition())) {
            this.scan(tree.statement());
        } else {
            super.visitWhileStatement(tree);
        }
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        if (!this.isSafeBooleanExpression(tree.condition())) {
            this.scan(tree.statement());
        } else {
            super.visitDoWhileStatement(tree);
        }
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        if (!this.isSafeBooleanExpression(tree.condition())) {
            this.scan(tree.thenStatement());
            this.scan(tree.elseStatement());
        } else {
            super.visitIfStatement(tree);
        }
    }

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        if (!this.isSafeBooleanExpression(tree.condition())) {
            this.scan(tree.trueExpression());
            this.scan(tree.falseExpression());
        } else {
            super.visitConditionalExpression(tree);
        }
    }

    private boolean isSafeBooleanExpression(ExpressionTree tree) {
        ExpressionTree boxedBoolean = BoxedBooleanExpressionsCheck.findBoxedBoolean(tree);
        if (boxedBoolean != null) {
            if (BoxedBooleanExpressionsCheck.isFirstUsageANullCheck(boxedBoolean)) {
                return true;
            }
            ((InternalJavaIssueBuilder)QuickFixHelper.newIssue(this.context).forRule(this).onTree(boxedBoolean).withMessage("Use the primitive boolean expression here.").withQuickFixes(() -> BoxedBooleanExpressionsCheck.getQuickFix(tree, boxedBoolean))).report();
            return false;
        }
        return true;
    }

    private static boolean isFirstUsageANullCheck(ExpressionTree boxedBoolean) {
        if (boxedBoolean.is(Tree.Kind.IDENTIFIER)) {
            IdentifierTree identifier = (IdentifierTree)boxedBoolean;
            List<IdentifierTree> usages = identifier.symbol().usages();
            Tree firstUsage = usages.get(0).parent();
            if (firstUsage.is(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO) && BoxedBooleanExpressionsCheck.isNullCheck((ExpressionTree)firstUsage)) {
                return true;
            }
            if (usages.size() == 1) {
                return false;
            }
            Optional<ExpressionTree> firstNullCheck = BoxedBooleanExpressionsCheck.getFirstNullCheck(identifier.symbol());
            if (!firstNullCheck.isPresent()) {
                return false;
            }
            Optional<IfStatementTree> ifStatementWithNullCheck = BoxedBooleanExpressionsCheck.getParentConditionalBranch(firstNullCheck.get());
            Optional<IfStatementTree> ifStatementWithFirstUsage = BoxedBooleanExpressionsCheck.getParentConditionalBranch(firstUsage);
            return ifStatementWithNullCheck.equals(ifStatementWithFirstUsage);
        }
        return false;
    }

    private static Optional<ExpressionTree> getFirstNullCheck(Symbol symbol) {
        if (firstNullCheckCache.containsKey(symbol)) {
            return Optional.ofNullable(firstNullCheckCache.get(symbol));
        }
        Optional<ExpressionTree> firstNullCheck = symbol.usages().stream().map(Tree::parent).filter(tree -> tree.is(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO) && BoxedBooleanExpressionsCheck.isNullCheck((ExpressionTree)tree)).map(ExpressionTree.class::cast).findFirst();
        firstNullCheckCache.put(symbol, firstNullCheck.orElse(null));
        return firstNullCheck;
    }

    private static Optional<IfStatementTree> getParentConditionalBranch(Tree tree) {
        ArrayDeque<Tree> trees = new ArrayDeque<Tree>();
        IfStatementTree ifStatementTree = null;
        for (Tree current = tree; current != null && ifStatementTree == null; current = current.parent()) {
            if (ifStatementCache.containsKey(tree)) {
                ifStatementTree = ifStatementCache.get(tree);
            } else if (current.is(Tree.Kind.IF_STATEMENT)) {
                ifStatementTree = (IfStatementTree)current;
            }
            trees.add(current);
        }
        while (!trees.isEmpty()) {
            ifStatementCache.put((Tree)trees.pop(), ifStatementTree);
        }
        return Optional.ofNullable(ifStatementTree);
    }

    @CheckForNull
    private static ExpressionTree findBoxedBoolean(ExpressionTree tree) {
        if (tree.symbolType().is(BOOLEAN) && !BoxedBooleanExpressionsCheck.isValidMethodInvocation(tree)) {
            return tree;
        }
        if (tree.is(Tree.Kind.LOGICAL_COMPLEMENT)) {
            return BoxedBooleanExpressionsCheck.findBoxedBoolean(((UnaryExpressionTree)tree).expression());
        }
        if (tree instanceof BinaryExpressionTree) {
            BinaryExpressionTree expr = (BinaryExpressionTree)tree;
            if (BoxedBooleanExpressionsCheck.findBoxedBoolean(expr.leftOperand()) != null && expr.rightOperand().symbolType().isPrimitive(Type.Primitives.BOOLEAN)) {
                return expr.leftOperand();
            }
            if (BoxedBooleanExpressionsCheck.findBoxedBoolean(expr.rightOperand()) != null && expr.leftOperand().symbolType().isPrimitive(Type.Primitives.BOOLEAN) && !BoxedBooleanExpressionsCheck.isNullCheck(expr.leftOperand())) {
                return expr.rightOperand();
            }
        }
        return null;
    }

    private static boolean isNullCheck(ExpressionTree tree) {
        if (tree.is(Tree.Kind.NOT_EQUAL_TO, Tree.Kind.EQUAL_TO)) {
            BinaryExpressionTree expr = (BinaryExpressionTree)tree;
            return expr.leftOperand().is(Tree.Kind.NULL_LITERAL) || expr.rightOperand().is(Tree.Kind.NULL_LITERAL);
        }
        return false;
    }

    private static boolean isValidMethodInvocation(ExpressionTree tree) {
        if (tree.is(Tree.Kind.METHOD_INVOCATION)) {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            return BoxedBooleanExpressionsCheck.isOptionalInvocation(mit) || BoxedBooleanExpressionsCheck.isAnnotatedNonnull(mit);
        }
        return false;
    }

    private static boolean isOptionalInvocation(MethodInvocationTree mit) {
        return OPTIONAL_ORELSE.matches(mit) && !((ExpressionTree)mit.arguments().get(0)).is(Tree.Kind.NULL_LITERAL);
    }

    private static boolean isAnnotatedNonnull(MethodInvocationTree mit) {
        return mit.symbol().metadata().annotations().stream().map(SymbolMetadata.AnnotationInstance::symbol).map(Symbol::name).anyMatch(name -> name.equalsIgnoreCase("nonNull") || name.equalsIgnoreCase("notNull"));
    }

    private static List<JavaQuickFix> getQuickFix(ExpressionTree tree, ExpressionTree boxedBoolean) {
        if (tree.is(Tree.Kind.METHOD_INVOCATION) && OPTIONAL_ORELSE.matches((MethodInvocationTree)tree)) {
            return Collections.emptyList();
        }
        ArrayList<JavaTextEdit> edits = new ArrayList<JavaTextEdit>(2);
        if (tree.is(Tree.Kind.LOGICAL_COMPLEMENT)) {
            edits.add(JavaTextEdit.replaceTree(((UnaryExpressionTree)tree).operatorToken(), "Boolean.FALSE.equals("));
        } else {
            edits.add(JavaTextEdit.insertBeforeTree(boxedBoolean, "Boolean.TRUE.equals("));
        }
        edits.add(JavaTextEdit.insertAfterTree(boxedBoolean, ")"));
        return Collections.singletonList(JavaQuickFix.newQuickFix("Use the primitive boolean expression").addTextEdits(edits).build());
    }
}

