/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3631")
public class ArraysAsListOfPrimitiveToStreamCheck
extends AbstractMethodDetection {
    private static final MethodMatchers ARRAYS_AS_LIST = MethodMatchers.create().ofTypes("java.util.Arrays").names("asList").withAnyParameters().build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes("java.util.List").names("stream").addWithoutParametersMatcher().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        MethodInvocationTree arrayAsListInvocation;
        ExpressionTree expression;
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(Tree.Kind.MEMBER_SELECT) && (expression = ((MemberSelectExpressionTree)methodSelect).expression()).is(Tree.Kind.METHOD_INVOCATION) && ARRAYS_AS_LIST.matches(arrayAsListInvocation = (MethodInvocationTree)expression) && ArraysAsListOfPrimitiveToStreamCheck.shouldUsePrimitiveStream(arrayAsListInvocation)) {
            this.reportIssue(arrayAsListInvocation.methodSelect(), "Use \"Arrays.stream\" instead of \"Arrays.asList\".");
        }
    }

    private static boolean shouldUsePrimitiveStream(MethodInvocationTree mit) {
        Set<Type> argumentTypes = ArraysAsListOfPrimitiveToStreamCheck.argumentTypes(mit.arguments());
        return argumentTypes.size() == 1 && ArraysAsListOfPrimitiveToStreamCheck.isPrimitiveTypeHandledByStream(argumentTypes.iterator().next());
    }

    private static Set<Type> argumentTypes(Arguments arguments) {
        return arguments.stream().map(ExpressionTree::symbolType).collect(Collectors.toSet());
    }

    private static boolean isPrimitiveTypeHandledByStream(Type type) {
        return type.isPrimitive(Type.Primitives.INT) || type.isPrimitive(Type.Primitives.DOUBLE) || type.isPrimitive(Type.Primitives.LONG);
    }
}

