/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1197")
public class ArrayDesignatorOnVariableCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.VARIABLE);
    }

    @Override
    public void visitNode(Tree tree) {
        VariableTree variableTree = (VariableTree)tree;
        IdentifierTree identifierTree = variableTree.simpleName();
        MisplacedArray.find(variableTree.type(), identifierTree.identifierToken()).ifPresent(misplaced -> ((InternalJavaIssueBuilder)QuickFixHelper.newIssue(this.context).forRule(this).onRange(identifierTree, misplaced.lastArray.closeBracketToken()).withMessage("Move the array designators " + misplaced.replacement + " to the type.").withQuickFixes(() -> ArrayDesignatorOnVariableCheck.isDeclarationTypeUsedBySeveralVariable(variableTree) ? Collections.emptyList() : Collections.singletonList(ArrayDesignatorOnVariableCheck.createQuickFix(misplaced, "variable type")))).report());
    }

    static JavaQuickFix createQuickFix(MisplacedArray misplaced, String type) {
        return JavaQuickFix.newQuickFix("Move " + misplaced.replacement + " to the " + type).addTextEdit(JavaTextEdit.removeBetweenTree(misplaced.firstArray.openBracketToken(), misplaced.lastArray.closeBracketToken())).addTextEdit(JavaTextEdit.insertAfterTree(misplaced.firstArray.type(), misplaced.replacement)).build();
    }

    private static boolean isDeclarationTypeUsedBySeveralVariable(VariableTree current) {
        return QuickFixHelper.previousVariable(current).isPresent() || QuickFixHelper.nextVariable(current).isPresent();
    }

    static class MisplacedArray {
        ArrayTypeTree firstArray;
        ArrayTypeTree lastArray;
        String replacement;

        private MisplacedArray(ArrayTypeTree lastArrayType, SyntaxToken identifierToken) {
            ArrayTypeTree previous;
            this.firstArray = lastArrayType;
            this.lastArray = lastArrayType;
            StringBuilder replacementBuilder = new StringBuilder("[]");
            while (this.firstArray.type().is(Tree.Kind.ARRAY_TYPE) && MisplacedArray.isInvalidPosition(previous = (ArrayTypeTree)this.firstArray.type(), identifierToken)) {
                replacementBuilder.append("[]");
                this.firstArray = previous;
            }
            this.replacement = replacementBuilder.toString();
        }

        static Optional<MisplacedArray> find(@Nullable TypeTree type, SyntaxToken identifierToken) {
            return Optional.ofNullable(type).filter(t -> t.is(Tree.Kind.ARRAY_TYPE)).map(ArrayTypeTree.class::cast).filter(arrayType -> MisplacedArray.isInvalidPosition(arrayType, identifierToken)).map(arrayType -> new MisplacedArray((ArrayTypeTree)arrayType, identifierToken));
        }

        private static boolean isInvalidPosition(ArrayTypeTree arrayTypeTree, SyntaxToken identifierToken) {
            SyntaxToken openBracketToken = arrayTypeTree.openBracketToken();
            return openBracketToken != null && identifierToken.range().start().isBefore(openBracketToken.range().start());
        }
    }
}

