/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public abstract class AbstractCreateTempFileChecker
extends BaseTreeVisitor
implements JavaFileScanner,
JavaVersionAwareVisitor {
    private static final String JAVA_IO_FILE = "java.io.File";
    private static final MethodMatchers FILE_CREATE_TEMP_FILE = MethodMatchers.create().ofTypes("java.io.File").names("createTempFile").withAnyParameters().build();
    private static final MethodMatchers FILE_DELETE = MethodMatchers.create().ofTypes("java.io.File").names("delete").addWithoutParametersMatcher().build();
    private static final MethodMatchers FILE_MKDIR = MethodMatchers.create().ofTypes("java.io.File").names("mkdir").addWithoutParametersMatcher().build();
    private final Deque<Map<Symbol, State>> symbolStack = new LinkedList<Map<Symbol, State>>();
    protected JavaFileScannerContext context;

    public abstract String getMessage();

    @Override
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava7Compatible();
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitMethod(MethodTree tree) {
        this.symbolStack.push(new HashMap());
        super.visitMethod(tree);
        this.symbolStack.pop();
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        ExpressionTree variable;
        super.visitAssignmentExpression(tree);
        if (AbstractCreateTempFileChecker.isFileCreateTempFile(tree.expression()) && (variable = tree.variable()).is(Tree.Kind.IDENTIFIER) && !this.symbolStack.isEmpty()) {
            this.symbolStack.peek().put(((IdentifierTree)variable).symbol(), State.CREATE_TMP_FILE);
        }
    }

    @Override
    public void visitVariable(VariableTree tree) {
        super.visitVariable(tree);
        ExpressionTree initializer = tree.initializer();
        if (initializer != null && AbstractCreateTempFileChecker.isFileCreateTempFile(initializer)) {
            Symbol symbol = tree.symbol();
            if (!this.symbolStack.isEmpty()) {
                this.symbolStack.peek().put(symbol, State.CREATE_TMP_FILE);
            }
        }
    }

    private static boolean isFileCreateTempFile(ExpressionTree givenExpression) {
        ExpressionTree expressionTree = ExpressionUtils.skipParentheses(givenExpression);
        return expressionTree.is(Tree.Kind.METHOD_INVOCATION) && FILE_CREATE_TEMP_FILE.matches((MethodInvocationTree)expressionTree);
    }

    @Override
    public void visitMethodInvocation(MethodInvocationTree mit) {
        super.visitMethodInvocation(mit);
        if (FILE_DELETE.matches(mit)) {
            this.checkAndAdvanceState(mit, State.CREATE_TMP_FILE, State.DELETE);
        } else if (FILE_MKDIR.matches(mit) && State.MKDIR.equals((Object)this.checkAndAdvanceState(mit, State.DELETE, State.MKDIR))) {
            this.context.reportIssue(this, ExpressionUtils.methodName(mit), this.getMessage());
        }
    }

    @Nullable
    private State checkAndAdvanceState(MethodInvocationTree mit, State requiredState, State nextState) {
        ExpressionTree expressionTree;
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(Tree.Kind.MEMBER_SELECT) && (expressionTree = ((MemberSelectExpressionTree)methodSelect).expression()).is(Tree.Kind.IDENTIFIER)) {
            Symbol symbol = ((IdentifierTree)expressionTree).symbol();
            Map<Symbol, State> symbolStateMap = this.symbolStack.peek();
            if (symbolStateMap != null && symbolStateMap.containsKey(symbol) && requiredState.equals((Object)symbolStateMap.get(symbol))) {
                symbolStateMap.put(symbol, nextState);
                return nextState;
            }
        }
        return null;
    }

    private static enum State {
        CREATE_TMP_FILE,
        DELETE,
        MKDIR;

    }
}

