/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.AnalysisException;
import org.sonar.java.Preconditions;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.classpath.ClasspathForMain;
import org.sonar.java.classpath.ClasspathForTest;
import org.sonar.java.model.JProblem;
import org.sonar.java.model.LineUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaIssue;
import org.sonar.plugins.java.api.CheckRegistrar;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JspCodeVisitor;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.sonarsource.sonarlint.plugin.api.SonarLintRuntime;

@ScannerSide
@SonarLintSide
public class SonarComponents {
    private static final Logger LOG = Loggers.get(SonarComponents.class);
    private static final int LOGGED_MAX_NUMBER_UNDEFINED_TYPES = 50;
    public static final String FAIL_ON_EXCEPTION_KEY = "sonar.internal.analysis.failFast";
    public static final String SONAR_BATCH_MODE_KEY = "sonar.java.internal.batchMode";
    public static final String SONAR_BATCH_SIZE_KEY = "sonar.java.experimental.batchModeSizeInKB";
    private static final Version SONARLINT_6_3 = Version.parse((String)"6.3");
    private final FileLinesContextFactory fileLinesContextFactory;
    private final ClasspathForMain javaClasspath;
    private final ClasspathForTest javaTestClasspath;
    private final Set<JProblem> undefinedTypes = new HashSet<JProblem>();
    private final CheckFactory checkFactory;
    @Nullable
    private final ProjectDefinition projectDefinition;
    private final FileSystem fs;
    private final List<JavaCheck> mainChecks;
    private final List<JavaCheck> testChecks;
    private final List<JavaCheck> jspChecks;
    private final List<Checks<JavaCheck>> allChecks;
    private SensorContext context;
    private Method methodSetQuickFixAvailable;

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, FileSystem fs, ClasspathForMain javaClasspath, ClasspathForTest javaTestClasspath, CheckFactory checkFactory) {
        this(fileLinesContextFactory, fs, javaClasspath, javaTestClasspath, checkFactory, null, null);
    }

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, FileSystem fs, ClasspathForMain javaClasspath, ClasspathForTest javaTestClasspath, CheckFactory checkFactory, @Nullable CheckRegistrar[] checkRegistrars) {
        this(fileLinesContextFactory, fs, javaClasspath, javaTestClasspath, checkFactory, checkRegistrars, null);
    }

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, FileSystem fs, ClasspathForMain javaClasspath, ClasspathForTest javaTestClasspath, CheckFactory checkFactory, @Nullable ProjectDefinition projectDefinition) {
        this(fileLinesContextFactory, fs, javaClasspath, javaTestClasspath, checkFactory, null, projectDefinition);
    }

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, FileSystem fs, ClasspathForMain javaClasspath, ClasspathForTest javaTestClasspath, CheckFactory checkFactory, @Nullable CheckRegistrar[] checkRegistrars, @Nullable ProjectDefinition projectDefinition) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.fs = fs;
        this.javaClasspath = javaClasspath;
        this.javaTestClasspath = javaTestClasspath;
        this.checkFactory = checkFactory;
        this.projectDefinition = projectDefinition;
        this.mainChecks = new ArrayList<JavaCheck>();
        this.testChecks = new ArrayList<JavaCheck>();
        this.jspChecks = new ArrayList<JavaCheck>();
        this.allChecks = new ArrayList<Checks<JavaCheck>>();
        if (checkRegistrars != null) {
            CheckRegistrar.RegistrarContext registrarContext = new CheckRegistrar.RegistrarContext();
            for (CheckRegistrar checkClassesRegister : checkRegistrars) {
                checkClassesRegister.register(registrarContext);
                List<Class<? extends JavaCheck>> checkClasses = SonarComponents.getChecks(registrarContext.checkClasses());
                List<Class<? extends JavaCheck>> testCheckClasses = SonarComponents.getChecks(registrarContext.testCheckClasses());
                this.registerMainCheckClasses(registrarContext.repositoryKey(), checkClasses);
                this.registerTestCheckClasses(registrarContext.repositoryKey(), testCheckClasses);
            }
        }
        try {
            this.methodSetQuickFixAvailable = NewIssue.class.getMethod("setQuickFixAvailable", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            this.methodSetQuickFixAvailable = null;
        }
    }

    private static List<Class<? extends JavaCheck>> getChecks(@Nullable Iterable<Class<? extends JavaCheck>> iterable) {
        return iterable != null ? StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList()) : Collections.emptyList();
    }

    public void setSensorContext(SensorContext context) {
        this.context = context;
    }

    public FileLinesContext fileLinesContextFor(InputFile inputFile) {
        return this.fileLinesContextFactory.createFor(inputFile);
    }

    public NewSymbolTable symbolizableFor(InputFile inputFile) {
        return this.context.newSymbolTable().onFile(inputFile);
    }

    public NewHighlighting highlightableFor(InputFile inputFile) {
        Objects.requireNonNull(this.context);
        return this.context.newHighlighting().onFile(inputFile);
    }

    public List<File> getJavaClasspath() {
        if (this.javaClasspath == null) {
            return new ArrayList<File>();
        }
        return this.javaClasspath.getElements();
    }

    public boolean inAndroidContext() {
        return this.javaClasspath.inAndroidContext();
    }

    public List<File> getJavaTestClasspath() {
        return this.javaTestClasspath.getElements();
    }

    public List<File> getJspClasspath() {
        ArrayList<File> jspClasspath = new ArrayList<File>();
        jspClasspath.add(SonarComponents.findPluginJar());
        jspClasspath.addAll(this.getJavaClasspath());
        return jspClasspath;
    }

    private static File findPluginJar() {
        try {
            return new File(SonarComponents.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to obtain plugin jar.", e);
        }
    }

    public void registerMainCheckClasses(String repositoryKey, Iterable<Class<? extends JavaCheck>> checkClasses) {
        this.registerCheckClasses(this.mainChecks, repositoryKey, checkClasses);
    }

    public void registerTestCheckClasses(String repositoryKey, Iterable<Class<? extends JavaCheck>> checkClasses) {
        this.registerCheckClasses(this.testChecks, repositoryKey, checkClasses);
    }

    private void registerCheckClasses(List<JavaCheck> destinationList, String repositoryKey, Iterable<Class<? extends JavaCheck>> checkClasses) {
        Checks createdChecks = this.checkFactory.create(repositoryKey).addAnnotatedChecks(checkClasses);
        this.allChecks.add((Checks<JavaCheck>)createdChecks);
        HashMap<Class<? extends JavaCheck>, Integer> classIndexes = new HashMap<Class<? extends JavaCheck>, Integer>();
        int i = 0;
        for (Class<? extends JavaCheck> checkClass : checkClasses) {
            classIndexes.put(checkClass, i);
            ++i;
        }
        List orderedChecks = createdChecks.all().stream().sorted(Comparator.comparing(check -> classIndexes.getOrDefault(check.getClass(), Integer.MAX_VALUE))).collect(Collectors.toList());
        destinationList.addAll(orderedChecks);
        this.jspChecks.addAll(orderedChecks.stream().filter(JspCodeVisitor.class::isInstance).collect(Collectors.toList()));
    }

    public List<JavaCheck> mainChecks() {
        return this.mainChecks;
    }

    public List<JavaCheck> testChecks() {
        return this.testChecks;
    }

    public List<JavaCheck> jspChecks() {
        return this.jspChecks;
    }

    public Optional<RuleKey> getRuleKey(JavaCheck check) {
        return this.allChecks.stream().map(sonarChecks -> sonarChecks.ruleKey((Object)check)).filter(Objects::nonNull).findFirst();
    }

    public void addIssue(InputComponent inputComponent, JavaCheck check, int line, String message, @Nullable Integer cost) {
        this.reportIssue(new AnalyzerMessage(check, inputComponent, line, message, cost != null ? cost : 0));
    }

    public void reportIssue(AnalyzerMessage analyzerMessage) {
        JavaCheck check = analyzerMessage.getCheck();
        Objects.requireNonNull(check);
        Objects.requireNonNull(analyzerMessage.getMessage());
        this.getRuleKey(check).ifPresent(key -> {
            InputComponent inputComponent = analyzerMessage.getInputComponent();
            if (inputComponent == null) {
                return;
            }
            Double cost = analyzerMessage.getCost();
            this.reportIssue(analyzerMessage, (RuleKey)key, inputComponent, cost);
        });
    }

    @VisibleForTesting
    void reportIssue(AnalyzerMessage analyzerMessage, RuleKey key, InputComponent fileOrProject, @Nullable Double cost) {
        Objects.requireNonNull(this.context);
        JavaIssue issue = JavaIssue.create(this.context, key, cost);
        AnalyzerMessage.TextSpan textSpan = analyzerMessage.primaryLocation();
        if (textSpan == null) {
            issue.setPrimaryLocationOnComponent(fileOrProject, analyzerMessage.getMessage());
        } else {
            if (!textSpan.onLine()) {
                Preconditions.checkState(!textSpan.isEmpty(), "Issue location should not be empty");
            }
            issue.setPrimaryLocation((InputFile)fileOrProject, analyzerMessage.getMessage(), textSpan.startLine, textSpan.startCharacter, textSpan.endLine, textSpan.endCharacter);
        }
        if (!analyzerMessage.flows.isEmpty()) {
            issue.addFlow((InputFile)analyzerMessage.getInputComponent(), analyzerMessage.flows);
        }
        issue.save();
    }

    public boolean reportAnalysisError(RecognitionException re, InputFile inputFile) {
        this.reportAnalysisError(inputFile, re.getMessage());
        return this.isSonarLintContext();
    }

    private void reportAnalysisError(InputFile inputFile, String message) {
        this.context.newAnalysisError().onFile(inputFile).message(message).save();
    }

    public boolean isSonarLintContext() {
        return this.context.runtime().getProduct() == SonarProduct.SONARLINT;
    }

    public boolean isQuickFixCompatible() {
        return this.isSonarLintContext() && ((SonarLintRuntime)this.context.runtime()).getSonarLintPluginApiVersion().isGreaterThanOrEqual(SONARLINT_6_3);
    }

    @Nullable
    public Method getMethodSetQuickFixAvailable() {
        return this.methodSetQuickFixAvailable;
    }

    public List<String> fileLines(InputFile inputFile) {
        return LineUtils.splitLines(this.inputFileContents(inputFile));
    }

    public String inputFileContents(InputFile inputFile) {
        try {
            return inputFile.contents();
        }
        catch (IOException e) {
            throw new AnalysisException(String.format("Unable to read file '%s'", inputFile), e);
        }
    }

    public boolean analysisCancelled() {
        return this.context.isCancelled();
    }

    public boolean shouldFailAnalysisOnException() {
        return this.context.config().getBoolean(FAIL_ON_EXCEPTION_KEY).orElse(false);
    }

    public boolean isBatchModeEnabled() {
        return this.context.config().getBoolean(SONAR_BATCH_MODE_KEY).orElse(false) != false || this.context.config().hasKey(SONAR_BATCH_SIZE_KEY);
    }

    public boolean isAutoScan() {
        return this.context.config().getBoolean(SONAR_BATCH_MODE_KEY).orElse(false) != false && !this.context.config().hasKey(SONAR_BATCH_SIZE_KEY);
    }

    public long getBatchModeSizeInKB() {
        return this.context.config().getLong(SONAR_BATCH_SIZE_KEY).orElse(-1L);
    }

    public File workDir() {
        ProjectDefinition current = this.projectDefinition;
        if (current == null) {
            return this.fs.workDir();
        }
        while (current.getParent() != null) {
            current = current.getParent();
        }
        return current.getWorkDir();
    }

    public InputComponent project() {
        return this.context.project();
    }

    public void collectUndefinedTypes(Set<JProblem> undefinedTypes) {
        this.undefinedTypes.addAll(undefinedTypes);
    }

    public void logUndefinedTypes() {
        if (!this.undefinedTypes.isEmpty()) {
            this.javaClasspath.logSuspiciousEmptyLibraries();
            this.javaTestClasspath.logSuspiciousEmptyLibraries();
            this.logUndefinedTypes(50);
            this.undefinedTypes.clear();
        }
    }

    private void logUndefinedTypes(int maxLines) {
        SonarComponents.logParserMessages(this.undefinedTypes.stream().filter(m -> m.type() == JProblem.Type.UNDEFINED_TYPE), maxLines, "Unresolved imports/types have been detected during analysis. Enable DEBUG mode to see them.", "Unresolved imports/types:");
        SonarComponents.logParserMessages(this.undefinedTypes.stream().filter(m -> m.type() == JProblem.Type.PREVIEW_FEATURE_USED), maxLines, "Use of preview features have been detected during analysis. Enable DEBUG mode to see them.", "Use of preview features:");
    }

    private static void logParserMessages(Stream<JProblem> messages, int maxLines, String warningMessage, String debugMessage) {
        boolean moreThanMax;
        List messagesList = messages.map(Object::toString).sorted().collect(Collectors.toList());
        int messagesListSize = messagesList.size();
        if (messagesListSize == 0) {
            return;
        }
        boolean bl = moreThanMax = messagesListSize > maxLines;
        if (moreThanMax) {
            debugMessage = (String)debugMessage + " (Limited to " + maxLines + ")";
        }
        String delimiter = System.lineSeparator() + "- ";
        String prefix = (String)debugMessage + delimiter;
        Object suffix = moreThanMax ? delimiter + "..." : "";
        LOG.warn(warningMessage);
        LOG.debug(messagesList.stream().limit(maxLines).collect(Collectors.joining(delimiter, prefix, (CharSequence)suffix)));
    }

    public SensorContext context() {
        return this.context;
    }
}

